<?php

namespace BWFCRM\Actions\Autonami;

use BWFCRM\Actions\Base;
use BWFCRM\Calls\Autonami as Calls;
use WP_Error;

/**
 * Add lists action class
 */
class Add_To_Lists extends Base {

	/**
	 * Class constructor
	 */
	public function __construct() {
		$this->slug        = 'add_to_lists';
		$this->nice_name   = 'Add Lists';
		$this->group       = 'autonami';
		$this->group_label = 'FunnelKit Automations';
		$this->priority    = 10;
		$this->support     = [ 1, 2 ];
		$this->event_slug  = 'crm_assigned_list';
	}

	/**
	 * Add list field schema
	 *
	 * @return array
	 */
	public function get_action_schema() {
		return [
			'type' => 'search',
			'meta' => [
				'autocompleter' => 'list',
				'addnew'        => true,
			]
		];
	}

	/**
	 * process action
	 *
	 * @param $contact \BWFCRM_Contact
	 * @param $lists
	 *
	 * @return array|false
	 */
	public function handle_action( $contact, $lists ) {

		$contact_lists = $contact->get_lists();

		// format list data
		$lists = array_map( function ( $list ) {
			if ( ! empty( $list ) && isset( $list['name'] ) ) {
				$list['value'] = $list['name'];
				unset( $list['name'] );
			}

			return $list;
		}, $lists );

		if ( empty( $lists ) ) {
			return 'skip';
		}

		/**
		 * Check if call exists
		 */
		if ( ! class_exists( 'BWFCRM\Calls\Autonami\Add_To_Lists' ) ) {
			return false;
		}

		$call_obj = new Calls\Add_To_Lists();

		/**
		 * Process call
		 */
		$lists_added = $call_obj->process_call( $contact, $lists );

		return $this->get_response( $lists, $lists_added );
	}

	public function get_response( $lists, $lists_added ) {
		$message = array();
		if ( $lists_added instanceof WP_Error ) {
			$message[] = __( 'List(s) Add Failed: ', 'wp-marketing-automations-crm' ) . array_reduce( $lists, function ( $carry, $item ) {
					$name = $item['value'];
					if ( empty( $carry ) ) {
						return $name;
					}

					return ! empty( $name ) ? $carry . ', ' . $name : $carry;
				}, '' );
			$message[] = __( 'List(s) Add Failed. Error: ', 'wp-marketing-automations-crm' ) . $lists_added->get_error_message();

			return array(
				'status'  => self::$RESPONSE_FAILED,
				'message' => $message,
			);
		}

		if ( isset( $lists_added['skipped'] ) && count( $lists_added['skipped'] ) > 0 ) {
			$message[] = __( 'List(s) Add Skipped: ', 'wp-marketing-automations-crm' ) . array_reduce( $lists_added['skipped'], function ( $carry, $item ) {
					$name = $item->get_name();
					if ( empty( $carry ) ) {
						return $name;
					}

					return ! empty( $name ) ? $carry . ', ' . $name : $carry;
				}, '' );
		}

		if ( isset( $lists_added['assigned'] ) && count( $lists_added['assigned'] ) > 0 ) {
			$message[] = __( 'List(s) Added: ', 'wp-marketing-automations-crm' ) . array_reduce( $lists_added['assigned'], function ( $carry, $item ) {
					$name = $item->get_name();
					if ( empty( $carry ) ) {
						return $name;
					}

					return ! empty( $name ) ? $carry . ', ' . $name : $carry;
				}, '' );
		}

		return array(
			'status'  => self::$RESPONSE_SUCCESS,
			'message' => $message,
		);
	}
}

/**
 * Register action
 */
BWFCRM_Core()->actions->register_action( 'add_to_lists', 'BWFCRM\Actions\Autonami\Add_To_Lists', 'Add Lists', 'autonami', 'FunnelKit Automations' );
