<?php

/**
 * Create bulk action API
 */
class BWFCRM_Api_Create_Bulk_Action extends BWFCRM_API_Base {

	public static $ins;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function __construct() {
		parent::__construct();
		$this->method        = WP_REST_Server::CREATABLE;
		$this->route         = '/bulk-action';
		$this->response_code = 200;
	}

	public function default_args_values() {
		return array(
			'title' => '',
		);
	}

	public function process_api_call() {
		$title = $this->get_sanitized_arg( 'title', 'text_field', $this->args['title'] );

		if ( empty( $title ) ) {
			$this->response_code = 400;
			$response            = __( 'Oops Title not entered, enter title to create bulk action', 'wp-marketing-automations-crm' );

			return $this->error_response( $response );
		}

		$already_exists = BWFAN_Model_Bulk_Action::check_bulk_action_exists_with( 'title', $title );

		if ( $already_exists ) {
			$this->response_code = 400;
			$response            = __( 'Bulk Action already exists with title : ', 'wp-marketing-automations-crm' ) . $title;

			return $this->error_response( $response );
		}

		$create_time = current_time( 'mysql', 1 );

		$data = [
			'title'      => $title,
			'status'     => 0,
			'created_by' => get_current_user_id(),
			'created_at' => $create_time,
			'updated_at' => $create_time,
		];

		$result = BWFAN_Model_Bulk_Action::bwfan_create_new_bulk_action( $data );
		if ( empty( $result ) ) {
			$this->response_code = 500;

			return $this->error_response( __( 'Unable to create bulk action', 'wp-marketing-automations-crm' ) );
		}

		return $this->success_response( [ 'id' => $result ], __( 'Bulk action created', 'wp-marketing-automations-crm' ) );
	}
}

BWFCRM_API_Loader::register( 'BWFCRM_Api_Create_Bulk_Action' );
