<?php
/**
 * Merge Tag: Contact Field
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BWFCRM_Contact_Field
 */
class BWFCRM_Contact_Field extends BWFCRM_Merge_Tag_Base {
	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		$this->_tag_name        = __( 'Fields', 'wp-marketing-automations-crm' );
		$this->_tag_description = __( 'Fields', 'wp-marketing-automations-crm' );
	}

	public function get_value( $data = array() ) {
		if ( ! isset( $data['contact_id'] ) || empty( $data['contact_id'] ) ) {
			return BWFCRM_Common::crm_error( __( 'No Contact ID passed in merge tag', 'wp-marketing-automations-crm' ) );
		}

		if ( ! isset( $data['key'] ) || empty( $data['key'] ) ) {
			return BWFCRM_Common::crm_error( __( 'No Contact field name provided', 'wp-marketing-automations-crm' ) );
		}

		$cid   = absint( $data['contact_id'] );
		$value = $this->get_field_value( $cid, $data['key'] );
		if ( false !== $value ) {
			return $value;
		}

		return '';
	}

	/**
	 * Return value by key
	 *
	 * @param $cid
	 * @param $key
	 *
	 * @return false|mixed|string|null
	 */
	public function get_field_value( $cid, $key ) {
		$cid = absint( $cid );
		if ( 0 === $cid ) {
			return false;
		}
		$contact = new BWFCRM_Contact( $cid );
		if ( ! $contact->is_contact_exists() ) {
			return false;
		}

		$value = $contact->get_field_by_slug( $key );

		$field_type = $this->get_field_type( $key );
		if ( BWFCRM_Fields::$TYPE_DATE === absint( $field_type ) ) {
			$value = $this->get_formatted_date_value( $value );
		} elseif ( BWFCRM_Fields::$TYPE_CHECKBOX === absint( $field_type ) ) {
			$temp_value = json_decode( $value, true );
			if ( is_array( $temp_value ) && count( $temp_value ) > 0 ) {
				$value = implode( ', ', $temp_value );
			}
		}

		return $value;
	}

	/**
	 * @param $field_key
	 *
	 * @return mixed|void
	 */
	public function get_field_type( $field_key ) {
		$field_data = BWFAN_Model_Fields::get_field_by_slug( $field_key );
		if ( ! isset( $field_data['type'] ) || empty( $field_data['type'] ) ) {
			return;
		}

		return $field_data['type'];
	}

	public function get_dummy_value( $data = array() ) {
		return $this->get_value( $data );
	}
}

BWFCRM_Core()->merge_tags->register( 'contact_field', 'BWFCRM_Contact_Field', 'contact_fields' );