<?php
/**
 * Merge Tag: Contact Address
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class BWFCRM_Contact_Address_1 extends BWFCRM_Merge_Tag_Base {
	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		$this->_tag_name        = __( 'Address 1', 'wp-marketing-automations-crm' );
		$this->_tag_description = __( 'Address 1', 'wp-marketing-automations-crm' );
	}

	public function get_value( $data = array() ) {
		if ( ! isset( $data['contact_id'] ) || empty( $data['contact_id'] ) ) {
			return BWFCRM_Common::crm_error( __( 'No Contact ID passed in merge tag', 'wp-marketing-automations-crm' ) );
		}

		$contact_id = absint( $data['contact_id'] );
		$contact    = new BWFCRM_Contact( $contact_id );
		if ( ! $contact->is_contact_exists() ) {
			return BWFCRM_Common::crm_error( __( "No contact found with ID: $contact_id", 'wp-marketing-automations-crm' ) );
		}

		return $contact->get_address_1();
	}

	public function get_dummy_value( $data = array() ) {
		return $this->get_value( $data );
	}
}

BWFCRM_Core()->merge_tags->register( 'contact_address_1', 'BWFCRM_Contact_Address_1', 'contact' );