<?php
/**
 * Merge Tag: Contact Marketing Status
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class BWFCRM_Contact_Marketing_Status
 */
class BWFCRM_Contact_Marketing_Status extends BWFCRM_Merge_Tag_Base {
	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self;
		}

		return self::$ins;
	}

	public function __construct() {
		$this->_tag_name        = __( 'Status', 'wp-marketing-automations-crm' );
		$this->_tag_description = __( 'Status', 'wp-marketing-automations-crm' );
	}

	public function get_value( $data = array() ) {
		if ( ! isset( $data['contact_id'] ) || empty( $data['contact_id'] ) ) {
			return BWFCRM_Common::crm_error( __( 'No Contact ID passed in merge tag', 'wp-marketing-automations-crm' ) );
		}

		$contact_id = absint( $data['contact_id'] );
		$contact    = new BWFCRM_Contact( $contact_id );
		if ( ! $contact->is_contact_exists() ) {
			return BWFCRM_Common::crm_error( __( "No contact found with ID: $contact_id", 'wp-marketing-automations-crm' ) );
		}

		if ( ! empty( absint( $contact->get_display_status() ) ) ) {
			switch ( $contact->get_display_status() ) {
				case BWFCRM_Contact::$DISPLAY_STATUS_UNSUBSCRIBED:
					return __( 'Unsubscribed', 'wp-marketing-automations-crm' );
				case BWFCRM_Contact::$DISPLAY_STATUS_SUBSCRIBED:
					return __( 'Subscribed', 'wp-marketing-automations-crm' );
				case BWFCRM_Contact::$DISPLAY_STATUS_UNVERIFIED:
					return __( 'Unverified', 'wp-marketing-automations-crm' );
				case BWFCRM_Contact::$DISPLAY_STATUS_BOUNCED:
					return __( 'Bounced', 'wp-marketing-automations-crm' );
			}
		}

		return '';
	}

	public function get_dummy_value( $data = array() ) {
		return $this->get_value( $data );
	}
}

BWFCRM_Core()->merge_tags->register( 'contact_marketing_status', 'BWFCRM_Contact_Marketing_Status', 'contact' );
BWFCRM_Core()->merge_tags->register( 'contact_status', 'BWFCRM_Contact_Marketing_Status', 'contact' );
