<?php

/**
 * Plugin Name: UpStroke PowerPack
 * Plugin URI: https://buildwoofunnels.com
 * Class BWFAN_Pro_Compatibility_WFFN_Upsell
 */
class BWFAN_Pro_Compatibility_WFFN_Upsell {

	private static $instance = null;

	public function __construct() {
		add_action( 'wfocu_subscription_created_for_upsell', [ $this, 'upsell_subscription_created' ], 20, 3 );
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function upsell_subscription_created( $subscription, $product_hash, $order ) {
		$wcs_created_instance = BWFAN_WCS_Created::get_instance();
		if ( ! $wcs_created_instance instanceof BWFAN_Event ) {
			return;
		}
		$wcs_created_instance->subscription_created( $subscription, $order );
	}
}

if ( ! class_exists( 'WooFunnels_UpStroke_PowerPack' ) ) {
	return;
}

BWFAN_Pro_Compatibility_WFFN_Upsell::get_instance();
