<?php
/**
 * Campaign Get API file
 *
 * @package BWFCRM_API_Base
 */

/**
 * Campaign Get API class
 */
class BWFCRM_API_Get_Campaigns extends BWFCRM_API_Base {

	/**
	 * BWFCRM_Core obj
	 *
	 * @var BWFCRM_Core
	 */
	public static $ins;

	/***
	 * Total count
	 *
	 * @var int
	 */
	public $total_count = 0;

	/***
	 * Count Data
	 *
	 * @var array
	 */
	public $count_data = [];

	/**
	 * Return class instance
	 */
	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	/**
	 * Class constructor
	 */
	public function __construct() {
		parent::__construct();
		$this->method             = WP_REST_Server::READABLE;
		$this->route              = '/broadcasts';
		$this->pagination->offset = 0;
		$this->pagination->limit  = 25;
		$this->request_args       = array(
			'search'   => array(
				'description' => __( 'Search from campaign name', 'wp-marketing-automations-crm' ),
				'type'        => 'string',
			),
			'offset'   => array(
				'description' => __( 'Broadcast list Offset', 'wp-marketing-automations-crm' ),
				'type'        => 'integer',
			),
			'limit'    => array(
				'description' => __( 'Per page limit', 'wp-marketing-automations-crm' ),
				'type'        => 'integer',
			),
			'order'    => array(
				'description' => __( 'Order of the campaign list', 'wp-marketing-automations-crm' ),
				'type'        => 'string',
			),
			'order_by' => array(
				'description' => __( 'Order campaign list according to fields', 'wp-marketing-automations-crm' ),
				'type'        => 'string',
			),
			'fields'   => array(
				'description' => __( 'Comma separated fields to get', 'wp-marketing-automations-crm' ),
				'type'        => 'string',
			),
			'type'     => array(
				'description' => __( 'Broadcast type filter', 'wp-marketing-automations-crm' ),
				'type'        => 'string',
			),
			'status'   => array(
				'description' => __( 'Broadcast status filter', 'wp-marketing-automations-crm' ),
				'type'        => 'string',
			),
		);
	}

	/**
	 * API callback
	 */
	public function process_api_call() {
		$search = ! empty( $this->get_sanitized_arg( 'search', 'key' ) ) ? $this->get_sanitized_arg( 'search', 'text_field' ) : '';
		$offset = ! empty( $this->get_sanitized_arg( 'offset', 'key' ) ) ? $this->get_sanitized_arg( 'offset', 'text_field' ) : $this->pagination->offset;
		$limit  = ! empty( $this->get_sanitized_arg( 'limit', 'key' ) ) ? $this->get_sanitized_arg( 'limit', 'text_field' ) : $this->pagination->limit;
		$order  = ! empty( $this->get_sanitized_arg( 'order', 'key' ) ) ? $this->get_sanitized_arg( 'order', 'text_field' ) : 'DESC';
		$type   = ! empty( $this->get_sanitized_arg( 'type', 'key' ) ) ? $this->get_sanitized_arg( 'type', 'text_field' ) : '';
		$status = ! empty( $this->get_sanitized_arg( 'status', 'key' ) ) ? $this->get_sanitized_arg( 'status', 'text_field' ) : '';

		try {
			$campaign_data = BWFAN_Model_Broadcast::get_campaigns( $search, $limit, $offset, $order, $type, $status );

			$this->count_data    = BWFAN_PRO_Common::get_broadcast_data_count( $type );
			$this->response_code = 200;
			$this->total_count   = intval( $campaign_data['total'] );

			return $this->success_response( $campaign_data['data'], $campaign_data['message'] );
		} catch ( Error $e ) {
			$this->response_code = 404;

			return $this->error_response( $e['message'] );
		}
	}

	/**
	 * Get total count
	 */
	public function get_result_total_count() {
		return $this->total_count;
	}

	public function get_result_count_data() {
		return $this->count_data;
	}
}

BWFCRM_API_Loader::register( 'BWFCRM_API_Get_Campaigns' );
