<?php

class BWFCRM_Api_Get_Merge_Tags extends BWFCRM_API_Base {

	public static $ins;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function __construct() {
		parent::__construct();
		$this->method        = WP_REST_Server::READABLE;
		$this->route         = 'broadcast/merge-tags';
		$this->response_code = 200;
		$this->merge_tags    = array();
	}

	public function process_api_call() {
		$context   = $this->get_sanitized_arg( 'context' );
		$fetch_for_forms = 'forms' === $context;

		try {
			//$merge_tags = BWFCRM_Core()->merge_tags->get_registered_tags();
			$merge_tags = BWFCRM_Core()->merge_tags->get_registered_grouped_tags( true, $fetch_for_forms );
			$merge_tags = apply_filters( 'bwfan_crm_merge_tags_api', $merge_tags );
		} catch ( Exception $e ) {
			$this->response_code = 404;
			$response            = $e->getMessage();

			return $this->error_response( $response );
		}

		if ( empty( $merge_tags ) ) {
			$this->response_code = 404;
			$response            = __( "No merge tags found", "wp-marketing-automations-crm" );

			return $this->error_response( $response );
		}
		$this->merge_tags = $merge_tags;

		return $this->success_response( $merge_tags, __( 'Got All Merge Tags', 'wp-marketing-automations-crm' ) );
	}
}

BWFCRM_API_Loader::register( 'BWFCRM_Api_Get_Merge_Tags' );