<?php
/**
 * Merge Tag: Contact Company
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class BWFCRM_AFFWP_URL extends BWFCRM_Merge_Tag_Base {
	private static $ins = null;

	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public function __construct() {
		$this->_tag_name        = __( 'Affiliate URL', 'wp-marketing-automations-crm' );
		$this->_tag_description = __( 'Affiliate URL', 'wp-marketing-automations-crm' );
	}

	public function get_value( $data = array() ) {
		/** @var BWFCRM_Contact $contact */
		$contact = $this->maybe_get_contact( $data );
		if ( ! $contact instanceof BWFCRM_Contact ) {
			return $contact;
		}

		$user_id = $contact->contact->get_wpid();
		if ( empty( $user_id ) ) {
			return BWFCRM_Common::crm_error( __( 'Contact doesn\'t have WP User ID', 'wp-marketing-automations-crm' ) );
		}

		$affiliate_id = BWFAN_PRO_Common::get_aff_id_by_user_id( $user_id );
		if ( empty( $affiliate_id ) ) {
			return BWFCRM_Common::crm_error( __( 'Contact is not associated with any affiliate', 'wp-marketing-automations-crm' ) );
		}

		$args = array(
			'affiliate_id' => $affiliate_id,
		);

		if ( is_array( $data ) && isset( $data['base_url'] ) && ! empty( $data['base_url'] ) ) {
			$args['base_url'] = $data['base_url'];
		}

		$affiliate_referral_url = affwp_get_affiliate_referral_url( $args );
		if ( empty( $affiliate_referral_url ) ) {
			return BWFCRM_Common::crm_error( __( 'Unable to fetch affiliate URL', 'wp-marketing-automations-crm' ) );
		}

		return $affiliate_referral_url;
	}

	public function get_dummy_value( $data = array() ) {
		return '';
	}
}

if ( bwfan_is_affiliatewp_active() ) {
	BWFCRM_Core()->merge_tags->register( 'affwp_url', 'BWFCRM_AFFWP_URL', 'affwp' );
}
