<?php

/** 
 ** 
 **              ██╗ █████╗ ██████╗ ██╗██╗      █████╗ ██╗  ██╗    ███╗   ███╗██╗   ██╗███████╗██╗     ██╗███╗   ███╗             
 **              ██║██╔══██╗██╔══██╗██║██║     ██╔══██╗██║  ██║    ████╗ ████║██║   ██║██╔════╝██║     ██║████╗ ████║             
 **              ██║███████║██║  ██║██║██║     ███████║███████║    ██╔████╔██║██║   ██║███████╗██║     ██║██╔████╔██║             
 **         ██   ██║██╔══██║██║  ██║██║██║     ██╔══██║██╔══██║    ██║╚██╔╝██║██║   ██║╚════██║██║     ██║██║╚██╔╝██║             
 **         ╚█████╔╝██║  ██║██████╔╝██║███████╗██║  ██║██║  ██║    ██║ ╚═╝ ██║╚██████╔╝███████║███████╗██║██║ ╚═╝ ██║             
 **          ╚════╝ ╚═╝  ╚═╝╚═════╝ ╚═╝╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝    ╚═╝     ╚═╝ ╚═════╝ ╚══════╝╚══════╝╚═╝╚═╝     ╚═╝             
 **                                                                                                                               
 **  █████╗ ███╗   ███╗ █████╗ ███╗   ██╗ █████╗ ██╗  ██╗       ██╗       ██████╗ ███████╗██████╗  █████╗ ██████╗  █████╗ ██████╗ 
 ** ██╔══██╗████╗ ████║██╔══██╗████╗  ██║██╔══██╗██║  ██║       ██║       ██╔══██╗██╔════╝██╔══██╗██╔══██╗██╔══██╗██╔══██╗██╔══██╗
 ** ███████║██╔████╔██║███████║██╔██╗ ██║███████║███████║    ████████╗    ██████╔╝█████╗  ██████╔╝███████║██║  ██║███████║██████╔╝
 ** ██╔══██║██║╚██╔╝██║██╔══██║██║╚██╗██║██╔══██║██╔══██║    ██╔═██╔═╝    ██╔══██╗██╔══╝  ██╔══██╗██╔══██║██║  ██║██╔══██║██╔══██╗
 ** ██║  ██║██║ ╚═╝ ██║██║  ██║██║ ╚████║██║  ██║██║  ██║    ██████║      ██████╔╝███████╗██║  ██║██║  ██║██████╔╝██║  ██║██████╔╝
 ** ╚═╝  ╚═╝╚═╝     ╚═╝╚═╝  ╚═╝╚═╝  ╚═══╝╚═╝  ╚═╝╚═╝  ╚═╝    ╚═════╝      ╚═════╝ ╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝╚═════╝ ╚═╝  ╚═╝╚═════╝ 
 **                                                                                                                     
 ** Semoga Allah Ta'ala TIDAK memberkahi perniagaan orang yang mengutip kode program di plugin ini 
 ** "Tidak dihalalkan harta seorang muslimin kecuali yang diberikan dari ketulusan hatinya yang dalam."
 ** ( HR Al Baihaqi, Ahmad, Ad-Daraquthni - Dishahihkan oleh Al-Albani )
 ** 
***/

class WFCO_Wabot_Send_Group extends WFCO_Call {

	private static $instance = null;
	private $api_end_point = null;

	public function __construct() {

		$this->required_fields = array( 'access_token', 'instance_id', 'number', 'type', 'sms_body' );

	}

	/**
	 * @return WFCO_Wabot_Send_Group|null
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
				return $this->show_fields_error();
			}

		$req_params = array();

		$url       = "https://dash.wabot.plus/api/send_group";
		
		$headers = array(
			'Content-Type' => 'application/json',
		);

		$numbers = trim( stripslashes( $this->data['number'] ) );
		$numbers = explode( ',', $numbers );

		$this->data['type']     = $this->data['type'];
		$this->data['sms_body'] = BWFAN_Common::decode_merge_tags( $this->data['sms_body'] );

		/** only allow link shorting for message type text */
		if ( 'text' === strval( $this->data['type'] ) ) {
			$req_params = array(
				'message'      => $this->data['sms_body'],
				'access_token' => $this->data['access_token'],
				'instance_id'  => $this->data['instance_id'],
				'type'         => $this->data['type'],
			);

			// $url = add_query_arg( array(
			// 	'message'      => urlencode( $this->data['sms_body'] ),
			// 	'access_token' => $this->data['access_token'],
			// 	'instance_id'  => $this->data['instance_id'],
			// 	'type'         => $this->data['type'],
			// ), $url );
		}

		if ( 'media' === strval( $this->data['type'] ) ) {
			$req_params = array(
				'message'      => $this->data['sms_body'],
				'access_token' => $this->data['access_token'],
				'instance_id'  => $this->data['instance_id'],
				'type'         => $this->data['type'],
				'media_url'    => $this->data['sms_file'],
			);

			// $url = add_query_arg( array(
			// 	'message'      => urlencode( $this->data['sms_body'] ),
			// 	'access_token' => $this->data['access_token'],
			// 	'instance_id'  => $this->data['instance_id'],
			// 	'type'         => $this->data['type'],
			// 	'media_url'    => $this->data['sms_file'],
			// ), $url );
		}

		if ( 'file' === strval( $this->data['type'] ) ){
			$req_params = array(
				'message'   => $this->data['sms_body'],
				'access_token' => $this->data['access_token'],
				'instance_id'  => $this->data['instance_id'],
				'type'      => 'media',
				'media_url' => $this->data['sms_file'],
				'filename' => $this->data['sms_file_name'],
			);
	
			// $url = add_query_arg( array(
			// 	'message'   => urlencode( $this->data['sms_body'] ),
			// 	'access_token' => $this->data['access_token'],
			// 	'instance_id'  => $this->data['instance_id'],
			// 	'type'      => 'media',
			// 	'media_url' => $this->data['sms_file'],
			// 	'filename' => $this->data['sms_file_name'],
			// ), $url );
		}

		if ( 'image' === strval( $this->data['type'] ) ) {
			$req_params = array(
				'message'      => $this->data['sms_body'],
				'access_token' => $this->data['access_token'],
				'instance_id'  => $this->data['instance_id'],
				'type'         => 'media',
				'media_url'    => $this->data['sms_body'],
			);

			// $url = add_query_arg( array(
			// 	'message'      => '',
			// 	'access_token' => $this->data['access_token'],
			// 	'instance_id'  => $this->data['instance_id'],
			// 	'type'         => 'media',
			// 	'media_url'    => $this->data['sms_body'],
			// ), $url );
		}

		$res = array();
		
		foreach ( $numbers as $number ) {
			$req_params['group_id'] = $number;

			/** only allow link shorting for message type text */
			if ( 'text' === strval( $this->data['type'] ) ) {
				$req_params['group_id'] = apply_filters( 'bwfan_modify_send_message_body', $req_params['group_id'], $this->data );
			}

			//$url                  = add_query_arg( array( 'group_id' => $req_params['group_id'] ), $url );
			$res                  = $this->make_wp_requests( $url, wp_json_encode( $req_params ), $headers, BWF_CO::$POST );
		}

		return $res;
	}


}

return 'WFCO_Wabot_Send_Group';
