<?php

class BWFAN_Wabot_LabelAction extends BWFAN_Action {

	private static $instance = null;
	private $progress = false;

	public function __construct() {
		$this->action_name = __( 'WA Business Label Action', 'autonami-automations-connectors' );
		$this->action_desc = __( 'Add ot remove contact label via Wabot', 'autonami-automations-connectors' );
		$this->support_v2  = true;
	}

	/**
	 * @return BWFAN_Wabot_LabelAction|null
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Show the html fields for the current action.
	 */

	public function make_v2_data( $automation_data, $step_data ) {
		$this->progress = true;
		
		$data_to_set = array(
			'number'		=> ( isset( $step_data['phone'] ) ) ? BWFAN_Common::decode_merge_tags( $step_data['phone'] ) : '',
			'label_id' 		=> isset( $step_data['label_id'] ) ? $step_data['label_id'] : '',
			'action' 		=> isset( $step_data['action'] ) ? $step_data['action'] : '',
			'instance_id'	=> isset( $step_data['connector_data']['instance_id'] ) ? $step_data['connector_data']['instance_id'] : '',
			'access_token'	=> isset( $step_data['connector_data']['access_token'] ) ? $step_data['connector_data']['access_token'] : '',
			'subdomain'		=> isset( $step_data['connector_data']['subdomain'] ) ? $step_data['connector_data']['subdomain'] : '',
		);

		return $data_to_set;
	}

	public function execute_action( $action_data ) {
		global $wpdb;
		$this->set_data( $action_data['processed_data'] );
		$this->data['task_id'] = $action_data['task_id'];

		/** Attaching track id */
		$sql_query         = 'Select meta_value FROM {table_name} WHERE bwfan_task_id = %d AND meta_key = %s';
		$sql_query         = $wpdb->prepare( $sql_query, $this->data['task_id'], 't_track_id' ); //phpcs:ignore WordPress.DB.PreparedSQL
		$gids              = BWFAN_Model_Taskmeta::get_results( $sql_query );
		$this->data['gid'] = '';
		if ( ! empty( $gids ) && is_array( $gids ) ) {
			foreach ( $gids as $gid ) {
				$this->data['gid'] = $gid['meta_value'];
			}
		}

		/** Validating connector */
		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_wabot_add_to_contactgroup' );
		if ( is_null( $call_class ) ) {
			$this->progress = false;

			return array(
				'status'  => 4,
				'message' => __( 'Add to contact group call not found', 'autonami-automations-connectors' ),
			);
		}

		$integration                = BWFAN_Wabot_Integration::get_instance();
		$this->data['access_token'] = $integration->get_settings( 'access_token' );
		$this->data['instance_id']  = $integration->get_settings( 'instance_id' );
		$this->data['subdomain']    = $integration->get_settings( 'subdomain' );

		/** WC order case */
		if ( ! empty( $this->data['order_id'] ) ) {
			$order_details = wc_get_order( $this->data['order_id'] );

			/** Appending country code */
			$country = $order_details->get_billing_country();
			if ( ! empty( $country ) ) {
				$this->data['country_code'] = $country;
			}
		} elseif ( ! empty( $this->data['cart_abandoned_id'] ) ) {
			/** Cart abandonment case */
			$cart_details = BWFAN_Merge_Tag_Loader::get_data( 'cart_details' );

			/** Appending country code in case available */
			$checkout_data = json_decode( $cart_details['checkout_data'], true );
			if ( is_array( $checkout_data ) && isset( $checkout_data['fields'] ) && isset( $checkout_data['fields']['billing_country'] ) && ! empty( $checkout_data['fields']['billing_country'] ) ) {
				$this->data['country_code'] = $checkout_data['fields']['billing_country'];
			}
		}

		$call_class->set_data( $this->data );
		
		$response = $call_class->process();
		if ( is_array( $response ) && 200 === $response['response'] && ( isset( $response['body']['status'] ) && $response['body']['status'] === 'success' ) ) {
			$this->progress = false;

			return array(
				'status'  => 3,
				'message' => __( 'Contact added to group successfully.', 'autonami-automations-connectors' ),
			);
		}

		$message = __( 'Contact could not be added. ', 'autonami-automations-connectors' );
		$status  = 4;

		if ( isset( $response['body']['error'] ) && isset( $response['body']['error'] ) && isset( $response['body']['message'] ) ) {
			$message = $response['body']['message'];
		} elseif ( isset( $response['body']['message'] ) ) {
			$message = $response['body']['message'];
		} elseif ( isset( $response['bwfan_response'] ) && ! empty( $response['bwfan_response'] ) ) {
			$message = $response['bwfan_response'];
		} elseif ( is_array( $response['body'] ) && isset( $response['body'][0] ) && is_string( $response['body'][0] ) ) {
			$message = $message . $response['body'][0];
		}
		$this->progress = false;

		return array(
			'status'  => $status,
			'message' => $message,
		);
	}

	public function before_executing_task() {
		add_filter( 'bwfan_change_tasks_retry_limit', [ $this, 'modify_retry_limit' ], 99 );
	}

	public function after_executing_task() {
		remove_filter( 'bwfan_change_tasks_retry_limit', [ $this, 'modify_retry_limit' ], 99 );
	}

	public function modify_retry_limit( $retry_data ) {
		$retry_data[] = DAY_IN_SECONDS;

		return $retry_data;
	}

	public function handle_response_v2( $response ) {
		do_action( 'bwfan_sendsms_action_response', $response, $this->data );
		
		if ( is_array( $response ) && 200 === $response['response'] && ( isset( $response['body']['status'] ) && $response['body']['status'] === 'success' ) ) {
			$this->progress = false;
			return $this->success_message( __( 'Contact added to group successfully.', 'autonami-automations-connectors' ) );
		}

		if ( is_array( $response ) && 200 === $response['response'] && ( isset( $response['body']['status'] ) && $response['body']['message'] === 'Phone already exists' ) ) {
			$this->progress = false;
			return $this->success_message( __( 'Contact already exist in contact group.', 'autonami-automations-connectors' ) );
		}

		$message = __( 'Contact could not be added to group. ', 'autonami-automations-connectors' );
		
		if ( ( isset( $response['body']['status'] ) && $response['body']['status'] === 'error' )  && isset( $response['body']['message'] ) ){
			$message = $response['body']['message'];
		} elseif ( isset( $response['body']['message'] ) ) {
			$message = $response['body']['message'];
		} elseif ( isset( $response['bwfan_response'] ) && ! empty( $response['bwfan_response'] ) ) {
			$message = $response['bwfan_response'];
		} elseif ( is_array( $response['body'] ) && isset( $response['body'][0] ) && is_string( $response['body'][0] ) ) {
			$message = $message . $response['body'][0];
		}
		$this->progress = false;

		return $this->error_response( $message );
	}

	/**
	 * v2 Method: Get field Schema
	 *
	 * @return array[]
	 */
	public function get_fields_schema() {
		return [
			[
				'id'          => 'phone',
				'label'       => __( "Contact Phone", 'wp-marketing-automations' ),
				'type'        => 'text',
				'placeholder' => "60123456789",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => true,
			],
			[
				'id'          => 'label_id',
				'label'       => __( "Label ID", 'wp-marketing-automations' ),
				'type'        => 'text',
				'placeholder' => "1",
				"class"       => 'bwfan-input-wrapper',
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => true,
			],
			[
				'id'          => 'action',
				'label'       => __( "Action", 'wp-marketing-automations' ),
				'type'        => 'radio',
				'options'     => [
					[
						'label' => __( "Add", 'wp-marketing-automations' ),
						'value' => 'add',
					],
					[
						'label'   => __( "Remove", 'wp-marketing-automations' ),
						'value'   => 'remove',
					],
				],
				'tip'         => __( '', 'autonami-automations-connectors' ),
				"description" => '',
				"required"    => true,
			]
		];
	}
}	

return 'BWFAN_Wabot_LabelAction';
