<?php
class WabotContactForm7 implements Wabot_PluginInterface, Wabot_Register_Interface {	
	public static $plugin_identifier = 'wpcf7';
	private $option_id;
	public $cf7_data;
	
	public function __construct() {
		$this->option_id = "wabot_{$this::$plugin_identifier}";
	}
	
	public static function plugin_activated()
    {
        if( ! is_plugin_active(sprintf('%1$s/%1$s.php', self::$plugin_identifier ))) { return false; }
        return true;
    }

    public function register()
    {
		add_filter('wpcf7_editor_panels', array($this, 'cf7_editor_panels'));
		add_action('wpcf7_after_save', array($this, 'wpcf7_save_form'));
		add_action('wpcf7_before_send_mail', array($this, 'wpcf7_wa_handler'));		 
    }

    public function get_option_id()
    {
        return $this->option_id;
    }
	
	public function cf7_editor_panels($panels) {
		$new_page = array(
			'wabot' => array(
				'title'    => __('Wabot', WABOT_TXT_DOMAIN),
				'callback' => array($this, 'cf7_setup_form')
				)
			);
		$panels = array_merge($panels, $new_page);
		return $panels;
	}

	public function cf7_setup_form($form) {
		$cf7_options = get_option( 'wpcf7_wa_' . (method_exists($form, 'id') ? $form->id() : $form->id) );
		if( empty( $cf7_options ) || !is_array( $cf7_options ) ) {
			$cf7_options = array( 'wpcf7_wa_phone' => '', 'wpcf7_wa_message' => '','wpcf7_wa_image' => '');
		}		
		$cf7_options['form'] = $form;
		?>
		<div>
			<h3><?php _e( 'Wabot WhatsApp Notification', WABOT_TXT_DOMAIN ); ?></h3>
			<fieldset>
				<legend><?php _e('Send WhatsApp message to specific number after submit form<br>These are following tags you can use:', WABOT_TXT_DOMAIN); ?><br><?php $cf7_options['form']->suggest_mail_tags(); ?></legend>
				<table class="form-table">
					<tbody>
					<tr>
						<th scope="row"><label for="wpcf7-wa-sender"><?php _e( 'To:', WABOT_TXT_DOMAIN ); ?></label></th>
						<td>
							<input type="text" value="<?php echo $cf7_options['wpcf7_wa_phone']; ?>" size="70" class="large-text code" name="wpcf7-wa-phone" id="wpcf7-wa-sender">
							<p class="description"><?php _e( 'The default country code will be used if the number does not have a country code', WABOT_TXT_DOMAIN ); ?></p>
						</td>
					</tr>

					<tr>
						<th scope="row"><label for="wpcf7-wa-message"><?php _e( 'Message:', WABOT_TXT_DOMAIN ); ?></label></th>
						<td>
							<textarea class="large-text" rows="4" cols="100" name="wpcf7-wa-message" id="wpcf7-wa-message"><?php echo $cf7_options['wpcf7_wa_message']; ?></textarea>
						</td>
					</tr>
					
					<tr>
						<th scope="row"><label for="wpcf7-wa-image"><?php _e( 'Image / File URL:', WABOT_TXT_DOMAIN ); ?></label></th>
						<td>
							<input type="text" value="<?php echo $cf7_options['wpcf7_wa_image']; ?>" size="70" class="large-text code" name="wpcf7-wa-image" id="wpcf7-wa-image">
							<p class="description"><?php _e( 'Insert image or file url to attach into message', WABOT_TXT_DOMAIN ); ?></p>
						</td>
					</tr>
				</tbody></table>
			</fieldset>
		</div>
		<?php
	}

	public function wpcf7_save_form($form) {
		if(isset($_POST['wpcf7-wa-phone'])) $wpcf7_wa_phone = sanitize_text_field($_POST['wpcf7-wa-phone']);
		if(isset($_POST['wpcf7-wa-message'])) $wpcf7_wa_message = sanitize_textarea_field($_POST['wpcf7-wa-message']);
		if(isset($_POST['wpcf7-wa-image'])) $wpcf7_wa_image = esc_url_raw($_POST['wpcf7-wa-image']);
		$wpcf7_wa['wpcf7_wa_phone'] = $wpcf7_wa_phone;
		$wpcf7_wa['wpcf7_wa_message'] = $wpcf7_wa_message;
		$wpcf7_wa['wpcf7_wa_image'] = $wpcf7_wa_image;
		
		update_option( 'wpcf7_wa_' . (method_exists($form, 'id') ? $form->id() : $form->id), $wpcf7_wa );	
	}

	public function get_cf7_tagS_To_String($value,$form) {
		if(function_exists('wpcf7_mail_replace_tags')) {
			$return = wpcf7_mail_replace_tags($value); 
		} elseif(method_exists($form, 'replace_mail_tags')) {
			$return = $form->replace_mail_tags($value); 
		} else {
			return;
		}
		return $return;
	}	

	public function wpcf7_wa_handler($form) {
		$cf7_options = get_option('wpcf7_wa_' . $form->id());
		$this->set_cf7_data();		
		if ($cf7_options['wpcf7_wa_message'] && $cf7_options['wpcf7_wa_phone']) {
			$country = wabot_get_options( 'wabot_woocommerce_country_code', 'wabot_setting', '' );
			$phone_no = $this->get_cf7_tagS_To_String($cf7_options['wpcf7_wa_phone'],$form);
			if( !ctype_digit($phone_no) ) {
				return;
			}
			if( !empty($country) ) {
				$phone_no = Wabot_SendWA_Msg::get_formatted_number($phone_no, $country);
			}
			$msg = $this->get_cf7_tagS_To_String($cf7_options['wpcf7_wa_message'],$form);
			$img = preg_replace_callback('/%([a-zA-Z0-9._-]+)%/', function($matches) {
				foreach ($matches as $item) {
					return $this->cf7_data[$item];
				}
			}, $cf7_options['wpcf7_wa_image']);
			if(!empty($img)) {
				$type = 'media';
			} else {
				$type = 'text';				
			}
			Wabot_SendWA_Msg::send_wa($type, $phone_no, $msg, $img);
		}
	}

	private function set_cf7_data() {
		foreach (sanitize_text_field($_POST) as $index => $key) {
			if (is_array($key)) {
				$this->cf7_data[$index] = implode(', ', $key);
			}
			else {
				$this->cf7_data[$index] = $key;
			}
		}
	}	
}	
?>