<?php

class Wabot_WooCommerce_Setting implements Wabot_Register_Interface {

	private $settings_api;

	function __construct() {
		$this->settings_api = new WeDevs_Settings_API;
	}

	public function register() {
        
        add_action( 'admin_init', array( $this, 'admin_init' ) );
        add_action( 'admin_menu', array( $this, 'admin_menu' ) );
        
	}

	function admin_init() {

		//set the settings
		$this->settings_api->set_sections( $this->get_settings_sections() );
		$this->settings_api->set_fields( $this->get_settings_fields() );

		//initialize settings
		$this->settings_api->admin_init();
	}

	function admin_menu() {
		add_menu_page(
			'Wabot Settings',
			'Wabot',
			'manage_options',
			'wabot-settings',
            array($this, 'plugin_page')
        );
	}

	function get_settings_sections() {
		if( class_exists( 'woocommerce' ) ): 
		$sections = array(
			array(
				'id'    => 'wabot_setting',
				'title' => __( 'Device Settings', WABOT_TXT_DOMAIN )
			),
			
				array(
					'id'    => 'wabot_customer_setting',
					'title' => __( 'Customer Notifications', WABOT_TXT_DOMAIN )
				),
			array(
				'id'    => 'wabot_admin_setting',
				'title' => __( 'Admin Notifications', WABOT_TXT_DOMAIN )
			),
		);
		else:
			$sections = array(
			array(
				'id'    => 'wabot_setting',
				'title' => __( 'Device Settings', WABOT_TXT_DOMAIN )
			),
		);
		endif;

		$sections = apply_filters( 'wabot_setting_section', $sections );

		return $sections;
	}

	/**
	 * Returns all the settings fields
	 *
	 * @return array settings fields
	 */
	function get_settings_fields() {
		global $woocommerce;
		if( class_exists( 'woocommerce' ) ): // check woocommerce
    		$countries_obj   = new WC_Countries();
			$countries   = $countries_obj->__get('countries');
		
		else:
			$countries = array("AF" => "Afghanistan",
			"AX" => "Åland Islands",
			"AL" => "Albania",
			"DZ" => "Algeria",
			"AS" => "American Samoa",
			"AD" => "Andorra",
			"AO" => "Angola",
			"AI" => "Anguilla",
			"AQ" => "Antarctica",
			"AG" => "Antigua and Barbuda",
			"AR" => "Argentina",
			"AM" => "Armenia",
			"AW" => "Aruba",
			"AU" => "Australia",
			"AT" => "Austria",
			"AZ" => "Azerbaijan",
			"BS" => "Bahamas",
			"BH" => "Bahrain",
			"BD" => "Bangladesh",
			"BB" => "Barbados",
			"BY" => "Belarus",
			"BE" => "Belgium",
			"BZ" => "Belize",
			"BJ" => "Benin",
			"BM" => "Bermuda",
			"BT" => "Bhutan",
			"BO" => "Bolivia",
			"BA" => "Bosnia and Herzegovina",
			"BW" => "Botswana",
			"BV" => "Bouvet Island",
			"BR" => "Brazil",
			"IO" => "British Indian Ocean Territory",
			"BN" => "Brunei Darussalam",
			"BG" => "Bulgaria",
			"BF" => "Burkina Faso",
			"BI" => "Burundi",
			"KH" => "Cambodia",
			"CM" => "Cameroon",
			"CA" => "Canada",
			"CV" => "Cape Verde",
			"KY" => "Cayman Islands",
			"CF" => "Central African Republic",
			"TD" => "Chad",
			"CL" => "Chile",
			"CN" => "China",
			"CX" => "Christmas Island",
			"CC" => "Cocos (Keeling) Islands",
			"CO" => "Colombia",
			"KM" => "Comoros",
			"CG" => "Congo",
			"CD" => "Congo, The Democratic Republic of The",
			"CK" => "Cook Islands",
			"CR" => "Costa Rica",
			"CI" => "Cote D'ivoire",
			"HR" => "Croatia",
			"CU" => "Cuba",
			"CY" => "Cyprus",
			"CZ" => "Czech Republic",
			"DK" => "Denmark",
			"DJ" => "Djibouti",
			"DM" => "Dominica",
			"DO" => "Dominican Republic",
			"EC" => "Ecuador",
			"EG" => "Egypt",
			"SV" => "El Salvador",
			"GQ" => "Equatorial Guinea",
			"ER" => "Eritrea",
			"EE" => "Estonia",
			"ET" => "Ethiopia",
			"FK" => "Falkland Islands (Malvinas)",
			"FO" => "Faroe Islands",
			"FJ" => "Fiji",
			"FI" => "Finland",
			"FR" => "France",
			"GF" => "French Guiana",
			"PF" => "French Polynesia",
			"TF" => "French Southern Territories",
			"GA" => "Gabon",
			"GM" => "Gambia",
			"GE" => "Georgia",
			"DE" => "Germany",
			"GH" => "Ghana",
			"GI" => "Gibraltar",
			"GR" => "Greece",
			"GL" => "Greenland",
			"GD" => "Grenada",
			"GP" => "Guadeloupe",
			"GU" => "Guam",
			"GT" => "Guatemala",
			"GG" => "Guernsey",
			"GN" => "Guinea",
			"GW" => "Guinea-bissau",
			"GY" => "Guyana",
			"HT" => "Haiti",
			"HM" => "Heard Island and Mcdonald Islands",
			"VA" => "Holy See (Vatican City State)",
			"HN" => "Honduras",
			"HK" => "Hong Kong",
			"HU" => "Hungary",
			"IS" => "Iceland",
			"IN" => "India",
			"ID" => "Indonesia",
			"IR" => "Iran, Islamic Republic of",
			"IQ" => "Iraq",
			"IE" => "Ireland",
			"IM" => "Isle of Man",
			"IL" => "Israel",
			"IT" => "Italy",
			"JM" => "Jamaica",
			"JP" => "Japan",
			"JE" => "Jersey",
			"JO" => "Jordan",
			"KZ" => "Kazakhstan",
			"KE" => "Kenya",
			"KI" => "Kiribati",
			"KP" => "Korea, Democratic People's Republic of",
			"KR" => "Korea, Republic of",
			"KW" => "Kuwait",
			"KG" => "Kyrgyzstan",
			"LA" => "Lao People's Democratic Republic",
			"LV" => "Latvia",
			"LB" => "Lebanon",
			"LS" => "Lesotho",
			"LR" => "Liberia",
			"LY" => "Libyan Arab Jamahiriya",
			"LI" => "Liechtenstein",
			"LT" => "Lithuania",
			"LU" => "Luxembourg",
			"MO" => "Macao",
			"MK" => "Macedonia, The Former Yugoslav Republic of",
			"MG" => "Madagascar",
			"MW" => "Malawi",
			"MY" => "Malaysia",
			"MV" => "Maldives",
			"ML" => "Mali",
			"MT" => "Malta",
			"MH" => "Marshall Islands",
			"MQ" => "Martinique",
			"MR" => "Mauritania",
			"MU" => "Mauritius",
			"YT" => "Mayotte",
			"MX" => "Mexico",
			"FM" => "Micronesia, Federated States of",
			"MD" => "Moldova, Republic of",
			"MC" => "Monaco",
			"MN" => "Mongolia",
			"ME" => "Montenegro",
			"MS" => "Montserrat",
			"MA" => "Morocco",
			"MZ" => "Mozambique",
			"MM" => "Myanmar",
			"NA" => "Namibia",
			"NR" => "Nauru",
			"NP" => "Nepal",
			"NL" => "Netherlands",
			"AN" => "Netherlands Antilles",
			"NC" => "New Caledonia",
			"NZ" => "New Zealand",
			"NI" => "Nicaragua",
			"NE" => "Niger",
			"NG" => "Nigeria",
			"NU" => "Niue",
			"NF" => "Norfolk Island",
			"MP" => "Northern Mariana Islands",
			"NO" => "Norway",
			"OM" => "Oman",
			"PK" => "Pakistan",
			"PW" => "Palau",
			"PS" => "Palestinian Territory, Occupied",
			"PA" => "Panama",
			"PG" => "Papua New Guinea",
			"PY" => "Paraguay",
			"PE" => "Peru",
			"PH" => "Philippines",
			"PN" => "Pitcairn",
			"PL" => "Poland",
			"PT" => "Portugal",
			"PR" => "Puerto Rico",
			"QA" => "Qatar",
			"RE" => "Reunion",
			"RO" => "Romania",
			"RU" => "Russian Federation",
			"RW" => "Rwanda",
			"SH" => "Saint Helena",
			"KN" => "Saint Kitts and Nevis",
			"LC" => "Saint Lucia",
			"PM" => "Saint Pierre and Miquelon",
			"VC" => "Saint Vincent and The Grenadines",
			"WS" => "Samoa",
			"SM" => "San Marino",
			"ST" => "Sao Tome and Principe",
			"SA" => "Saudi Arabia",
			"SN" => "Senegal",
			"RS" => "Serbia",
			"SC" => "Seychelles",
			"SL" => "Sierra Leone",
			"SG" => "Singapore",
			"SK" => "Slovakia",
			"SI" => "Slovenia",
			"SB" => "Solomon Islands",
			"SO" => "Somalia",
			"ZA" => "South Africa",
			"GS" => "South Georgia and The South Sandwich Islands",
			"ES" => "Spain",
			"LK" => "Sri Lanka",
			"SD" => "Sudan",
			"SR" => "Suriname",
			"SJ" => "Svalbard and Jan Mayen",
			"SZ" => "Swaziland",
			"SE" => "Sweden",
			"CH" => "Switzerland",
			"SY" => "Syrian Arab Republic",
			"TW" => "Taiwan, Province of China",
			"TJ" => "Tajikistan",
			"TZ" => "Tanzania, United Republic of",
			"TH" => "Thailand",
			"TL" => "Timor-leste",
			"TG" => "Togo",
			"TK" => "Tokelau",
			"TO" => "Tonga",
			"TT" => "Trinidad and Tobago",
			"TN" => "Tunisia",
			"TR" => "Turkey",
			"TM" => "Turkmenistan",
			"TC" => "Turks and Caicos Islands",
			"TV" => "Tuvalu",
			"UG" => "Uganda",
			"UA" => "Ukraine",
			"AE" => "United Arab Emirates",
			"GB" => "United Kingdom",
			"US" => "United States",
			"UM" => "United States Minor Outlying Islands",
			"UY" => "Uruguay",
			"UZ" => "Uzbekistan",
			"VU" => "Vanuatu",
			"VE" => "Venezuela",
			"VN" => "Viet Nam",
			"VG" => "Virgin Islands, British",
			"VI" => "Virgin Islands, U.S.",
			"WF" => "Wallis and Futuna",
			"EH" => "Western Sahara",
			"YE" => "Yemen",
			"ZM" => "Zambia",
			"ZW" => "Zimbabwe");
		endif;	
		$additional_billing_fields       = '';
		$additional_billing_fields_desc  = '';
		$additional_billing_fields_array = $this->get_additional_billing_fields();
		foreach ( $additional_billing_fields_array as $field ) {
			$additional_billing_fields .= ', [' . $field . ']';
		}
		if ( $additional_billing_fields ) {
			$additional_billing_fields_desc = '<br />Custom Tags: ' . substr( $additional_billing_fields, 2 );
		}

		$settings_fields = array(
			'wabot_setting' => array(
				array(
					'name'  => 'wabot_woocommerce_dashboard_prefix',
					'label' => __( 'Dashboard Prefix', WABOT_TXT_DOMAIN ),
					'desc'  => __( 'Your Wabot Dashboard Prefix, e.g: dash, md, free, vip, dev, etc.', WABOT_TXT_DOMAIN ),
					'type'  => 'text',
				),
				array(
					'name'  => 'wabot_woocommerce_access_token',
					'label' => __( 'Access Token', WABOT_TXT_DOMAIN ),
					'desc'  => __( 'Your Wabot Account Access Token. Credential can be found on dashboard page.', WABOT_TXT_DOMAIN ),
					'type'  => 'text',
				),
				array(
					'name'  => 'wabot_woocommerce_instance_id',
					'label' => __( 'Instance ID', WABOT_TXT_DOMAIN ),
					'desc'  => __( 'Your Wabot Number Instance ID. Credential can be found on dashboard page.', WABOT_TXT_DOMAIN ),
					'type'  => 'text',
				),
				array(
					'name'  => 'wabot_instance_control',
					'label' => 'Instance Control',
					'desc'  => '<a href="#" class="button button-primary ins-action" data-action="reconnect">Reconnect</a> <a href="#" class="button button-secondary ins-action" data-action="reboot">Reboot</a> <a href="#" class="button button-secondary ins-action" data-action="reset">Reset</a> <a href="#" class="button button-secondary ins-action" data-action="status">Status</a> <a href="#" class="button button-secondary ins-action" data-action="webhook">Set Webhook</a><br><strong>Reconnect</strong>: Re-initiate connection from app to WhatsApp Web when lost connection<br><strong>Reboot</strong>: Logout WhatsApp Web and do a fresh scan<br><strong>Reset</strong>: This will logout WhatsApp Web, Change Instance ID, Delete all old instance data<br><strong>Status</strong>: Check connection status. Only works if you have set a profile photo<br><strong>Set Webhook</strong>: Set webhook url to get all return values from Whatsapp, like connection status, incoming message, outgoing message, disconnected, change battery, etc',
					'type'  => 'html'
				),
				array(
					'name'    		=> 'wabot_woocommerce_country_code',
					'label'   		=> __( 'Default Country', WABOT_TXT_DOMAIN ),
					'class'     	=> array('chzn-drop'),
					'placeholder'	=> __( 'Select a Country', WABOT_TXT_DOMAIN),
					'desc'    		=> 'Selected country will be use for mobile number if country code is not provided.',
					'type'    		=> 'select',
					'options' 		=> $countries
				),
				array(
					'name'  => 'export_wabot_log',
					'label' => 'Export Message Logs',
					'desc'  => '<a href="' . admin_url( 'admin.php?page=wabot-download-file&file=Wabot' ) . '" class="button button-secondary">Export Logs</a><div id="wabot_wa[keyword-modal]" class="modal"></div>',
					'type'  => 'html'
				)
			),
			'wabot_admin_setting'     => array(
				array(
					'name'    => 'wabot_woocommerce_admin_suborders_send_wa',
					'label'   => __( 'Enable Admin Notifications', WABOT_TXT_DOMAIN ),
					'desc'    => ' ' . __( 'Enable', WABOT_TXT_DOMAIN ),
					'type'    => 'checkbox',
					'default' => 'off'
				),
				array(
					'name'    => 'wabot_woocommerce_admin_send_wa_on',
					'label'   => __( 'Send notification on', WABOT_TXT_DOMAIN ),
					'desc'    => __( 'Select order statuses for which you want to enable sending WhatsApp notifications<br>Set <strong>Low Stock Threshold</strong> alert under <strong>WooCommerce Product > Product Data > Inventory > Low Stock Threshold</strong>', WABOT_TXT_DOMAIN ),
					'type'    => 'multicheck',
					'default' => array(
						'on-hold'    => 'on-hold',
						'processing' => 'processing'
					),
					'options' => array(
						'pending'           => ' Pending',
						'on-hold'           => ' On-hold',
						'processing'        => ' Processing',
						'completed'         => ' Completed',
						'cancelled'         => ' Cancelled',
						'refunded'          => ' Refunded',
						'failed'            => ' Failed',
						'low_stock_product' => ' Low stock product ',
					)
				),
				array(
					'name'  => 'wabot_woocommerce_admin_wa_recipients',
					'label' => __( 'WhatsApp Number', WABOT_TXT_DOMAIN ),
					'desc'  => __( 'Insert WhatsApp number to receive new order notification to shop admin.<br>Use country code along with WhatsApp number. E.g. 628123456789', WABOT_TXT_DOMAIN ),
					'type'  => 'text',
				),
				array(
					'name'    => 'wabot_woocommerce_admin_wa_template',
					'label'   => __( 'Admin Message', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px;',
					'default' => __( '[shop_name] : You have a new order with order ID [order_id] and order amount [order_currency] [order_amount]. The order is now [order_status].', WABOT_TXT_DOMAIN )
                ),
				array(
					'name'    => 'wabot_woocommerce_admin_wa_template_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="admin" data-attr-target="wabot_admin_setting[wabot_woocommerce_admin_wa_template]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
                ),
				array(
					'name'    => 'wabot_woocommerce_admin_wa_template_low_stock_product',
					'label'   => __( 'Low Stock Product Message', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px',
					'default' => __( '[shop_name] : Your product [product_name] has low stock. Current quantity: [product_stock_quantity]. Please restock soon.', WABOT_TXT_DOMAIN )
                ),
				array(
					'name'    => 'wabot_woocommerce_admin_wa_template_low_stock_product_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords-low-stock-product]" data-attr-type="admin" data-attr-target="wabot_admin_setting[wabot_woocommerce_admin_wa_template_low_stock_product]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
                ),
			),
			'wabot_customer_setting'  => array(
				array(
					'name'    => 'wabot_woocommerce_suborders_send_wa',
					'label'   => __( 'Enable Customer Notifications', WABOT_TXT_DOMAIN ),
					'desc'    => ' ' . __( 'Enable', WABOT_TXT_DOMAIN ),
					'type'    => 'checkbox',
					'default' => 'off'
				),
				array(
					'name'    => 'wabot_woocommerce_send_wa',
					'label'   => __( 'Send notification on', WABOT_TXT_DOMAIN ),
					'desc'    => __( 'Select order statuses for which you want to enable sending WhatsApp notifications', WABOT_TXT_DOMAIN ),
					'type'    => 'multicheck',
					'options' => array(
						'pending'    => ' Pending',
						'on-hold'    => ' On-hold',
						'processing' => ' Processing',
						'completed'  => ' Completed',
						'cancelled'  => ' Cancelled',
						'refunded'   => ' Refunded',
						'failed'     => ' Failed'
					)
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_default',
					'label'   => __( 'Default Customer Message', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px;',
					'default' => __( '[shop_name] : Thank you for purchasing. Your order ([order_id]) is now [order_status].', WABOT_TXT_DOMAIN )
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_default_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="default" data-attr-target="wabot_customer_setting[wabot_woocommerce_wa_template_default]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_pending',
					'label'   => __( 'Pending Status', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px;',
					'default' => __( '[shop_name] : Thank you for purchasing. Your order ([order_id]) is now [order_status].', WABOT_TXT_DOMAIN )
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_pending_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="pending" data-attr-target="wabot_customer_setting[wabot_woocommerce_wa_template_pending]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_on-hold',
					'label'   => __( 'On-hold Status', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px;',
					'default' => __( '[shop_name] : Thank you for purchasing. Your order ([order_id]) is now [order_status].', WABOT_TXT_DOMAIN )
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_on-hold_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="on_hold" data-attr-target="wabot_customer_setting[wabot_woocommerce_wa_template_on-hold]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_processing',
					'label'   => __( 'Processing Status', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px;',
					'default' => __( '[shop_name] : Thank you for purchasing. Your order ([order_id]) is now [order_status].', WABOT_TXT_DOMAIN )
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_processing_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="processing" data-attr-target="wabot_customer_setting[wabot_woocommerce_wa_template_processing]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_completed',
					'label'   => __( 'Completed Status', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px;',
					'default' => __( '[shop_name] : Thank you for purchasing. Your order ([order_id]) is now [order_status].', WABOT_TXT_DOMAIN )
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_completed_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="completed" data-attr-target="wabot_customer_setting[wabot_woocommerce_wa_template_completed]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_cancelled',
					'label'   => __( 'Cancelled Status', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px;',
					'default' => __( '[shop_name] : Thank you for purchasing. Your order ([order_id]) is now [order_status].', WABOT_TXT_DOMAIN )
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_cancelled_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="cancelled" data-attr-target="wabot_customer_setting[wabot_woocommerce_wa_template_cancelled]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_refunded',
					'label'   => __( 'Refunded Status', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px;',
					'default' => __( '[shop_name] : Thank you for purchasing. Your order ([order_id]) is now [order_status].', WABOT_TXT_DOMAIN )
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_refunded_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="refunded" data-attr-target="wabot_customer_setting[wabot_woocommerce_wa_template_refunded]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_failed',
					'label'   => __( 'Failed Status', WABOT_TXT_DOMAIN ),
					'type'    => 'textarea',
					'rows'    => '8',
					'cols'    => '500',
					'css'     => 'min-width:350px;',
					'default' => __( '[shop_name] : Thank you for purchasing. Your order ([order_id]) is now [order_status].', WABOT_TXT_DOMAIN )
				),
				array(
					'name'    => 'wabot_woocommerce_wa_template_failed_file',
					'label'   => '',
					'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="failed" data-attr-target="wabot_customer_setting[wabot_woocommerce_wa_template_failed]" class="button button-secondary">Keywords</button>',
					'type'    => 'file',
				)
			)
		);

		$settings_fields = apply_filters( 'wabot_setting_fields', $settings_fields );

		return $settings_fields;
	}

	function plugin_page() {
		echo '<div class="wrap">';
		$this->settings_api->show_navigation();
		$this->settings_api->show_forms();
		echo '<input type="hidden" value="' . join(",", $this->get_additional_billing_fields()) . '" id="wabot_new_billing_field" />';
		echo '</div>';
	}

	/**
	 * Get all the pages
	 *
	 * @return array page names with key value pairs
	 */
	function get_pages() {
		$pages         = get_pages();
		$pages_options = array();
		if ( $pages ) {
			foreach ( $pages as $page ) {
				$pages_options[ $page->ID ] = $page->post_title;
			}
		}

		return $pages_options;
	}

	function get_additional_billing_fields() {
		$default_billing_fields   = array(
			'billing_first_name',
			'billing_last_name',
			'billing_company',
			'billing_address_1',
			'billing_address_2',
			'billing_city',
			'billing_state',
			'billing_country',
			'billing_postcode',
			'billing_phone',
			'billing_email'
		);
		$additional_billing_field = array();
		$billing_fields           = array_filter( get_option( 'wc_fields_billing', array() ) );
		foreach ( $billing_fields as $field_key => $field_info ) {
			if ( ! in_array( $field_key, $default_billing_fields ) && $field_info['enabled'] ) {
				array_push( $additional_billing_field, $field_key );
			}
		}

		return $additional_billing_field;
	}

    public function woocommerce_not_activated_menu_view()
    {
		add_menu_page(
			'Wabot Settings',
			'Wabot',
			'manage_options',
			'wabot-settings',
			array(
				$this,
				'woocommerce_not_activated_view'
			)
		);
    }

    public function woocommerce_not_activated_view()
    {
        if (! current_user_can('manage_options')) { return; }
        ?>
        <div class="wrap">
            <h1>Wabot Settings</h1>
            <p>Please activate WooCommerce plugin first before accessing this page</p>
        </div>
        <?php
    }

    public function get_countries()
    {
        return array(
            "AF" => "Afghanistan",
            "AL" => "Albania",
            "DZ" => "Algeria",
            "AS" => "American Samoa",
            "AD" => "Andorra",
            "AO" => "Angola",
            "AI" => "Anguilla",
            "AQ" => "Antarctica",
            "AG" => "Antigua and Barbuda",
            "AR" => "Argentina",
            "AM" => "Armenia",
            "AW" => "Aruba",
            "AU" => "Australia",
            "AT" => "Austria",
            "AZ" => "Azerbaijan",
            "BS" => "Bahamas",
            "BH" => "Bahrain",
            "BD" => "Bangladesh",
            "BB" => "Barbados",
            "BY" => "Belarus",
            "BE" => "Belgium",
            "BZ" => "Belize",
            "BJ" => "Benin",
            "BM" => "Bermuda",
            "BT" => "Bhutan",
            "BO" => "Bolivia",
            "BA" => "Bosnia and Herzegovina",
            "BW" => "Botswana",
            "BV" => "Bouvet Island",
            "BR" => "Brazil",
            "IO" => "British Indian Ocean Territory",
            "BN" => "Brunei Darussalam",
            "BG" => "Bulgaria",
            "BF" => "Burkina Faso",
            "BI" => "Burundi",
            "KH" => "Cambodia",
            "CM" => "Cameroon",
            "CA" => "Canada",
            "CV" => "Cape Verde",
            "KY" => "Cayman Islands",
            "CF" => "Central African Republic",
            "TD" => "Chad",
            "CL" => "Chile",
            "CN" => "China",
            "CX" => "Christmas Island",
            "CC" => "Cocos (Keeling) Islands",
            "CO" => "Colombia",
            "KM" => "Comoros",
            "CG" => "Congo",
            "CD" => "Congo, the Democratic Republic of the",
            "CK" => "Cook Islands",
            "CR" => "Costa Rica",
            "CI" => "Cote D'Ivoire",
            "HR" => "Croatia",
            "CU" => "Cuba",
            "CY" => "Cyprus",
            "CZ" => "Czech Republic",
            "DK" => "Denmark",
            "DJ" => "Djibouti",
            "DM" => "Dominica",
            "DO" => "Dominican Republic",
            "EC" => "Ecuador",
            "EG" => "Egypt",
            "SV" => "El Salvador",
            "GQ" => "Equatorial Guinea",
            "ER" => "Eritrea",
            "EE" => "Estonia",
            "ET" => "Ethiopia",
            "FK" => "Falkland Islands (Malvinas)",
            "FO" => "Faroe Islands",
            "FJ" => "Fiji",
            "FI" => "Finland",
            "FR" => "France",
            "GF" => "French Guiana",
            "PF" => "French Polynesia",
            "TF" => "French Southern Territories",
            "GA" => "Gabon",
            "GM" => "Gambia",
            "GE" => "Georgia",
            "DE" => "Germany",
            "GH" => "Ghana",
            "GI" => "Gibraltar",
            "GR" => "Greece",
            "GL" => "Greenland",
            "GD" => "Grenada",
            "GP" => "Guadeloupe",
            "GU" => "Guam",
            "GT" => "Guatemala",
            "GN" => "Guinea",
            "GW" => "Guinea-Bissau",
            "GY" => "Guyana",
            "HT" => "Haiti",
            "HM" => "Heard Island and Mcdonald Islands",
            "VA" => "Holy See (Vatican City State)",
            "HN" => "Honduras",
            "HK" => "Hong Kong",
            "HU" => "Hungary",
            "IS" => "Iceland",
            "IN" => "India",
            "ID" => "Indonesia",
            "IR" => "Iran, Islamic Republic of",
            "IQ" => "Iraq",
            "IE" => "Ireland",
            "IL" => "Israel",
            "IT" => "Italy",
            "JM" => "Jamaica",
            "JP" => "Japan",
            "JO" => "Jordan",
            "KZ" => "Kazakhstan",
            "KE" => "Kenya",
            "KI" => "Kiribati",
            "KP" => "Korea, Democratic People's Republic of",
            "KR" => "Korea, Republic of",
            "KW" => "Kuwait",
            "KG" => "Kyrgyzstan",
            "LA" => "Lao People's Democratic Republic",
            "LV" => "Latvia",
            "LB" => "Lebanon",
            "LS" => "Lesotho",
            "LR" => "Liberia",
            "LY" => "Libyan Arab Jamahiriya",
            "LI" => "Liechtenstein",
            "LT" => "Lithuania",
            "LU" => "Luxembourg",
            "MO" => "Macao",
            "MK" => "Macedonia, the Former Yugoslav Republic of",
            "MG" => "Madagascar",
            "MW" => "Malawi",
            "MY" => "Malaysia",
            "MV" => "Maldives",
            "ML" => "Mali",
            "MT" => "Malta",
            "MH" => "Marshall Islands",
            "MQ" => "Martinique",
            "MR" => "Mauritania",
            "MU" => "Mauritius",
            "YT" => "Mayotte",
            "MX" => "Mexico",
            "FM" => "Micronesia, Federated States of",
            "MD" => "Moldova, Republic of",
            "MC" => "Monaco",
            "MN" => "Mongolia",
            "MS" => "Montserrat",
            "MA" => "Morocco",
            "MZ" => "Mozambique",
            "MM" => "Myanmar",
            "NA" => "Namibia",
            "NR" => "Nauru",
            "NP" => "Nepal",
            "NL" => "Netherlands",
            "AN" => "Netherlands Antilles",
            "NC" => "New Caledonia",
            "NZ" => "New Zealand",
            "NI" => "Nicaragua",
            "NE" => "Niger",
            "NG" => "Nigeria",
            "NU" => "Niue",
            "NF" => "Norfolk Island",
            "MP" => "Northern Mariana Islands",
            "NO" => "Norway",
            "OM" => "Oman",
            "PK" => "Pakistan",
            "PW" => "Palau",
            "PS" => "Palestinian Territory, Occupied",
            "PA" => "Panama",
            "PG" => "Papua New Guinea",
            "PY" => "Paraguay",
            "PE" => "Peru",
            "PH" => "Philippines",
            "PN" => "Pitcairn",
            "PL" => "Poland",
            "PT" => "Portugal",
            "PR" => "Puerto Rico",
            "QA" => "Qatar",
            "RE" => "Reunion",
            "RO" => "Romania",
            "RU" => "Russian Federation",
            "RW" => "Rwanda",
            "SH" => "Saint Helena",
            "KN" => "Saint Kitts and Nevis",
            "LC" => "Saint Lucia",
            "PM" => "Saint Pierre and Miquelon",
            "VC" => "Saint Vincent and the Grenadines",
            "WS" => "Samoa",
            "SM" => "San Marino",
            "ST" => "Sao Tome and Principe",
            "SA" => "Saudi Arabia",
            "SN" => "Senegal",
            "CS" => "Serbia and Montenegro",
            "SC" => "Seychelles",
            "SL" => "Sierra Leone",
            "SG" => "Singapore",
            "SK" => "Slovakia",
            "SI" => "Slovenia",
            "SB" => "Solomon Islands",
            "SO" => "Somalia",
            "ZA" => "South Africa",
            "GS" => "South Georgia and the South Sandwich Islands",
            "ES" => "Spain",
            "LK" => "Sri Lanka",
            "SD" => "Sudan",
            "SR" => "Suriname",
            "SJ" => "Svalbard and Jan Mayen",
            "SZ" => "Swaziland",
            "SE" => "Sweden",
            "CH" => "Switzerland",
            "SY" => "Syrian Arab Republic",
            "TW" => "Taiwan, Province of China",
            "TJ" => "Tajikistan",
            "TZ" => "Tanzania, United Republic of",
            "TH" => "Thailand",
            "TL" => "Timor-Leste",
            "TG" => "Togo",
            "TK" => "Tokelau",
            "TO" => "Tonga",
            "TT" => "Trinidad and Tobago",
            "TN" => "Tunisia",
            "TR" => "Turkey",
            "TM" => "Turkmenistan",
            "TC" => "Turks and Caicos Islands",
            "TV" => "Tuvalu",
            "UG" => "Uganda",
            "UA" => "Ukraine",
            "AE" => "United Arab Emirates",
            "GB" => "United Kingdom",
            "US" => "United States",
            "UM" => "United States Minor Outlying Islands",
            "UY" => "Uruguay",
            "UZ" => "Uzbekistan",
            "VU" => "Vanuatu",
            "VE" => "Venezuela",
            "VN" => "Viet Nam",
            "VG" => "Virgin Islands, British",
            "VI" => "Virgin Islands, U.s.",
            "WF" => "Wallis and Futuna",
            "EH" => "Western Sahara",
            "YE" => "Yemen",
            "ZM" => "Zambia",
            "ZW" => "Zimbabwe"
        );
    }
}

?>
