<?php
/*
Plugin Name: Wabot WhatsApp Automation
Plugin URI:  https://www.wabot.my/
Description: Send WhatsApp order notification from WooCommerce with Wabot.
Version:     1.0.0
Author:      Wabot
Author URI:  https://www.wabot.my
License:     GPLv3
License URI: http://www.gnu.org/licenses/gpl-3.0.html
Text Domain: wabot-woocommerce
*/

if ( ! defined( 'WPINC' ) ) {
	die;
}

define("WABOT_PLUGIN_URL", plugin_dir_url(__FILE__));
define("WABOT_PLUGIN_DIR", plugin_dir_path(__FILE__));
define("WABOT_INC_DIR", WABOT_PLUGIN_DIR . "includes/");
define("WABOT_ADMIN_VIEW", WABOT_PLUGIN_DIR . "admin/");
define("WABOT_TXT_DOMAIN", "wabot-woocoommerce");

require_once WABOT_PLUGIN_DIR . 'lib/action-scheduler/action-scheduler.php';

add_filter( 'plugin_action_links_wabot/wabot.php', 'wabot_settings_link' );
function wabot_settings_link( $links ) {
	$url = esc_url( add_query_arg( 'page', 'wabot-settings', get_admin_url() . 'admin.php' ) );
	$settings_link = "<a href='$url'>" . __( 'Settings' ) . '</a>';
	array_unshift( $links, $settings_link );
	return $links;
}

add_action( 'plugins_loaded', 'wabot_woocommerce_init', PHP_INT_MAX );

function wabot_woocommerce_init() {
	require_once ABSPATH . '/wp-admin/includes/plugin.php';
	require_once ABSPATH . '/wp-includes/pluggable.php';
	require_once WABOT_PLUGIN_DIR . 'Wabot_PI.php';
	require_once WABOT_PLUGIN_DIR . 'inc/contracts/class-wabot-register-interface.php';
	require_once WABOT_PLUGIN_DIR . 'inc/class-wabot-helper.php';
	require_once WABOT_PLUGIN_DIR . 'inc/class-wabot-woocommerce-frontend-scripts.php';
	require_once WABOT_PLUGIN_DIR . 'inc/class-wabot-woocommerce-hook.php';
	require_once WABOT_PLUGIN_DIR . 'inc/class-wabot-woocommerce-register.php';
	require_once WABOT_PLUGIN_DIR . 'inc/class-wabot-woocommerce-logger.php';
	require_once WABOT_PLUGIN_DIR . 'inc/class-wabot-woocommerce-notification.php';
	require_once WABOT_PLUGIN_DIR . 'inc/class-wabot-download-log.php';
	require_once WABOT_PLUGIN_DIR . 'inc/class-wabot-sendwa.php';
	require_once WABOT_PLUGIN_DIR . 'inc/multivendor/class-wabot-multivendor.php';
	require_once WABOT_PLUGIN_DIR . 'lib/Wabot-api.php';
	require_once WABOT_PLUGIN_DIR . 'lib/class.settings-api.php';
	require_once WABOT_PLUGIN_DIR . 'admin/class-wabot-woocommerce-setting.php';
	require_once WABOT_PLUGIN_DIR . 'admin/send-wa.php';
	require_once WABOT_PLUGIN_DIR . 'admin/integration.php';
	require_once WABOT_PLUGIN_DIR . 'admin/logs.php';
	require_once WABOT_PLUGIN_DIR . 'admin/help.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotS2Member.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotARMember.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotMemberPress.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotMemberMouse.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotSimpleMembership.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotRestaurantReservation.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotQuickRestaurantReservation.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotBookIt.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotLatePoint.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotFATService.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotWpERP.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotJetpackCRM.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotFluentCRM.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotGroundhoggCRM.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotSupportedPlugin.php';
    require_once WABOT_PLUGIN_DIR . 'inc/plugins/WabotContactForm7.php';

	//create notification instance
	$wabot_notification = new Wabot_WooCommerce_Notification();

	//register hooks and settings
	$registerInstance = new Wabot_WooCommerce_Register();
	$registerInstance->add( new Wabot_WooCommerce_Hook( $wabot_notification ) )
	                 ->add( new Wabot_WooCommerce_Setting() )
	                 ->add( new Wabot_WooCommerce_Frontend_Scripts() )
	                 ->add( new Wabot_Multivendor() )
	                 ->add( new Wabot_Download_log() )
	                 ->add( new Wabot_Automation_View() )
	                 ->add( new Wabot_SendWA_View() )
	                 ->add( new Wabot_Logs_View() )
	                 ->add( new Wabot_Help_View() )
					 ->add( new WabotContactForm7() )
	                 ->load();
}
?>
