<?php

class Wabot_Multivendor_Setting implements Wabot_Register_Interface {
	public function register() {
		add_filter( 'wabot_setting_section', array( $this, 'set_multivendor_setting_section' ) );
		add_filter( 'wabot_setting_fields', array( $this, 'set_multivendor_setting_field' ) );
	}

	public function set_multivendor_setting_section( $sections ) {
		if( class_exists( 'woocommerce' ) ):
			$sections[] = array(
				'id'    => 'wabot_multivendor_setting',
				'title' => __( 'Multivendor Notifications', WABOT_TXT_DOMAIN )
			);
		endif;
		return $sections;
	}

	public function set_multivendor_setting_field( $setting_fields ) {
		$setting_fields['wabot_multivendor_setting'] = array(
			array(
				'name'    => 'wabot_multivendor_vendor_send_wa',
				'label'   => __( 'Enable Vendor Notifications', WABOT_TXT_DOMAIN ),
				'desc'    => 'Enable',
				'type'    => 'checkbox',
				'default' => 'off',
			),
			array(
				'name'    => 'wabot_multivendor_vendor_send_wa_on',
				'label'   => __( 'Send notification on', WABOT_TXT_DOMAIN ),
				'desc'    => __( 'Select order statuses for which you want to enable sending WhatsApp notifications', WABOT_TXT_DOMAIN ),
				'type'    => 'multicheck',
				'default' => array(
					'pending'    => 'pending',
					'on-hold'    => 'on-hold',
					'processing' => 'processing',
					'completed'  => 'completed',
					'cancelled'  => 'cancelled',
					'refunded'   => 'refunded',
					'failed'     => 'failed'
				),
				'options' => array(
					'pending'    => ' Pending',
					'on-hold'    => ' On-hold',
					'processing' => ' Processing',
					'completed'  => ' Completed',
					'cancelled'  => ' Cancelled',
					'refunded'   => ' Refunded',
					'failed'     => ' Failed'
				)
			),
			array(
				'name'    => 'wabot_multivendor_selected_plugin',
				'label'   => __( 'Third Party Plugin', WABOT_TXT_DOMAIN ),
				'desc'    => 'If Auto Detect option not working, try select a multivendor plugin you are using.<br /><span id="multivendor_setting[multivendor_helper_desc]"></span>',
				'type'    => 'select',
				'default' => 'auto',
				'options' => array(
					'auto'             => 'Auto Detect',
					'product_vendors'  => 'Woocommerce Product Vendors',
					'wc_marketplace'   => 'WC Marketplace',
					'wc_vendors'       => 'WC Vendors Marketplace',
					'wcfm_marketplace' => 'WooCommerce Multivendor Marketplace',
					'dokan'            => 'Dokan',
					'yith'             => 'YITH WooCommerce Multi Vendor'
				)
			),
			array(
				'name'    => 'wabot_multivendor_vendor_wa_template',
				'label'   => __( 'Vendor Message', WABOT_TXT_DOMAIN ),
				'type'    => 'textarea',
				'rows'    => '8',
				'cols'    => '500',
				'css'     => 'min-width:350px',
				'default' => __( '[shop_name] : You have a new order with order ID [order_id] and order amount [order_currency] [order_amount]. The order is now [order_status].', WABOT_TXT_DOMAIN )
			),
			array(
				'name'    => 'wabot_multivendor_vendor_wa_template_file',
				'label'   => '',
				'desc'    => '<button type="button" id="wabot_wa[open-keywords]" data-attr-type="multivendor" data-attr-target="wabot_multivendor_setting[wabot_multivendor_vendor_wa_template]" class="button button-secondary">Keywords</button>',
				'type'    => 'file',
			),
			array(
				'name'  => 'export_multivendor_log',
				'label' => 'Export Vendor Logs',
				'desc'  => '<a href="' . admin_url( 'admin.php?page=wabot-download-file&file=Wabot_Multivendor' ) . '" class="button button-secondary">Export Logs</a>',
				'type'  => 'html'
			),
		);

		return $setting_fields;
	}
}

?>
