<?php
class Wabot_Multivendor implements Wabot_Register_Interface {
	public function register() {
		$this->required_files();
		//create notification instance
		$wabot_notification = new Wabot_Multivendor_Notification( 'Wordpress-Woocommerce-Multivendor-Extension-' . Wabot_Multivendor_Factory::$activatedPlugin );

		$registerInstance = new Wabot_WooCommerce_Register();
		$registerInstance->add( new Wabot_Multivendor_Hook( $wabot_notification ) )
		                 ->add( new Wabot_Multivendor_Setting() )
		                 ->load();
	}

	protected function required_files() {
		require_once __DIR__ . '/admin/class-wabot-multivendor-setting.php';
		require_once __DIR__ . '/abstract/abstract-wabot-multivendor.php';
		require_once __DIR__ . '/contracts/class-wabot-multivendor-interface.php';
		require_once __DIR__ . '/class-wabot-multivendor-factory.php';
		require_once __DIR__ . '/class-wabot-multivendor-hook.php';
		require_once __DIR__ . '/class-wabot-multivendor-notification.php';
	}
}
