<?php

class Wabot_Help_View implements Wabot_Register_Interface {

	private $settings_api;

	function __construct() {
		$this->settings_api = new WeDevs_Settings_API;
	}

	public function register() {
        add_filter( 'wabot_setting_section',     array($this, 'set_help_setting_section' ) );
		add_filter( 'wabot_setting_fields',      array($this, 'set_help_setting_field' ) );
        add_action( 'wabot_setting_fields_custom_html', array($this, 'display_help_page'), 10, 1);
	}

	public function set_help_setting_section( $sections ) {
		$sections[] = array(
            'id'               => 'wabot_help_setting',
            'title'            => __( 'Help', WABOT_TXT_DOMAIN ),
            'submit_button'    => '',
		);

		return $sections;
	}

	/**
	 * Returns all the settings fields
	 *
	 * @return array settings fields
	 */
	public function set_help_setting_field( $setting_fields ) {
		return $setting_fields;
	}

    public function display_help_page($form_id) {
        if($form_id !== 'wabot_help_setting') { return; }
    ?>
	<div class="bootstrap-wrapper">	
		<div class="help-wrapper">
			<h4>I have questions. Do you have any support line?</h4>
			<p>If you have any other questions or need some help, you can contact our customer support team by clicking contact button on <a href="https://wabot.my/" target="_blank">our site</a>.</p>
		</div>	
	</div>	
    <?php
    }
}
?>
