<?php
/*
 * Integration with Wabot RESTful API
 */

class Wabot {

    // Account credentials
    private $dashboard_prefix = '';
    private $instance_id = '';
    private $access_token = '';

    // REST API URL
    public $rest_base_url = 'wabot.my/api';

    private $rest_commands = array (
            'send_text' => array('url' => '/send.php'),
            'send_group' => array('url' => '/sendgroupmsg.php'),
            'get_qr' => array('url' => '/getqrcode.php'),
            'set_webhook' => array('url' => '/setwebhook.php'),
            'reboot_instance' => array('url' => '/reboot.php'),
            'reset_instance' => array('url' => '/resetinstance.php'),
            'reconnect_instance' => array('url' => '/reconnect.php'),
    );

    public function __construct($dashboard_prefix = null, $instance_id = null, $access_token = null)
    {
        $this->dashboard_prefix = $dashboard_prefix;
        $this->instance_id = $instance_id;
        $this->access_token = $access_token;
    }

    function sendWA($type,$number,$message,$media_url)
    {
        $logger = new Wabot_WooCoommerce_Logger();
        $logger->add("Wabot", "(2) Message Sent to {$number}.");
        // Send request to Wabot gateway
        $params = array(
                'type' => $type,
                'number' => $number,
                'message' => $message,
                'media_url' => $media_url
        );
		$filename = '';
		if($media_url !== '') {
			$imgExts = array("gif", "jpg", "jpeg", "png");
			$urlExt = pathinfo($media_url, PATHINFO_EXTENSION);
			if (!in_array($urlExt, $imgExts)) {
				$path_parts = pathinfo($media_url);
				$filename = $path_parts['filename'];
				$params['filename'] = $filename;
			}			
		}
        return $this->invokeApi ('send_text', $params);
    }

    private function invokeApi ($command, $params = array())
    {
        // Get REST URL and HTTP method
        $command_info = $this->rest_commands[$command];
        $url = 'https://' . $this->dashboard_prefix . '.' . $this->rest_base_url . $command_info['url'];

        // Build the post data
        $params = array_merge($params, array('access_token' => $this->access_token,'instance_id' => $this->instance_id));
		
		$rest_response = wp_remote_retrieve_body( wp_remote_get( $url . '?' . http_build_query($params), array( 'sslverify' => false, 'timeout' => 60 ) ) );
		
        return $rest_response;
    }
}
?>
