<?php

class WFCO_Wabot_Verify extends \WFCO_Call {
    private static $instance = null;
	private $api_end_point = null;

	public function __construct() {
		$this->required_fields = array( 'instance_id', 'access_token' );
		$this->api_end_point   = 'https://app.wabot.my/api/check_instance';
	}

    /**
	 * @return WFCO_Wabot_Verify|null
	 */

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

    /**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_wabot_verify';
	}

    public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$params = array(
			'access_token'  => $this->data['access_token'],
			'instance_id'   => $this->data['instance_id'],
		);

		$headers = array();
		$url       = $this->api_end_point;

		$res = $this->make_wp_requests( $url, $params, $headers, \BWF_CO::$GET );

		return $res;
	}
}

return 'WFCO_Wabot_Verify';