/* global FlowMatticWorkflow, FlowMatticWorkflowEvents, FlowMatticWorkflowApp, FlowMatticWorkflowSteps */
var FlowMatticWorkflow = FlowMatticWorkflow || {};

( function( $ ) {

	jQuery( document ).ready( function() {
		// Workflow action wabot View.
		FlowMatticWorkflow.WabotView = Backbone.View.extend( {
			actionTemplate: FlowMatticWorkflow.template( jQuery( '#flowmattic-application-wabot-action-data-template' ).html() ),

			events: {
			},

			initialize: function() {
			},

			render: function() {
				var thisEl = this,
					applicationSettings = {},
					appAction = this.model.get( 'action' ),
					appActionTemplate = '',
					submissionData = {};

				if ( 'undefined' === typeof this.model.get( 'actionAppArgs' ) ) {
					this.model.set( 'actionAppArgs', [] );
				}

				this.$el.html( this.actionTemplate( this.model.toJSON() ) );

				if ( jQuery( '#flowmattic-application-wabot-action-' + appAction + '-data-template' ).length ) {
					appActionTemplate = FlowMatticWorkflow.template( jQuery( '#flowmattic-application-wabot-action-' + appAction + '-data-template' ).html() );
					jQuery( this.$el ).find( '.flowmattic-wabot-action-fields' ).html( appActionTemplate( this.model.toJSON() ) );
				}

				this.setActionOptions();

				this.$el.find( 'select' ).selectpicker();

				return this;
			},

			setActionOptions: function() {
				var elements = jQuery( this.$el ).find( '.flowmattic-wabot-action-data' ),
					currentAction = this.model.get( 'action' );

				elements.hide();

				if ( '' !== currentAction ) {
					jQuery( this.$el ).find( '.flowmattic-wabot-action-data' ).show();
				}
			}
		} );
	} );
}( jQuery ) );
