<?php

/** 
 ** 
 **              ██╗ █████╗ ██████╗ ██╗██╗      █████╗ ██╗  ██╗    ███╗   ███╗██╗   ██╗███████╗██╗     ██╗███╗   ███╗             
 **              ██║██╔══██╗██╔══██╗██║██║     ██╔══██╗██║  ██║    ████╗ ████║██║   ██║██╔════╝██║     ██║████╗ ████║             
 **              ██║███████║██║  ██║██║██║     ███████║███████║    ██╔████╔██║██║   ██║███████╗██║     ██║██╔████╔██║             
 **         ██   ██║██╔══██║██║  ██║██║██║     ██╔══██║██╔══██║    ██║╚██╔╝██║██║   ██║╚════██║██║     ██║██║╚██╔╝██║             
 **         ╚█████╔╝██║  ██║██████╔╝██║███████╗██║  ██║██║  ██║    ██║ ╚═╝ ██║╚██████╔╝███████║███████╗██║██║ ╚═╝ ██║             
 **          ╚════╝ ╚═╝  ╚═╝╚═════╝ ╚═╝╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝    ╚═╝     ╚═╝ ╚═════╝ ╚══════╝╚══════╝╚═╝╚═╝     ╚═╝             
 **                                                                                                                               
 **  █████╗ ███╗   ███╗ █████╗ ███╗   ██╗ █████╗ ██╗  ██╗       ██╗       ██████╗ ███████╗██████╗  █████╗ ██████╗  █████╗ ██████╗ 
 ** ██╔══██╗████╗ ████║██╔══██╗████╗  ██║██╔══██╗██║  ██║       ██║       ██╔══██╗██╔════╝██╔══██╗██╔══██╗██╔══██╗██╔══██╗██╔══██╗
 ** ███████║██╔████╔██║███████║██╔██╗ ██║███████║███████║    ████████╗    ██████╔╝█████╗  ██████╔╝███████║██║  ██║███████║██████╔╝
 ** ██╔══██║██║╚██╔╝██║██╔══██║██║╚██╗██║██╔══██║██╔══██║    ██╔═██╔═╝    ██╔══██╗██╔══╝  ██╔══██╗██╔══██║██║  ██║██╔══██║██╔══██╗
 ** ██║  ██║██║ ╚═╝ ██║██║  ██║██║ ╚████║██║  ██║██║  ██║    ██████║      ██████╔╝███████╗██║  ██║██║  ██║██████╔╝██║  ██║██████╔╝
 ** ╚═╝  ╚═╝╚═╝     ╚═╝╚═╝  ╚═╝╚═╝  ╚═══╝╚═╝  ╚═╝╚═╝  ╚═╝    ╚═════╝      ╚═════╝ ╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝╚═════╝ ╚═╝  ╚═╝╚═════╝ 
 **                                                                                                                     
 ** Semoga Allah Ta'ala TIDAK memberkahi perniagaan orang yang mengutip kode program di plugin ini 
 ** "Tidak dihalalkan harta seorang muslimin kecuali yang diberikan dari ketulusan hatinya yang dalam."
 ** ( HR Al Baihaqi, Ahmad, Ad-Daraquthni - Dishahihkan oleh Al-Albani )
 ** 
***/

class WFCO_Wabot_Remove_From_ContactGroup extends WFCO_Call {

	private static $instance = null;
	private $api_end_point = null;

	public function __construct() {

		$this->required_fields = array( 'access_token', 'subdomain', 'contact', 'group_id' );

	}

	/**
	 * @return WFCO_Wabot_Remove_From_ContactGroup|null
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
				return $this->show_fields_error();
			}
		
		$req_params = array();

		$subdomain = $this->data['subdomain'];
		$url       = "https://{$subdomain}.wabot.my/api/contact_groups.php";

		$headers = array(
			'Content-Type' => 'application/form-data',
		);

		$this->data['contact'] = BWFAN_Common::decode_merge_tags( $this->data['contact'] );

		$req_params = array(
			'contact'   => $this->data['contact'],
			'access_token' => $this->data['access_token'],
			'group_id'      => $this->data['group_id'],
		);

		$url = add_query_arg( array(
			'access_token' => $this->data['access_token'],
			'group_id'  => $this->data['group_id'],
			'type'	=> 'remove'
		), $url );
		

		$res = [];
		
			/** User 2 digit country code passed */
			if ( isset( $this->data['country_code'] ) && ! empty( $this->data['country_code'] ) ) {
				$req_params['contact'] = Phone_Numbers::add_country_code( $number, $this->data['country_code'] );
			}
		
			$str = ['+','-',' '];
			$req_params['contact'] = str_replace( $str, '', $req_params['contact'] );
			$url                  = add_query_arg( array( 'contact' => $req_params['contact'] ), $url );
			$res                  = $this->make_wp_requests( $url, array(), $headers, BWF_CO::$POST );

		return $res;
	}

}

return 'WFCO_Wabot_Remove_From_ContactGroup';
