<?php

/** 
 ** 
 **              ██╗ █████╗ ██████╗ ██╗██╗      █████╗ ██╗  ██╗    ███╗   ███╗██╗   ██╗███████╗██╗     ██╗███╗   ███╗             
 **              ██║██╔══██╗██╔══██╗██║██║     ██╔══██╗██║  ██║    ████╗ ████║██║   ██║██╔════╝██║     ██║████╗ ████║             
 **              ██║███████║██║  ██║██║██║     ███████║███████║    ██╔████╔██║██║   ██║███████╗██║     ██║██╔████╔██║             
 **         ██   ██║██╔══██║██║  ██║██║██║     ██╔══██║██╔══██║    ██║╚██╔╝██║██║   ██║╚════██║██║     ██║██║╚██╔╝██║             
 **         ╚█████╔╝██║  ██║██████╔╝██║███████╗██║  ██║██║  ██║    ██║ ╚═╝ ██║╚██████╔╝███████║███████╗██║██║ ╚═╝ ██║             
 **          ╚════╝ ╚═╝  ╚═╝╚═════╝ ╚═╝╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝    ╚═╝     ╚═╝ ╚═════╝ ╚══════╝╚══════╝╚═╝╚═╝     ╚═╝             
 **                                                                                                                               
 **  █████╗ ███╗   ███╗ █████╗ ███╗   ██╗ █████╗ ██╗  ██╗       ██╗       ██████╗ ███████╗██████╗  █████╗ ██████╗  █████╗ ██████╗ 
 ** ██╔══██╗████╗ ████║██╔══██╗████╗  ██║██╔══██╗██║  ██║       ██║       ██╔══██╗██╔════╝██╔══██╗██╔══██╗██╔══██╗██╔══██╗██╔══██╗
 ** ███████║██╔████╔██║███████║██╔██╗ ██║███████║███████║    ████████╗    ██████╔╝█████╗  ██████╔╝███████║██║  ██║███████║██████╔╝
 ** ██╔══██║██║╚██╔╝██║██╔══██║██║╚██╗██║██╔══██║██╔══██║    ██╔═██╔═╝    ██╔══██╗██╔══╝  ██╔══██╗██╔══██║██║  ██║██╔══██║██╔══██╗
 ** ██║  ██║██║ ╚═╝ ██║██║  ██║██║ ╚████║██║  ██║██║  ██║    ██████║      ██████╔╝███████╗██║  ██║██║  ██║██████╔╝██║  ██║██████╔╝
 ** ╚═╝  ╚═╝╚═╝     ╚═╝╚═╝  ╚═╝╚═╝  ╚═══╝╚═╝  ╚═╝╚═╝  ╚═╝    ╚═════╝      ╚═════╝ ╚══════╝╚═╝  ╚═╝╚═╝  ╚═╝╚═════╝ ╚═╝  ╚═╝╚═════╝ 
 **                                                                                                                     
 ** Semoga Allah Ta'ala TIDAK memberkahi perniagaan orang yang mengutip kode program di plugin ini 
 ** "Tidak dihalalkan harta seorang muslimin kecuali yang diberikan dari ketulusan hatinya yang dalam."
 ** ( HR Al Baihaqi, Ahmad, Ad-Daraquthni - Dishahihkan oleh Al-Albani )
 ** 
***/

class BWFCO_Wabot extends BWF_CO {
	public static $api_end_point = "https://".'subdomain'.".wabot.my/api/send.php";
	public static $headers = null;
	private static $ins = null;
	public $v2 = true;

	public function __construct() {

		/** Connector.php initialization */
		$this->keys_to_track = [
			'access_token',
			'instance_id',
			'subdomain',
		];
		$this->form_req_keys = [
			'access_token',
			'instance_id',
			'subdomain',
		];

		$this->sync          = false;
		$this->connector_url = WFCO_WABOT_PLUGIN_URL;
		$this->dir           = __DIR__;
		$this->nice_name     = __( 'Wabot', 'autonami-automations-connectors' );

		$this->autonami_int_slug = 'BWFAN_Wabot_Integration';

		add_filter( 'wfco_connectors_loaded', array( $this, 'add_card' ) );
		add_action( 'wp_ajax_bwf_test_message', array( __CLASS__, 'send_message_via_ajax_call' ) );
		add_action( 'wp_ajax_bwf_test_message_group', array( __CLASS__, 'send_message_group_via_ajax_call' ) );

	}

	public function get_fields_schema() {
		return array(
			array(
				'id'          => 'access_token',
				'label'       => __( 'Access Token', 'wp-marketing-automations-connectors' ),
				'type'        => 'text',
				'class'       => 'bwfan_wabot_access_token',
				'placeholder' => __( 'Access Token', 'wp-marketing-automations-connectors' ),
				'required'    => true,
				'toggler'     => array(),
			),
			array(
				'id'          => 'instance_id',
				'label'       => __( 'Instance ID', 'wp-marketing-automations-connectors' ),
				'type'        => 'text',
				'class'       => 'bwfan_wabot_instance_id',
				'placeholder' => __( 'Instance ID', 'wp-marketing-automations-connectors' ),
				'required'    => true,
				'toggler'     => array(),
			),
			array(
				'id'          => 'subdomain',
				'label'       => __( 'Wabot Dashboard Subdomain', 'wp-marketing-automations-connectors' ),
				'class'       => 'bwfan_wabot_subdomain',
				'type'        => 'radio',
				'options'     => [
					[
						'label' => __( "dash.wabot.my", 'wp-marketing-automations-connectors' ),
						'value' => 'dash'
					],
					[
						'label' => __( "dash2.wabot.my", 'wp-marketing-automations-connectors' ),
						'value' => 'dash2'
					],
					[
						'label' => __( "dash3.wabot.my", 'wp-marketing-automations-connectors' ),
						'value' => 'dash3'
					],
					[
						'label' => __( "dash4.wabot.my", 'wp-marketing-automations-connectors' ),
						'value' => 'dash4'
					],
					[
						'label' => __( "md.wabot.my", 'wp-marketing-automations-connectors' ),
						'value' => 'md'
					],
					[
						'label' => __( "vip.wabot.my", 'wp-marketing-automations-connectors' ),
						'value' => 'vip'
					],
					[
						'label' => __( "ctg.wabot.my", 'wp-marketing-automations-connectors' ),
						'value' => 'ctg'
					],
					[
						'label' => __( "free.wabot.my", 'wp-marketing-automations-connectors' ),
						'value' => 'free'
					]
				],
				'required'    => true,
				'toggler'     => array(),
			),
		);
	}

	public function get_settings_fields_values() {
		$saved_data = WFCO_Common::$connectors_saved_data;
		$old_data   = ( isset( $saved_data[ $this->get_slug() ] ) && is_array( $saved_data[ $this->get_slug() ] ) && count( $saved_data[ $this->get_slug() ] ) > 0 ) ? $saved_data[ $this->get_slug() ] : array();
		$vals       = array();
		if ( isset( $old_data['access_token'] ) ) {
			$vals['access_token'] = $old_data['access_token'];
		}
		if ( isset( $old_data['instance_id'] ) ) {
			$vals['instance_id'] = $old_data['instance_id'];
		}
		if ( isset( $old_data['subdomain'] ) ) {
			$vals['subdomain'] = $old_data['subdomain'];
		}

		return $vals;
	}

	/**
	 * Get data from the API call, must required function otherwise call
	 *
	 * @param $data
	 *
	 * @return array
	 */
	protected function get_api_data( $data ) {
		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_wabot_verify' );

		$resp_array = array(
			'api_data' => $data,
			'status'   => 'failed',
			'message'  => __( 'There is a problem verifying your credentials. Confirm entered details.', 'autonami-automations-connectors' ),
		);

		if ( is_null( $call_class ) ) {
			return $resp_array;
		}

		$payload = array(
			'access_token'    => isset( $data['access_token'] ) ? $data['access_token'] : '',
			'instance_id' => isset( $data['instance_id'] ) ? $data['instance_id'] : '',
			'subdomain'    => isset( $data['subdomain'] ) ? $data['subdomain'] : ''
		);
		
		$call_class->set_data( $payload );
		$request = $call_class->process();

		if ( is_array( $request ) && (200 === $request['response'] || 304 === $request['response']) && isset( $request['body'] ) ) {
			if ( ! isset( $request['body']['status'] ) ) {
				$resp_array['status']   = 'failed';
				$resp_array['message']  = __( 'Undefined API Error', 'autonami-automations-connectors' );

				return $resp_array;
			}

			if ( $request['body']['status'] === 'error' ) {
				$resp_array['status']   = 'failed';
				$resp_array['message']  = isset( $request['body']['message'] ) ? $request['body']['message'] : __( 'Undefined API Error', 'autonami-automations-connectors' );

				return $resp_array;
			}
			
		} else {
			$resp_array['status']   = 'failed';
			$resp_array['message']  = __( 'Unable to verify credentials', 'autonami-automations-connectors' );

			return $resp_array;
		}

		$response                               = [];
		$response['status']                     = 'success';
		$response['api_data']['access_token']   = $data['access_token'];
		$response['api_data']['instance_id']    = $data['instance_id'];
		$response['api_data']['subdomain']      = $data['subdomain'];

		return $response;
	}


	public static function get_instance() {
		if ( null === self::$ins ) {
			self::$ins = new self();
		}

		return self::$ins;
	}

	public static function set_headers() {

		$headers = array(
			'Content-Type' => 'application/json'
		);

		self::$headers = $headers;
	}

	public function add_card( $available_connectors ) {
		$available_connectors['autonami']['connectors']['bwfco_wabot'] = array(
			'name'            => 'Wabot',
			'desc'            => __( 'Engage your customers via WhatsApp, send messages and broadcast.', 'autonami-automations-connectors' ),
			'connector_class' => 'BWFCO_Wabot',
			'image'           => $this->get_image(),
			'source'          => '',
			'file'            => '',
		);

		return $available_connectors;
	}

	/**
	 * Sending message by ajax request
	 */
	public static function send_message_via_ajax_call() {
		BWFAN_Common::check_nonce();
		$response = self::send_message( true );
		wp_send_json( $response );
	}

	public static function send_message_group_via_ajax_call() {
		BWFAN_Common::check_nonce();
		$response = self::send_message_group( true );
		wp_send_json( $response );
	}

	public static function send_message_via_broadcast( $phone, $messages, $utm = [] ) {
		$response = [
			'status' => false,
		];
		foreach ( $messages as $message ) {
			$data                   = [ 'data' => [] ];
			$data['data']['sms_to'] = $phone;
			$data['data']['type']   = $data['data']['bwfan_sms_select'] = $message['type'];
			if ( $message['type'] == 'text' ) {
				$data['data']['sms_body_textarea'] = $message['data'];
			} else {
				$data['data']['sms_body_text'] = $message['data'];
			}
			if ( ! empty( $utm ) ) {
				if ( isset( $utm['utm_source'] ) && ! empty( $utm['utm_source'] ) ) {
					$data['data']['sms_utm_source'] = $utm['utm_source'];
				}
				if ( isset( $utm['utm_medium'] ) && ! empty( $utm['utm_medium'] ) ) {
					$data['data']['sms_utm_medium'] = $utm['utm_medium'];
				}
				if ( isset( $utm['utm_name'] ) && ! empty( $utm['utm_name'] ) ) {
					$data['data']['sms_utm_campaign'] = $utm['utm_name'];
				}
				if ( isset( $utm['utm_term'] ) && ! empty( $utm['utm_term'] ) ) {
					$data['data']['sms_utm_term'] = $utm['utm_term'];
				}
			}
			$response = self::send_message( false, $data );
		}

		return $response;
	}

	/**
	 * sending test message
	 */
	public static function send_message( $is_ajax, $data = [] ) {
		// phpcs:disable WordPress.Security.NonceVerification
		$result = array(
			'status' => false,
			'msg'    => __( 'Error', 'wp-marketing-automations' ),
		);

		if ( $is_ajax ) {
			$post = $_POST;
		} else {
			$post = $data;
		}
		
		if ( isset( $post['v'] ) && 2 === absint( $post['v'] ) ) {
			if ( ! isset( $post['sms_to'] ) ) {
				$result['msg'] = __( 'Phone number can\'t be blank', 'wp-marketing-automations' );

				return $result;
			}

			$sms_to   = $post['sms_to'];
			$sms_body = isset( $post['sms_body_textarea'] ) ? stripslashes( $post['sms_body_textarea'] ) : '';
			$type     = isset( $post['type'] ) ? sanitize_text_field( $post['type'] ) : 'text';
			$sms_file = isset( $post['sms_body_text'] ) ? stripslashes( $post['sms_body_text'] ) : '';
			$sms_file_name = isset( $post['sms_file_name'] ) ? stripslashes( $post['sms_file_name'] ) : '';

			$data_to_set['number']   = $sms_to;
			$data_to_set['sms_body'] = $sms_body;
			$data_to_set['type']     = $type;
			$data_to_set['sms_file'] = $sms_file;
			$data_to_set['sms_file_name'] = $sms_file_name;

		} else {
			if ( ! isset( $post['data']['sms_to'] ) ) {
				$result['msg'] = __( 'Phone number can\'t be blank', 'wp-marketing-automations' );

				return $result;
			}
	
			$type     = isset( $post['data']['type'] ) ? sanitize_text_field( $post['data']['type'] ) : 'text';
			$sms_body = isset( $post['data']['sms_body_textarea'] ) ? stripslashes( $post['data']['sms_body_textarea'] ) : '';
	
			/** for image and file */
			if ( 'text' !== $type ) {
				$sms_body = isset( $post['data']['sms_body_text'] ) ? sanitize_text_field( $post['data']['sms_body_text'] ) : '';
			}

			$data_to_set['number']   = $post['data']['sms_to'];
			$data_to_set['sms_body'] = $sms_body;
			$data_to_set['type']     = $type;
	
		}
	
		$data_to_set['test'] = true;

		/** @var  $global_settings */
		$global_settings = WFCO_Common::$connectors_saved_data;
		if ( ! array_key_exists( 'bwfco_wabot', $global_settings ) ) {
			return array(
				'msg'    => __( 'Wabot is not connected', 'wp-marketing-automations' ),
				'status' => false,
			);
		}

		$wabot_settings = $global_settings['bwfco_wabot'];

		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_wabot_send_sms' );

		$data_to_set['access_token']   = $wabot_settings['access_token'];
		$data_to_set['instance_id'] = $wabot_settings['instance_id'];
		$data_to_set['subdomain'] = $wabot_settings['subdomain'];

		// is_preview set to true for merge tag before sending data for sms;
		BWFAN_Merge_Tag_Loader::set_data( array(
			'is_preview' => true,
		) );
		
		$call_class->set_data( $data_to_set );
		$response = $call_class->process();

		if ( is_array( $response ) && 200 === $response['response'] && ( isset( $response['body']['status'] ) && $response['body']['status'] === 'success' ) ) {
			return array(
				'status' => true,
				'msg'    => __( 'Message sent successfully.', 'wp-marketing-automations' ),
			);
		}

		$message = __( 'Message could not be sent. ', 'autonami-automations-connectors' );
		$status  = false;

		if ( isset( $response['body']['message'] ) && $response['body']['status'] === 'error' ) {
			$message = $response['body']['message'];
		} elseif ( isset( $response['body']['message'] ) ) {
			$message = $response['body']['message'];
		} elseif ( isset( $response['bwfan_response'] ) && ! empty( $response['bwfan_response'] ) ) {
			$message = $response['bwfan_response'];
		} elseif ( is_array( $response['body'] ) && isset( $response['body'][0] ) && is_string( $response['body'][0] ) ) {
			$message = $message . $response['body'][0];
		}

		return array(
			'status' => $status,
			'msg'    => $message,
		);
	}

	public static function send_message_group( $is_ajax, $data = [] ) {
		// phpcs:disable WordPress.Security.NonceVerification
		$result = array(
			'status' => false,
			'msg'    => __( 'Error', 'wp-marketing-automations' ),
		);

		if ( $is_ajax ) {
			$post = $_POST;
		} else {
			$post = $data;
		}
		if ( isset( $post['v'] ) && 2 === absint( $post['v'] ) ) {
			if ( ! isset( $post['sms_to'] ) ) {
				$result['msg'] = __( 'Phone number can\'t be blank', 'wp-marketing-automations' );

				return $result;
			}

			$sms_to   = $post['sms_to'];
			$sms_body = isset( $post['sms_body_textarea'] ) ? stripslashes( $post['sms_body_textarea'] ) : '';
			$type     = isset( $post['type'] ) ? sanitize_text_field( $post['type'] ) : 'text';
			$sms_file = isset( $post['sms_body_text'] ) ? stripslashes( $post['sms_body_text'] ) : '';
			$sms_file_name = isset( $post['sms_file_name'] ) ? stripslashes( $post['sms_file_name'] ) : '';

			$data_to_set['number']   = $sms_to;
			$data_to_set['sms_body'] = $sms_body;
			$data_to_set['type']     = $type;
			$data_to_set['sms_file'] = $sms_file;
			$data_to_set['sms_file_name'] = $sms_file_name;

		} else {
			if ( ! isset( $post['data']['sms_to'] ) ) {
				$result['msg'] = __( 'Phone number can\'t be blank', 'wp-marketing-automations' );

				return $result;
			}

			$type     = isset( $post['data']['type'] ) ? sanitize_text_field( $post['data']['type'] ) : 'text';
			$sms_body = isset( $post['data']['sms_body_textarea'] ) ? sanitize_text_field( $post['data']['sms_body_textarea'] ) : '';
			$sms_file = isset( $post['data']['sms_body_text'] ) ? stripslashes( $post['data']['sms_body_text'] ) : '';

			$data_to_set['number']   = $post['data']['sms_to'];
			$data_to_set['sms_body'] = $sms_body;
			$data_to_set['type']     = $type;
			$data_to_set['sms_file'] = $sms_file;
		}

		$data_to_set['test'] = true;

		/** @var  $global_settings */
		$global_settings = WFCO_Common::$connectors_saved_data;
		if ( ! array_key_exists( 'bwfco_wabot', $global_settings ) ) {
			return array(
				'msg'    => __( 'Wabot is not connected', 'wp-marketing-automations' ),
				'status' => false,
			);
		}

		$wabot_settings = $global_settings['bwfco_wabot'];

		$load_connector = WFCO_Load_Connectors::get_instance();
		$call_class     = $load_connector->get_call( 'wfco_wabot_send_group' );

		$data_to_set['access_token']   = $wabot_settings['access_token'];
		$data_to_set['instance_id'] = $wabot_settings['instance_id'];
		$data_to_set['subdomain'] = $wabot_settings['subdomain'];

		// is_preview set to true for merge tag before sending data for sms;
		BWFAN_Merge_Tag_Loader::set_data( array(
			'is_preview' => true,
		) );
		$call_class->set_data( $data_to_set );
		$response = $call_class->process();

		if ( is_array( $response ) && 200 === $response['response'] && ( isset( $response['body']['status'] ) && $response['body']['status'] === 'success' ) ) {
			return array(
				'status' => true,
				'msg'    => __( 'Message sent successfully.', 'wp-marketing-automations' ),
			);
		}

		$message = __( 'Message could not be sent. ', 'autonami-automations-connectors' );
		$status  = false;

		if ( isset( $response['body']['status'] ) && $response['body']['status'] === 'error' ) {
			$message = $response['body']['message'];
		} elseif ( isset( $response['body']['message'] ) ) {
			$message = $response['body']['message'];
		} elseif ( isset( $response['bwfan_response'] ) && ! empty( $response['bwfan_response'] ) ) {
			$message = $response['bwfan_response'];
		} elseif ( is_array( $response['body'] ) && isset( $response['body'][0] ) && is_string( $response['body'][0] ) ) {
			$message = $message . $response['body'][0];
		}

				return array(
			'status' => $status,
			'msg'    => $message,
		);
	}
	
	// public static function send_template_message( $is_ajax, $data = [] ) {
	// 	// phpcs:disable WordPress.Security.NonceVerification
	// 	$result = array(
	// 		'status' => false,
	// 		'msg'    => __( 'Error', 'wp-marketing-automations' ),
	// 	);

	// 	if ( $is_ajax ) {
	// 		$post = $_POST;
	// 	} else {
	// 		$post = $data;
	// 	}
		
	// 	if ( isset( $post['v'] ) && 2 === absint( $post['v'] ) ) {
	// 		if ( ! isset( $post['sms_to'] ) ) {
	// 			$result['msg'] = __( 'Phone number can\'t be blank', 'wp-marketing-automations' );

	// 			return $result;
	// 		}

	// 		$sms_to   = $post['sms_to'];
	// 		$sms_body = isset( $post['sms_body_textarea'] ) ? stripslashes( $post['sms_body_textarea'] ) : '';
	// 		$footer_text    = isset( $post['footer_text'] ) ? $post['footer_text'] : '';
	// 		$button_1_type    = isset( $post['button_1_type'] ) ? $post['button_1_type'] : '';
	// 		$button_1_title  = isset( $post['button_1_title'] ) ? $post['button_1_title'] : '';
	// 		$button_1_action    = isset( $post['button_1_action'] ) ? $post['button_1_action'] : '';
	// 		$button_2_type    = isset( $post['button_2_type'] ) ? $post['button_2_type'] : '';
	// 		$button_2_title  = isset( $post['button_2_title'] ) ? $post['button_2_title'] : '';
	// 		$button_2_action    = isset( $post['button_2_action'] ) ? $post['button_2_action'] : '';
	// 		$button_3_type    = isset( $post['button_3_type'] ) ? $post['button_3_type'] : '';
	// 		$button_3_title  = isset( $post['button_3_title'] ) ? $post['button_3_title'] : '';
	// 		$button_3_action    = isset( $post['button_3_action'] ) ? $post['button_3_action'] : '';
			
	// 		$data_to_set['number']   = $sms_to;
	// 		$data_to_set['sms_body'] = $sms_body;
	// 		$data_to_set['footer_text']     = $footer_text;
	// 		$data_to_set['button_1_type'] = $button_1_type;
	// 		$data_to_set['button_1_title'] = $button_1_title;
	// 		$data_to_set['button_1_action'] = $button_1_action;
	// 		$data_to_set['button_2_type'] = $button_2_type;
	// 		$data_to_set['button_2_title'] = $button_2_title;
	// 		$data_to_set['button_2_action'] = $button_2_action;
	// 		$data_to_set['button_3_type'] = $button_3_type;
	// 		$data_to_set['button_3_title'] = $button_3_title;
	// 		$data_to_set['button_3_action'] = $button_3_action;
	// 	} else {
	// 		if ( ! isset( $post['data']['sms_to'] ) ) {
	// 			$result['msg'] = __( 'Phone number can\'t be blank', 'wp-marketing-automations' );

	// 			return $result;
	// 		}
			
	// 		$sms_body = isset( $post['data']['sms_body_textarea'] ) ? stripslashes( $post['data']['sms_body_textarea'] ) : '';
	// 		$footer_text    = isset( $step_data['footer_text'] ) ? $step_data['footer_text'] : '';
	// 		$button_1_type    = isset( $step_data['button_1_type'] ) ? $step_data['button_1_type'] : '';
	// 		$button_1_title  = isset( $step_data['button_1_title'] ) ? $step_data['button_1_title'] : '';
	// 		$button_1_action    = isset( $step_data['button_1_action'] ) ? $step_data['button_1_action'] : '';
	// 		$button_2_type    = isset( $step_data['button_1_type'] ) ? $step_data['button_2_type'] : '';
	// 		$button_2_title  = isset( $step_data['button_1_title'] ) ? $step_data['button_2_title'] : '';
	// 		$button_2_action    = isset( $step_data['button_1_action'] ) ? $step_data['button_2_action'] : '';
	// 		$button_3_type    = isset( $step_data['button_1_type'] ) ? $step_data['button_3_type'] : '';
	// 		$button_3_title  = isset( $step_data['button_1_title'] ) ? $step_data['button_3_title'] : '';
	// 		$button_3_action    = isset( $step_data['button_1_action'] ) ? $step_data['button_3_action'] : '';
					
	// 		$data_to_set['number']   = $post['data']['sms_to'];
	// 		$data_to_set['sms_body'] = $sms_body;
	// 		$data_to_set['footer_text'] = $footer_text;
	// 		$data_to_set['button_1_type'] = $button_1_type;
	// 		$data_to_set['button_1_title'] = $button_1_title;
	// 		$data_to_set['button_1_action'] = $button_1_action;
	
	// 	}
	
	// 	$data_to_set['test'] = true;

	// 	/** @var  $global_settings */
	// 	$global_settings = WFCO_Common::$connectors_saved_data;
	// 	if ( ! array_key_exists( 'bwfco_wabot', $global_settings ) ) {
	// 		return array(
	// 			'msg'    => __( 'Wabot is not connected', 'wp-marketing-automations' ),
	// 			'status' => false,
	// 		);
	// 	}

	// 	$wabot_settings = $global_settings['bwfco_wabot'];

	// 	$load_connector = WFCO_Load_Connectors::get_instance();
	// 	$call_class     = $load_connector->get_call( 'wfco_wabot_send_template' );

	// 	$data_to_set['access_token']   = $wabot_settings['access_token'];
	// 	$data_to_set['instance_id'] = $wabot_settings['instance_id'];
	// 	$data_to_set['subdomain'] = $wabot_settings['subdomain'];

	// 	// is_preview set to true for merge tag before sending data for sms;
	// 	BWFAN_Merge_Tag_Loader::set_data( array(
	// 		'is_preview' => true,
	// 	) );
		
	// 	$call_class->set_data( $data_to_set );
	// 	$response = $call_class->process();

	// 	if ( is_array( $response ) && 200 === $response['response'] && ( isset( $response['body']['status'] ) && $response['body']['status'] === 'success' ) ) {
	// 		return array(
	// 			'status' => true,
	// 			'msg'    => __( 'Message sent successfully.', 'wp-marketing-automations' ),
	// 		);
	// 	}

	// 	$message = __( 'Message could not be sent. ', 'autonami-automations-connectors' );
	// 	$status  = false;

	// 	if ( isset( $response['body']['status'] ) && $response['body']['status'] === 'error' ) {
	// 		$message = $response['body']['message'];
	// 	} elseif ( isset( $response['body']['message'] ) ) {
	// 		$message = $response['body']['message'];
	// 	} elseif ( isset( $response['bwfan_response'] ) && ! empty( $response['bwfan_response'] ) ) {
	// 		$message = $response['bwfan_response'];
	// 	} elseif ( is_array( $response['body'] ) && isset( $response['body'][0] ) && is_string( $response['body'][0] ) ) {
	// 		$message = $message . $response['body'][0];
	// 	}

	// 	return array(
	// 		'status' => $status,
	// 		'msg'    => $message,
	// 	);
	// }	
}

WFCO_Load_Connectors::register( 'BWFCO_Wabot' );
