<?php

class WFCO_Wabot_Verify extends \WFCO_Call {
    private static $instance = null;
	private $api_end_point = null;

	public function __construct() {
		$this->required_fields = array( 'subdomain', 'instance_id', 'access_token' );
	//	$this->api_end_point   = 'https://api.wabot.my/check_instance';
	}

    /**
	 * @return WFCO_Wabot_Verify|null
	 */

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

    /**
	 * Get call slug
	 *
	 * @return string
	 */
	public function get_slug() {
		return 'wfco_wabot_verify';
	}

    public function process() {
		$is_required_fields_present = $this->check_fields( $this->data, $this->required_fields );
		if ( false === $is_required_fields_present ) {
			return $this->show_fields_error();
		}

		$params = array(
			'access_token'  => $this->data['access_token'],
			'instance_id'   => $this->data['instance_id'],
        //    'subdomain'     => $this->data['subdomain']
		);

		$headers = array();
        
		if ( 'dash' === strval( $this->data['subdomain'] ) ){
        $url       = "https://api.wabot.my/check_instance";
        }
		if ( 'dash2' === strval( $this->data['subdomain'] ) ){
			$url       = "https://api-dash2.wabot.my/check_instance";
			}
		if ( 'dash3' === strval( $this->data['subdomain'] ) ){
			$url       = "https://api-dash3.wabot.my/check_instance";
			}
		if ( 'dash4' === strval( $this->data['subdomain'] ) ){
			$url       = "https://api-dash4.wabot.my/check_instance";
			}
        if ( 'md' === strval( $this->data['subdomain'] ) ){
            $url       = "https://apiv2.wabot.my/check_instance";
        }
        if ( 'vip' === strval( $this->data['subdomain'] ) ){
            $url       = "https://api-vip.wabot.my/check_instance";
        }
		if ( 'ctg' === strval( $this->data['subdomain'] ) ){
            $url       = "https://api-ctg.wabot.my/check_instance";
        }
		if ( 'free' === strval( $this->data['subdomain'] ) ){
            $url       = "https://api-free.wabot.my/check_instance";
        }

		$res = $this->make_wp_requests( $url, $params, $headers, \BWF_CO::$GET );

		return $res;
	}
}

return 'WFCO_Wabot_Verify';