<?php
class Wabot_Multivendor_Notification extends Wabot_WooCommerce_Notification {
	private $wabot_multivendor;
	private $defaultHooks = array(
		'pending',
		'on-hold',
		'processing',
		'completed',
		'cancelled',
		'refunded',
		'failed'
	);

	public function __construct( $wabot_multivendor = null, Wabot_WooCoommerce_Logger $log = null ) {
		parent::__construct( $log );
		$wabot_multivendor = Wabot_Multivendor_Factory::make();
		if ( $wabot_multivendor === null ) {
			$wabot_multivendor = Wabot_Multivendor_Factory::make();
		}
		$this->wabot_multivendor = $wabot_multivendor;
	}

	public function send_to_vendors( $order_id, $status ) {
		if ( wabot_get_options( 'wabot_multivendor_vendor_send_wa', 'wabot_multivendor_setting', 'off' ) === 'off' ) {
			return;
		}
		$send_wa_flag = true;

		//Checking if multivendor is "wc_marketplace" but do not have suborder
		if (Wabot_Multivendor_Factory::$activatedPlugin == "wc_marketplace")
		{
			// if order id is not vendor order
			$is_suborder = (get_wcmp_suborders( $order_id, false, false) ? true : false);
			if( $is_suborder ) {
				//Do not send wa when it's sub order
				$send_wa_flag = false;
			}
		}

		if($send_wa_flag){
			// check for specific hook if wa should be send
			$activatedHooks = wabot_get_options( 'wabot_multivendor_vendor_send_wa_on', 'wabot_multivendor_setting', $this->defaultHooks );
			if ( ! in_array( $status, $activatedHooks ) ) {
				// $this->log->add( 'Wabot_Multivendor', 'Not sending. Current hook: ["' . $status . '"] Activated hooks: ' . json_encode( $activatedHooks ) );
				return;
			}

			// $this->log->add( 'Wabot_Multivendor', '3rd party plugin setting: ' . wabot_get_options( 'wabot_multivendor_selected_plugin', 'wabot_multivendor_setting', 'auto' ) );
			if ( ! $this->wabot_multivendor ) {
				// $this->log->add( 'Wabot_Multivendor', 'error: no multivendor plugin detected' );
				return;
			}
			// $this->log->add( 'Wabot_Multivendor', 'activated plugin: ' . Wabot_Multivendor_Factory::$activatedPlugin );
			// $this->log->add( 'Wabot', 'activated plugin: ' . Wabot_Multivendor_Factory::$activatedPlugin );

			$order_details = wc_get_order( $order_id );
			$message       = wabot_get_options( 'wabot_multivendor_vendor_wa_template', 'wabot_multivendor_setting', '' );
			$file       = wabot_get_options( 'wabot_multivendor_vendor_wa_template_file', 'wabot_multivendor_setting', '' );
			$default_country = wabot_get_options('wabot_woocommerce_country_code', 'wabot_setting', '' );

			if(!empty($file)) {
				$type = 'media';
			} else {
				$type = 'text';
			}
						
			$vendor_data_list = $this->wabot_multivendor->get_vendor_data_list_from_order( $order_id );
			if ( ! $vendor_data_list ) {
				$this->log->add( 'Wabot', 'No vendor list found' );
				return;
			}

			foreach ( $vendor_data_list as $phone_number => $vendor_datas ) {
				$phone_number = $this->phone_number_processing( $phone_number );
				// $this->log->add( 'Wabot', 'Original template: ' . $message );
				$processed_msg = $this->replace_vendor_order_keyword( $message, $order_details, $vendor_datas );
				$vendor_country = $this->wabot_multivendor->get_vendor_country_from_vendor_data( $vendor_datas );
                // $this->log->add( 'Wabot', "Vendor country: {$vendor_country}" );
                // $this->log->add( 'Wabot', "Default country: {$default_country}" );
				if(empty($vendor_country)){
                    $vendor_country = $default_country;
                    // $this->log->add( 'Wabot', "Country field being used: Default Country" );
				} else {
                    // $this->log->add( 'Wabot', "Country field being used: Vendor Country" );
                }

				$phone_with_country_code = $this->check_and_get_phone_number($phone_number, $vendor_country);
				if ( $phone_with_country_code !== false ) {
					// $this->log->add( 'Wabot', 'Vendor\'s phone number (' . $phone_number . ') in country (' . $vendor_country . ') converted to ' . $phone_with_country_code );
				}else {
					$phone_with_country_code = $phone_number;
				}
				$this->send_text( $type, $phone_with_country_code, $processed_msg, $file );
			}
		}
	}

	public function replace_vendor_order_keyword( $message, WC_Order $order_details, $vendor_datas ) {
		$search  = array(
			'[shop_name]',
			'[shop_email]',
			'[shop_url]',
			'[vendor_shop_name]',
			'[order_id]',
			'[order_currency]',
			'[order_amount]',
			'[order_status]',
			'[order_product]',
			'[order_product_with_qty]',
			'[billing_first_name]',
			'[billing_last_name]',
			'[billing_phone]',
			'[billing_email]',
			'[billing_company]',
			'[billing_address]',
			'[billing_country]',
			'[billing_city]',
			'[billing_state]',
			'[billing_postcode]',
			'[payment_method]'
		);
		$replace = array(
			get_bloginfo( 'name' ),
			get_bloginfo( 'admin_email' ),
			get_bloginfo( 'url' ),
			$this->wabot_multivendor->get_vendor_shop_name_from_vendor_data( $vendor_datas ),
			$order_details->get_order_number(),
			$order_details->get_currency(),
			$vendor_datas['total_amount_for_vendor'],
			ucfirst( $order_details->get_status() ),
			$vendor_datas['item'],
			$vendor_datas['product_with_qty'],
			$order_details->get_billing_first_name(),
			$order_details->get_billing_last_name(),
			$order_details->get_billing_phone(),
			$order_details->get_billing_email(),
			$order_details->get_billing_company(),
			$order_details->get_billing_address_1(),
			$order_details->get_billing_country(),
			$order_details->get_billing_city(),
			$order_details->get_billing_state(),
			$order_details->get_billing_postcode(),
			$order_details->get_payment_method()
		);
		$message = str_replace( $search, $replace, $message, $total_replaced );

		$additional_billing_fields_array = $this->get_additional_billing_fields();
		foreach ( $additional_billing_fields_array as $field ) {
			$post_data = get_post_meta( $order_details->get_order_number(), $field, true );
			$message   = str_replace( '[' . $field . ']', $post_data, $message );
		}

		// $this->log->add( 'Wabot', "Total replaced keyword: $total_replaced" );

		return $message;
	}

	protected function get_additional_billing_fields() {
		$default_billing_fields = array(
			'billing_first_name',
			'billing_last_name',
			'billing_company',
			'billing_address', // Multivendor
			'billing_address_1',
			'billing_address_2',
			'billing_city',
			'billing_state',
			'billing_country',
			'billing_postcode',
			'billing_phone',
			'billing_email'
		);
		$additional_billing_field = array();
		$billing_fields           = array_filter( get_option( 'wc_fields_billing', array() ) );
		foreach ( $billing_fields as $field_key => $field_info ) {
			if ( ! in_array( $field_key, $default_billing_fields ) && $field_info['enabled'] ) {
				array_push( $additional_billing_field, $field_key );
			}
		}

		return $additional_billing_field;
	}
}
