<?php
if ( ! function_exists( 'wabot_get_options' ) ) {
	/**
	 * @param $option
	 * @param $section
	 * @param array|string $default
	 *
	 * @return mixed
	 */
	function wabot_get_options( $option, $section, $default = '' ) {
		$options = get_option( $section );

		if ( isset( $options[ $option ] ) ) {
			return $options[ $option ];
		}

		return $default;
	}
}

if ( ! function_exists( 'wabot_add_actions' ) ) {
	/**
	 * @param array $hook_actions
	 */
	function wabot_add_actions( $hook_actions ) {
		foreach ( $hook_actions as $hook ) {
			add_action( $hook['hook'], $hook['function_to_be_called'] );
		}
	}
}

if ( ! function_exists( 'wabot_elementor_addon' ) ) {
	add_action( 'elementor_pro/init', 'wabot_elementor_addon' );
	function wabot_elementor_addon(){
		require( dirname(__FILE__).'/plugins/WabotElementor.php' );
		$whats_action = new Whatsapp_Action_After_Submit;
		\ElementorPro\Plugin::instance()->modules_manager->get_modules( 'forms' )->add_form_action( $whats_action->get_name(), $whats_action );
	}
}