<?php
class Wabot_WooCommerce_Frontend_Scripts implements Wabot_Register_Interface {
	public function register() {
		add_action( 'admin_enqueue_scripts', array( $this, 'wabot_admin_enqueue_scripts' ) );
        add_action( 'init', array($this, 'load_bootstrap'));
	}

	public function wabot_admin_enqueue_scripts() {
		wp_enqueue_style ( 'admin-wabot-icon', plugins_url( 'assets/css/wabot-icon.css', __DIR__));
	}

    public function load_bootstrap()
    {
        if ( isset($_GET['page']) ) {
            $page = sanitize_text_field($_GET['page']);
            global $pagenow;
            if ($pagenow === 'admin.php' && $this->str_contains($page, 'wabot-settings')) {
				wp_enqueue_style( 'admin-modal-css', plugins_url( 'assets/css/jquery.modal.min.css', __DIR__), array(), '0.9.1' );
                wp_enqueue_style ( 'admin-wabot-bootstrap', plugins_url( 'assets/css/bootstrap.min.css', __DIR__));
				wp_enqueue_style ( 'admin-wabot-style', plugins_url( 'assets/css/wabot.css', __DIR__));
				wp_enqueue_script( 'admin-modal-scripts', plugins_url( 'assets/js/jquery.modal.min.js', __DIR__ ), array( 'jquery' ), '0.9.1', true );
				wp_enqueue_script( 'admin-wabot-scripts', plugins_url( 'assets/js/admin.js', __DIR__ ), array( 'jquery' ), '1.0.0', true );
            }
        }
    }

    private function str_contains($haystack, $needle)
    {
        return $needle !== '' && mb_strpos($haystack, $needle) !== false;
    }
}
