let caretPosition = 0;
jQuery(function ($) {
	if($("#wabot_setting\\[wabot_woocommerce_access_token\\]").val() !== '' && $("#wabot_setting\\[wabot_woocommerce_instance_id\\]").val() !== '') {
		$('#wabot_setting form .form-table tbody > tr:nth-child(4)').show();
	} else {
		$('#wabot_setting form .form-table tbody > tr:nth-child(4)').hide();		
	}
	
    $("#wabot_admin_setting\\[wabot_woocommerce_admin_wa_recipients\\]").focusout(function () {
        var admin_mobile_no = $("#wabot_admin_setting\\[wabot_woocommerce_admin_wa_recipients\\]").val().trim();
        var admin_mobile_no_array = new Array();
        var counter;
        if (admin_mobile_no != '') {
            admin_mobile_no_array = admin_mobile_no.split(",");
            for (counter = 0; counter < admin_mobile_no_array.length; counter++) {
                admin_mobile_no_array[counter] = admin_mobile_no_array[counter].trim();
                if (!$.isNumeric(admin_mobile_no_array[counter])) {
                    alert('Invalid mobile number, input must be numeric.');
                    break;
                }
            }
        }
    });

    const setupPhoneHelper = function () {
        let selectedValue = $("#wabot_multivendor_setting\\[wabot_multivendor_selected_plugin\\]").val();
        let phoneFieldLocation = '[Edit Profile Page > Wabot WooCommerce > Phone]';
        if (selectedValue === 'dokan') {
            phoneFieldLocation = '[Vendor Dasboard > Settings > Store > Phone No]';
        } else if (selectedValue === 'wc_marketplace') {
            phoneFieldLocation = '[Vendor Dashboard > Store Settings > Storefront > Phone]';
        } else if (selectedValue === 'wcfm_marketplace') {
            phoneFieldLocation = '[Store Manager > Settings > Store > Store Phone';
        }

        let helperText = `<strong>Vendors are obligated to insert their WhatsApp number on <span style="color: #ff0000;">${phoneFieldLocation}</span> in order to receive notifications</strong>`;
        $("#multivendor_setting\\[multivendor_helper_desc\\]").html(helperText);
    };

    $("#wabot_multivendor_setting\\[wabot_multivendor_selected_plugin\\]").change(setupPhoneHelper);
    setupPhoneHelper();

    $('.modal').css("height", "auto");
    $('.modal').css("overflow-x", "unset");
    $('.modal').css("overflow-y", "unset");
    $('#wabot_wa\\[open-keywords\\]').click(function (e) {
        const type = $(e.target).attr('data-attr-type');
        const target = $(e.target).attr('data-attr-target');

        caretPosition = document.getElementById(target).selectionStart;
		
        let shopKeywords;
        if (type === 'multivendor') {
            shopKeywords = ['shop_name', 'shop_email', 'shop_url', 'vendor_shop_name'];
        } else {
            shopKeywords = ['shop_name', 'shop_email', 'shop_url'];
        }
        const orderKeywords = ['order_id', 'order_currency', 'order_amount', 'order_product_with_qty', 'order_product', 'order_status'];
        let billingKeywords = ['billing_first_name', 'billing_last_name', 'billing_phone', 'billing_email', 'billing_company', 'billing_address', 'billing_country', 'billing_city', 'billing_state', 'billing_postcode', 'payment_method'];

        if ($('#wabot_new_billing_field') && $('#wabot_new_billing_field').val() !== '') {
            let newFields = $('#wabot_new_billing_field').val().split(',');
            for (let i in newFields) {
                billingKeywords.push(newFields[i]);
            }
        }

        const buildTable = function (keywords) {
            const chunkedKeywords = keywords.array_chunk(3);

            let tableCode = '';
            chunkedKeywords.forEach(function (row, rowIndex) {
                if (rowIndex === 0) {
                    tableCode += '<table class="widefat fixed striped"><tbody>';
                }

                tableCode += '<tr>';
                row.forEach(function (col) {
                    tableCode += `<td class="column"><button class="button-link" onclick="wabot_bind_text_to_field('${target}', '[${col}]')">[${col}]</button></td>`;
                });
                tableCode += '</tr>';

                if (rowIndex === chunkedKeywords.length - 1) {
                    tableCode += '</tbody></table>';
                }
            });

            return tableCode;
        };

        $('#wabot_wa\\[keyword-modal\\]').off();
        $('#wabot_wa\\[keyword-modal\\]').on($.modal.AFTER_CLOSE, function () {
            document.getElementById(target).focus();
            document.getElementById(target).setSelectionRange(caretPosition, caretPosition);
        });

        let mainTable = '';
        mainTable += '<h2>Shop</h2>';
        mainTable += buildTable(shopKeywords);

        mainTable += '<h2>Order</h2>';
        mainTable += buildTable(orderKeywords);

        mainTable += '<h2>Billing</h2>';
        mainTable += buildTable(billingKeywords);

        mainTable += '<div style="margin-top: 10px"><small>Click on keyword to add the shortcode inside message template</small></div>';

        $('#wabot_wa\\[keyword-modal\\]').html(mainTable);
        $('#wabot_wa\\[keyword-modal\\]').modal();
    });

    $('#wabot_wa\\[open-keywords-low-stock-product\\]').click(function (e) {
        const type = $(e.target).attr('data-attr-type');
        const target = $(e.target).attr('data-attr-target');
		
        caretPosition = document.getElementById(target).selectionStart;
		
        let shopKeywords;
        if (type === 'multivendor') {
            shopKeywords = ['shop_name', 'shop_email', 'shop_url', 'vendor_shop_name'];
        } else {
            shopKeywords = ['shop_name', 'shop_email', 'shop_url'];
        }
        let productKeywords = ['product_id', 'product_name', 'produce_price', 'product_description', 'product_short_description', 'product_sale_price', 'product_stock_quantity' ];

        if ($('#wabot_new_billing_field') && $('#wabot_new_billing_field').val() !== '') {
            let newFields = $('#wabot_new_billing_field').val().split(',');
            for (let i in newFields) {
                billingKeywords.push(newFields[i]);
            }
        }

        const buildTable = function (keywords) {
            const chunkedKeywords = keywords.array_chunk(3);

            let tableCode = '';
            chunkedKeywords.forEach(function (row, rowIndex) {
                if (rowIndex === 0) {
                    tableCode += '<table class="widefat fixed striped"><tbody>';
                }

                tableCode += '<tr>';
                row.forEach(function (col) {
                    tableCode += `<td class="column"><button class="button-link" onclick="wabot_bind_text_to_field('${target}', '[${col}]')">[${col}]</button></td>`;
                });
                tableCode += '</tr>';

                if (rowIndex === chunkedKeywords.length - 1) {
                    tableCode += '</tbody></table>';
                }
            });

            return tableCode;
        };

        $('#wabot_wa\\[keyword-modal\\]').off();
        $('#wabot_wa\\[keyword-modal\\]').on($.modal.AFTER_CLOSE, function () {
            document.getElementById(target).focus();
            document.getElementById(target).setSelectionRange(caretPosition, caretPosition);
        });

        let mainTable = '';
        mainTable += '<h2>Shop</h2>';
        mainTable += buildTable(shopKeywords);

        mainTable += '<h2>Product</h2>';
        mainTable += buildTable(productKeywords);

        mainTable += '<div style="margin-top: 10px"><small>Click on keyword to add the shortcode inside message template</small></div>';

        $('#wabot_wa\\[keyword-modal\\]').html(mainTable);
        $('#wabot_wa\\[keyword-modal\\]').modal();
    });
	
	let token = $('#wabot_setting\\[wabot_woocommerce_access_token\\]').val();
	let instance = $('#wabot_setting\\[wabot_woocommerce_instance_id\\]').val();
	
    $('.ins-action').click(function (e) {
        let $this = $(this);
        let actionData = $(this).data('action');        
        let controlPopup = '';
        if(actionData == 'status') {
            controlPopup += '<h2>Connection Status</h2>';
            controlPopup += '<div class="ins-results"><div class="loader"></div></div>';
            $.ajax({
                url: 'https://app.wabot.my/api/check_instance?instance_id=' + instance + '&access_token=' + token,
                dataType: 'json',
                timeout: 3000, // sets timeout to 1 second
                success: function(data) {
                    let deviceStatus = '';
                    console.log(data);
                    if(data.data.id) {
                        deviceStatus = 'Connected';
                    } else {
                        deviceStatus = 'Disconnected';
                    }
                    $('#wabot_wa\\[keyword-modal\\]').find('.ins-results').html('<div class="response">Phone ' + deviceStatus + '</div>');
                },
                error: function() {
                    // This function will be executed if the request fails, or if it times out
                    $('#wabot_wa\\[keyword-modal\\]').find('.ins-results').html('<div class="response">Phone Disconnected</div>');
                }
            });         
        }
        $('#wabot_wa\\[keyword-modal\\]').html('<div class="controlPopup">' + controlPopup + '</div>');
        $('#wabot_wa\\[keyword-modal\\]').modal();
    });
	$('#wabot_wa\\[keyword-modal\\]').on("click", '#ins-btn', function(e) {
		let $this = $(this);
		$this.parent().hide();
		$this.parents('.modal').find('.ins-results').html('<div class="loader"></div>');
    });
	$('#wabot_wa\\[keyword-modal\\]').on("click", '.response', function(e) {
		$.modal.close();
    });
});

function wabot_bind_text_to_field(target, keyword) {
    const startStr = document.getElementById(target).value.substring(0, caretPosition);
    const endStr = document.getElementById(target).value.substring(caretPosition);
    document.getElementById(target).value = startStr + keyword + endStr;
    caretPosition += keyword.length;
	jQuery.modal.close();
}

function resetSettings(formId) {
    if (confirm('Are you sure you want to reset the settings?')) {
        const form = document.getElementById(formId);
        const inputFields = form.querySelectorAll('input:not([type="submit"]):not([type="button"]), select, textarea');

        inputFields.forEach(function (field) {
            if (field.type === 'checkbox' || field.type === 'radio') {
                field.checked = false;
            } else {
                field.value = '';
            }
        });
    }
}

Object.defineProperty(Array.prototype, 'array_chunk', {
    value: function (chunkSize) {
        const array = this;
        return [].concat.apply([],
            array.map(function (elem, i) {
                return i % chunkSize ? [] : [array.slice(i, i + chunkSize)];
            })
        );
    }
});
