<?php
class Whatsapp_Action_After_Submit extends \ElementorPro\Modules\Forms\Classes\Action_Base {	
    
	public function get_name() {
		return 'wabot';
	}
	public function get_label() {
		return __( 'Wabot', WABOT_TXT_DOMAIN );
	}
	public function register_settings_section( $widget ) {
		$widget->start_controls_section(
			'section_whatsapp-redirect',
			[
				'label' => __( 'Wabot', WABOT_TXT_DOMAIN ),
				'condition' => [
					'submit_actions' => $this->get_name(),
				],
			]
		);
		$widget->add_control(
			'whatsapp_to',
			[
				'label' => __( 'WhatsApp Phone', WABOT_TXT_DOMAIN ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( '60123456789', WABOT_TXT_DOMAIN ),
				'label_block' => true,
				'render_type' => 'none',
				'classes' => 'elementor-control-whats-phone-direction-ltr',
				'description' => __( 'Type WhatsApp Number with country code (e.g: 601XXXXXXXX) or use number field shortcode.', WABOT_TXT_DOMAIN ),
			]
		);
		$widget->add_control(
			'whatsapp_message',
			[
				'label' => __( 'WhatsApp Message', WABOT_TXT_DOMAIN ),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __( 'Type your own text or use available fields shortcode.', WABOT_TXT_DOMAIN ),
				'label_block' => true,
				'render_type' => 'none',
				'classes' => 'elementor-control-whats-direction-ltr',
				'description' => __( 'Insert your own message with available fields shortcode.', WABOT_TXT_DOMAIN ),
			]
		);
		$widget->add_control(
			'whatsapp_img',
			[
				'label' => __( 'Image / File URL (Optional)', WABOT_TXT_DOMAIN ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __( 'jpeg,png,gif,webp,mp4,3gpp,mpeg,aac,pdf,doc,xls', WABOT_TXT_DOMAIN ),
				'label_block' => true,
				'render_type' => 'none',
				'classes' => 'elementor-control-whats-direction-ltr',
				'description' => __( 'Insert image link or file url to send message with attachment.', WABOT_TXT_DOMAIN ),
			]
		);
		$widget->end_controls_section();
	}
	public function on_export( $element ) {
		unset(
			$element['settings']['whatsapp_to'],
			$element['settings']['whatsapp_message'],
			$element['settings']['whatsapp_img']
		);
		return $element;
	}
	public function run( $record, $ajax_handler ) {
		$whatsapp_to = $record->get_form_settings( 'whatsapp_to' );
		$whatsapp_to = $record->replace_setting_shortcodes( $whatsapp_to, true );
		$whatsapp_message = $record->get_form_settings( 'whatsapp_message' );
		$whatsapp_message = urldecode($record->replace_setting_shortcodes( $whatsapp_message, true ));
		$whatsapp_img = $record->get_form_settings( 'whatsapp_img' );
		$whatsapp_img = $record->replace_setting_shortcodes( $whatsapp_img, true );
		$country = wabot_get_options( 'wabot_woocommerce_country_code', 'wabot_setting', '' );
		if( !empty($country) ) {
			$whatsapp_to = Wabot_SendWA_Msg::get_formatted_number($whatsapp_to, $country);
		}
		if(!empty($whatsapp_img)) {
			$type = 'media';
		} else {
			$type = 'text';				
		}
		if ( ! empty( $whatsapp_message ) ) {
			Wabot_SendWA_Msg::send_wa($type, $whatsapp_to, $whatsapp_message, $whatsapp_img);
		}
	}
}
?>