<?php
/*
 * Integration with Wabot RESTful API
 */

class Wabot {

    // Account credentials
    private $instance_id = '';
    private $access_token = '';

    // REST API URL
    public $rest_base_url = 'https://app.wabot.my/api';

    private $rest_commands = array (
            'send_text' => array('url' => '/send'),
            'send_group' => array('url' => '/send_group'),
            'check_instance' => array('url' => '/check_instance'),
    );

    public function __construct($instance_id = null, $access_token = null)
    {
        $this->instance_id = $instance_id;
        $this->access_token = $access_token;
    }

    function sendWA($type,$number,$message,$media_url)
    {
        $logger = new Wabot_WooCoommerce_Logger();
        $logger->add("Wabot", "(2) Message Sent to {$number}.");
        // Send request to Wabot gateway
        $params = array(
                'type' => $type,
                'number' => $number,
                'message' => $message,
                'media_url' => $media_url
        );
		$filename = '';
		if($media_url !== '') {
			$imgExts = array("gif", "jpg", "jpeg", "png");
			$urlExt = pathinfo($media_url, PATHINFO_EXTENSION);
			if (!in_array($urlExt, $imgExts)) {
				$path_parts = pathinfo($media_url);
				$filename = $path_parts['filename'];
				$params['filename'] = $filename;
			}			
		}
        return $this->invokeApi ('send_text', $params);
    }

    private function invokeApi($command, $params = array()) {
        // Get REST URL and HTTP method
        $command_info = $this->rest_commands[$command];
        $url = $this->rest_base_url . $command_info['url'];
    
        // Build the JSON payload
        $params = array_merge($params, array('access_token' => $this->access_token, 'instance_id' => $this->instance_id));
        $json_payload = json_encode($params);
    
        // Set up the request arguments
        $args = array(
            'method' => 'POST',
            'timeout' => 60,
            'sslverify' => false,
            'headers' => array(
                'Content-Type' => 'application/json',
            ),
            'body' => $json_payload,
        );
    
        // Send the request
        $response = wp_remote_post($url, $args);
    
        // Check for errors
        if (is_wp_error($response)) {
            // Handle the error
            // You can log the error or return an appropriate response
            return false;
        }
    
        // Get the response body
        $rest_response = wp_remote_retrieve_body($response);
    
        return $rest_response;
    }
}
?>
