<?php

class Wabot_Help_View implements Wabot_Register_Interface {

	private $settings_api;

	function __construct() {
		$this->settings_api = new WeDevs_Settings_API;
	}

	public function register() {
        add_filter( 'wabot_setting_section',     array($this, 'set_help_setting_section' ) );
		add_filter( 'wabot_setting_fields',      array($this, 'set_help_setting_field' ) );
        add_action( 'wabot_setting_fields_custom_html', array($this, 'display_help_page'), 10, 1);
	}

	public function set_help_setting_section( $sections ) {
		$sections[] = array(
            'id'               => 'wabot_help_setting',
            'title'            => __( 'Help', WABOT_TXT_DOMAIN ),
            'submit_button'    => '',
		);

		return $sections;
	}

	/**
	 * Returns all the settings fields
	 *
	 * @return array settings fields
	 */
	public function set_help_setting_field( $setting_fields ) {
		return $setting_fields;
	}

    public function display_help_page($form_id) {
        if($form_id !== 'wabot_help_setting') { return; }
    ?>
	<div class="bootstrap-wrapper">	
		<div class="help-wrapper">
			<h4>Notification not working or instructions not clear?</h4>
			<p>You can contact our customer support team <a href="https://m.me/wabot.my/" target="_blank">via Messenger</a> or <a href="https://wa.me/60125153307/" target="_blank">WhatsApp</a>.</p>
		</div>	
	</div>	
    <?php
    }
}
?>
