<?php

class Wabot_Logs_View implements Wabot_Register_Interface {

	private $settings_api;

	function __construct() {
		$this->settings_api = new WeDevs_Settings_API;
	}

	public function register() {
        add_filter( 'wabot_setting_section', array($this, 'set_logs_setting_section' ) );
		add_filter( 'wabot_setting_fields',  array($this, 'set_logs_setting_field' ) );
		add_action( 'wabot_setting_fields_custom_html', array($this, 'display_logs_page'), 10, 1);

		// Check if the clear logs button was clicked
		if (isset($_POST['clear_logs'])) {
			$logger = new Wabot_WooCoommerce_Logger();
			$logger->clear_log_file("Wabot");
		}
	}

	public function set_logs_setting_section( $sections ) {
		$sections[] = array(
            'id'               => 'wabot_logs_setting',
            'title'            => __( 'Message Logs', WABOT_TXT_DOMAIN ),
            'submit_button'    => '',
		);

		return $sections;
	}

	/**
	 * Returns all the settings fields
	 *
	 * @return array settings fields
	 */
	public function set_logs_setting_field( $setting_fields ) {

		return $setting_fields;
	}

    
public function display_logs_page($form_id) {
    if($form_id !== 'wabot_logs_setting') { return; }
    $logger = new Wabot_WooCoommerce_Logger();
    $customer_logs = $logger->get_log_file("Wabot");
?>
    <div class="bootstrap-wrapper">
        <div id="logs-wrapper">
            <pre><strong><?php echo esc_attr($customer_logs); ?></strong></pre>
        </div>
        <form method="post">
            <input type="hidden" name="clear_logs" value="1">
            <input type="submit" class="button button-secondary" value="Clear Log">
        </form>
    </div>

<?php
	
}


}

?>
