<?php

class Wabot_SendWA_View implements Wabot_Register_Interface {

	private $settings_api;
    private $log;

	function __construct() {
        $this->log = new Wabot_WooCoommerce_Logger();
		$this->settings_api = new WeDevs_Settings_API;
	}

	public function register() {
        add_filter( 'wabot_setting_section',     array($this, 'set_sendwa_setting_section' ) );
		add_filter( 'wabot_setting_fields',      array($this, 'set_sendwa_setting_field' ) );
		add_action( 'admin_post_wabot_wa_form', array($this, 'sw_send_wa' ) );
        add_action( 'admin_notices',                 array($this, 'display_send_wa_success') );
        add_filter( 'removable_query_args',          array($this, 'add_removable_arg') );
	}

    public function sw_send_wa() {
        $message='';$recipients='';$file='';
        if(isset($_POST['wabot_sendwa_setting']['wabot_sendwa_message']))
            $message = sanitize_textarea_field($_POST['wabot_sendwa_setting']['wabot_sendwa_message']);
        if(isset($_POST['wabot_sendwa_setting']['wabot_sendwa_recipients']))
            $recipients = sanitize_text_field($_POST['wabot_sendwa_setting']['wabot_sendwa_recipients']);
        if(isset($_POST['wabot_sendwa_setting']['wabot_sendwa_file']))
            $file = sanitize_text_field($_POST['wabot_sendwa_setting']['wabot_sendwa_file']);
		if($file !== '') {
			$type = 'media';
		} else {
			$type = 'text';
		}
		$send_wa = Wabot_SendWA_Msg::send_wa($type, $recipients, $message, $file);
        wp_redirect(admin_url('admin.php?page=wabot-settings&wa_sent='.$send_wa));
		exit;
    }

	public function set_sendwa_setting_section( $sections ) {
		$sections[] = array(
            'id'               => 'wabot_sendwa_setting',
            'title'            => __( 'Send WhatsApp', WABOT_TXT_DOMAIN ),
            'submit_button'    => get_submit_button('Send Message', 'primary large', 'sendMessage', true ,array('id' => 'sendMessage')),
            'action'           => 'wabot_wa_form',
            'action_url'       => admin_url('admin-post.php'),
		);

		return $sections;
	}

	/**
	 * Returns all the settings fields
	 *
	 * @return array settings fields
	 */
	public function set_sendwa_setting_field( $setting_fields ) {

        $users = get_users();
        $filtered_user = array();

        foreach($users as $user) {
            $filtered_user[$user->ID] = $user->user_login;
        }

		$setting_fields['wabot_sendwa_setting'] = array(
			array(
				'name'    => 'wabot_sendwa_recipients',
				'label'   => __( 'Recipient', WABOT_TXT_DOMAIN ),
				'desc'    => 'Insert country code along with WhatsApp number. E.g. 60123456789',
				'type'    => 'text',
			),
			array(
				'name'    => 'wabot_sendwa_message',
				'label'   => __( 'Message', WABOT_TXT_DOMAIN ),
				'desc'    => 'Insert your message here. Custom ascii symbols and emojis are supported.',
				'type'    => 'textarea',
				'rows'    => '8',
				'cols'    => '500',
				'css'     => 'min-width:350px;',
            ),
			array(
				'name'    => 'wabot_sendwa_file',
				'label'   => __( 'Image / File URL', WABOT_TXT_DOMAIN ),
				'desc'    => 'Insert image link or file url to send message with attachment.<br>Supported format are jpeg, png, webp, mp4, 3gpp, mpeg, aac, pdf, doc, xls.',
				'type'    => 'file',
			),
		);
		return $setting_fields;
	}
	
    public function display_send_wa_success()
    {
        if( !isset($_GET['wa_sent']) ) { return; }
        ?>
        <div class="notice notice-success is-dismissible">
            <p><?php _e( 'Message sending command executed!', WABOT_TXT_DOMAIN ); ?></p>
        </div>
        <?php
    }

    public function add_removable_arg($args)
    {
        array_push($args, 'wa_sent');
        return $args;
    }

}

?>
