<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class Wabot_SendWA_Msg {

	public static function send_wa($type, $number, $message, $media_url) {
	    $log = new Wabot_WooCoommerce_Logger();
	    $instance_id = wabot_get_options('wabot_woocommerce_instance_id', 'wabot_setting');
	    $access_token = wabot_get_options('wabot_woocommerce_access_token', 'wabot_setting');
		$admin_country = wabot_get_options('wabot_woocommerce_country_code', 'wabot_setting', '' );

	    if($instance_id == '' || $access_token == '') return;
		
		$wa_number = self::get_formatted_number($number, $admin_country);

	    $log->add('Wabot', '(1) Sending message to number '.$number.' with content: '.$message);

	    try {
	        $wabot_rest = new Wabot($instance_id, $access_token);
	        $rest_response = $wabot_rest->sendWA($type, $wa_number, $message, $media_url);
	        $log->add('Wabot', '(3) API Response: ' .$rest_response);
	  		return 'true';
	    } catch (Exception $e) {
	        $log->add('Wabot', 'Failed sending message: ' . $e->getMessage());
	    }
	}
	
	public static function get_formatted_number($phone, $country) {
        $log = new Wabot_WooCoommerce_Logger();
        $base_api_url = 'https://validate.sentwa.com/';
        $settings_country = !empty(wabot_get_options('wabot_woocommerce_country_code', 'wabot_setting', '' )) ? wabot_get_options('wabot_woocommerce_country_code', 'wabot_setting', '' ) : "ID";
        $args = array(
            'body' => array(
                'phone' => $phone,
                'country' => !empty($country) ? strtoupper($country) : strtoupper($settings_country),
            )
        );
        $response = wp_remote_retrieve_body(wp_remote_get($base_api_url, $args));

        if (!empty($response)) {
            $phone = $response;
            return $phone;
        }
        $status = sprintf('Invalid Number Format: %s', $phone);
        return false;
    }

}