<?php

class BWFAN_WC_Order_Payment_Url extends BWFAN_Merge_Tag {

	private static $instance = null;


	public function __construct() {
		$this->tag_name        = 'order_payment_url';
		$this->tag_description = __( 'Order Payment URL', 'wp-marketing-automations' );
		add_shortcode( 'bwfan_order_payment_url', array( $this, 'parse_shortcode' ) );
		$this->support_fallback = false;
		$this->priority = 5;
	}

	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Parse the merge tag and return its value.
	 *
	 * @param $attr
	 *
	 * @return mixed|string|void
	 */
	public function parse_shortcode( $attr ) {
		if ( true === BWFAN_Merge_Tag_Loader::get_data( 'is_preview' ) ) {
			return $this->get_dummy_preview();
		}

		$order_id = BWFAN_Merge_Tag_Loader::get_data( 'order_id' );
		$order 	= wc_get_order( $order_id );

		if ( ! $order instanceof WC_Order ) {
			return $this->parse_shortcode_output( '', $attr );
		}

		$order_payment_url = $order->get_checkout_payment_url();

		return $this->parse_shortcode_output( $order_payment_url, $attr );
	}

	/**
	 * Show dummy value of the current merge tag.
	 *
	 * @return string
	 */
	public function get_dummy_preview() {
		$pay_url = wc_get_endpoint_url( 'order-pay', 1, wc_get_page_permalink( 'checkout' ) );
		if ( 'yes' === get_option( 'woocommerce_force_ssl_checkout' ) || is_ssl() ) {
			$pay_url = str_replace( 'http:', 'https:', $pay_url );
		}
		$pay_url = add_query_arg( array(
			'pay_for_order' => 'true',
			'key'           => 'wc_65566834',
		), $pay_url );

		return $pay_url;
	}


}

/**
 * Register this merge tag to a group.
 */
if ( bwfan_is_woocommerce_active() ) {
	BWFAN_Merge_Tag_Loader::register( 'wc_order', 'BWFAN_WC_Order_Payment_Url', null, 'Order' );
}