<?php
/**
 * States
 *
 * Returns an array of country states. This deprecates and replaces the /states/ directory found in older versions.
 * States should be defined in English and translated native through localisation files.
 * Country codes and states (or province) names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/country-names).
 * Countries defined with empty arrays have no states.
 *
 *
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AO' => array( // Angola states.
		'BGO' => __( 'Bengo', 'woofunnels' ),
		'BLU' => __( 'Benguela', 'woofunnels' ),
		'BIE' => __( 'Bié', 'woofunnels' ),
		'CAB' => __( 'Cabinda', 'woofunnels' ),
		'CNN' => __( 'Cunene', 'woofunnels' ),
		'HUA' => __( 'Huambo', 'woofunnels' ),
		'HUI' => __( 'Huíla', 'woofunnels' ),
		'CCU' => __( 'Kuando Kubango', 'woofunnels' ),
		'CNO' => __( 'Kwanza-Norte', 'woofunnels' ),
		'CUS' => __( 'Kwanza-Sul', 'woofunnels' ),
		'LUA' => __( 'Luanda', 'woofunnels' ),
		'LNO' => __( 'Lunda-Norte', 'woofunnels' ),
		'LSU' => __( 'Lunda-Sul', 'woofunnels' ),
		'MAL' => __( 'Malanje', 'woofunnels' ),
		'MOX' => __( 'Moxico', 'woofunnels' ),
		'NAM' => __( 'Namibe', 'woofunnels' ),
		'UIG' => __( 'Uíge', 'woofunnels' ),
		'ZAI' => __( 'Zaire', 'woofunnels' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'woofunnels' ),
		'B' => __( 'Buenos Aires', 'woofunnels' ),
		'K' => __( 'Catamarca', 'woofunnels' ),
		'H' => __( 'Chaco', 'woofunnels' ),
		'U' => __( 'Chubut', 'woofunnels' ),
		'X' => __( 'Córdoba', 'woofunnels' ),
		'W' => __( 'Corrientes', 'woofunnels' ),
		'E' => __( 'Entre Ríos', 'woofunnels' ),
		'P' => __( 'Formosa', 'woofunnels' ),
		'Y' => __( 'Jujuy', 'woofunnels' ),
		'L' => __( 'La Pampa', 'woofunnels' ),
		'F' => __( 'La Rioja', 'woofunnels' ),
		'M' => __( 'Mendoza', 'woofunnels' ),
		'N' => __( 'Misiones', 'woofunnels' ),
		'Q' => __( 'Neuquén', 'woofunnels' ),
		'R' => __( 'Río Negro', 'woofunnels' ),
		'A' => __( 'Salta', 'woofunnels' ),
		'J' => __( 'San Juan', 'woofunnels' ),
		'D' => __( 'San Luis', 'woofunnels' ),
		'Z' => __( 'Santa Cruz', 'woofunnels' ),
		'S' => __( 'Santa Fe', 'woofunnels' ),
		'G' => __( 'Santiago del Estero', 'woofunnels' ),
		'V' => __( 'Tierra del Fuego', 'woofunnels' ),
		'T' => __( 'Tucumán', 'woofunnels' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'woofunnels' ),
		'NSW' => __( 'New South Wales', 'woofunnels' ),
		'NT'  => __( 'Northern Territory', 'woofunnels' ),
		'QLD' => __( 'Queensland', 'woofunnels' ),
		'SA'  => __( 'South Australia', 'woofunnels' ),
		'TAS' => __( 'Tasmania', 'woofunnels' ),
		'VIC' => __( 'Victoria', 'woofunnels' ),
		'WA'  => __( 'Western Australia', 'woofunnels' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi states (districts).
		'BD-05' => __( 'Bagerhat', 'woofunnels' ),
		'BD-01' => __( 'Bandarban', 'woofunnels' ),
		'BD-02' => __( 'Barguna', 'woofunnels' ),
		'BD-06' => __( 'Barishal', 'woofunnels' ),
		'BD-07' => __( 'Bhola', 'woofunnels' ),
		'BD-03' => __( 'Bogura', 'woofunnels' ),
		'BD-04' => __( 'Brahmanbaria', 'woofunnels' ),
		'BD-09' => __( 'Chandpur', 'woofunnels' ),
		'BD-10' => __( 'Chattogram', 'woofunnels' ),
		'BD-12' => __( 'Chuadanga', 'woofunnels' ),
		'BD-11' => __( "Cox's Bazar", 'woofunnels' ),
		'BD-08' => __( 'Cumilla', 'woofunnels' ),
		'BD-13' => __( 'Dhaka', 'woofunnels' ),
		'BD-14' => __( 'Dinajpur', 'woofunnels' ),
		'BD-15' => __( 'Faridpur ', 'woofunnels' ),
		'BD-16' => __( 'Feni', 'woofunnels' ),
		'BD-19' => __( 'Gaibandha', 'woofunnels' ),
		'BD-18' => __( 'Gazipur', 'woofunnels' ),
		'BD-17' => __( 'Gopalganj', 'woofunnels' ),
		'BD-20' => __( 'Habiganj', 'woofunnels' ),
		'BD-21' => __( 'Jamalpur', 'woofunnels' ),
		'BD-22' => __( 'Jashore', 'woofunnels' ),
		'BD-25' => __( 'Jhalokati', 'woofunnels' ),
		'BD-23' => __( 'Jhenaidah', 'woofunnels' ),
		'BD-24' => __( 'Joypurhat', 'woofunnels' ),
		'BD-29' => __( 'Khagrachhari', 'woofunnels' ),
		'BD-27' => __( 'Khulna', 'woofunnels' ),
		'BD-26' => __( 'Kishoreganj', 'woofunnels' ),
		'BD-28' => __( 'Kurigram', 'woofunnels' ),
		'BD-30' => __( 'Kushtia', 'woofunnels' ),
		'BD-31' => __( 'Lakshmipur', 'woofunnels' ),
		'BD-32' => __( 'Lalmonirhat', 'woofunnels' ),
		'BD-36' => __( 'Madaripur', 'woofunnels' ),
		'BD-37' => __( 'Magura', 'woofunnels' ),
		'BD-33' => __( 'Manikganj ', 'woofunnels' ),
		'BD-39' => __( 'Meherpur', 'woofunnels' ),
		'BD-38' => __( 'Moulvibazar', 'woofunnels' ),
		'BD-35' => __( 'Munshiganj', 'woofunnels' ),
		'BD-34' => __( 'Mymensingh', 'woofunnels' ),
		'BD-48' => __( 'Naogaon', 'woofunnels' ),
		'BD-43' => __( 'Narail', 'woofunnels' ),
		'BD-40' => __( 'Narayanganj', 'woofunnels' ),
		'BD-42' => __( 'Narsingdi', 'woofunnels' ),
		'BD-44' => __( 'Natore', 'woofunnels' ),
		'BD-45' => __( 'Nawabganj', 'woofunnels' ),
		'BD-41' => __( 'Netrakona', 'woofunnels' ),
		'BD-46' => __( 'Nilphamari', 'woofunnels' ),
		'BD-47' => __( 'Noakhali', 'woofunnels' ),
		'BD-49' => __( 'Pabna', 'woofunnels' ),
		'BD-52' => __( 'Panchagarh', 'woofunnels' ),
		'BD-51' => __( 'Patuakhali', 'woofunnels' ),
		'BD-50' => __( 'Pirojpur', 'woofunnels' ),
		'BD-53' => __( 'Rajbari', 'woofunnels' ),
		'BD-54' => __( 'Rajshahi', 'woofunnels' ),
		'BD-56' => __( 'Rangamati', 'woofunnels' ),
		'BD-55' => __( 'Rangpur', 'woofunnels' ),
		'BD-58' => __( 'Satkhira', 'woofunnels' ),
		'BD-62' => __( 'Shariatpur', 'woofunnels' ),
		'BD-57' => __( 'Sherpur', 'woofunnels' ),
		'BD-59' => __( 'Sirajganj', 'woofunnels' ),
		'BD-61' => __( 'Sunamganj', 'woofunnels' ),
		'BD-60' => __( 'Sylhet', 'woofunnels' ),
		'BD-63' => __( 'Tangail', 'woofunnels' ),
		'BD-64' => __( 'Thakurgaon', 'woofunnels' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'woofunnels' ),
		'BG-02' => __( 'Burgas', 'woofunnels' ),
		'BG-08' => __( 'Dobrich', 'woofunnels' ),
		'BG-07' => __( 'Gabrovo', 'woofunnels' ),
		'BG-26' => __( 'Haskovo', 'woofunnels' ),
		'BG-09' => __( 'Kardzhali', 'woofunnels' ),
		'BG-10' => __( 'Kyustendil', 'woofunnels' ),
		'BG-11' => __( 'Lovech', 'woofunnels' ),
		'BG-12' => __( 'Montana', 'woofunnels' ),
		'BG-13' => __( 'Pazardzhik', 'woofunnels' ),
		'BG-14' => __( 'Pernik', 'woofunnels' ),
		'BG-15' => __( 'Pleven', 'woofunnels' ),
		'BG-16' => __( 'Plovdiv', 'woofunnels' ),
		'BG-17' => __( 'Razgrad', 'woofunnels' ),
		'BG-18' => __( 'Ruse', 'woofunnels' ),
		'BG-27' => __( 'Shumen', 'woofunnels' ),
		'BG-19' => __( 'Silistra', 'woofunnels' ),
		'BG-20' => __( 'Sliven', 'woofunnels' ),
		'BG-21' => __( 'Smolyan', 'woofunnels' ),
		'BG-23' => __( 'Sofia', 'woofunnels' ),
		'BG-22' => __( 'Sofia-Grad', 'woofunnels' ),
		'BG-24' => __( 'Stara Zagora', 'woofunnels' ),
		'BG-25' => __( 'Targovishte', 'woofunnels' ),
		'BG-03' => __( 'Varna', 'woofunnels' ),
		'BG-04' => __( 'Veliko Tarnovo', 'woofunnels' ),
		'BG-05' => __( 'Vidin', 'woofunnels' ),
		'BG-06' => __( 'Vratsa', 'woofunnels' ),
		'BG-28' => __( 'Yambol', 'woofunnels' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Benin states.
		'AL' => __( 'Alibori', 'woofunnels' ),
		'AK' => __( 'Atakora', 'woofunnels' ),
		'AQ' => __( 'Atlantique', 'woofunnels' ),
		'BO' => __( 'Borgou', 'woofunnels' ),
		'CO' => __( 'Collines', 'woofunnels' ),
		'KO' => __( 'Kouffo', 'woofunnels' ),
		'DO' => __( 'Donga', 'woofunnels' ),
		'LI' => __( 'Littoral', 'woofunnels' ),
		'MO' => __( 'Mono', 'woofunnels' ),
		'OU' => __( 'Ouémé', 'woofunnels' ),
		'PL' => __( 'Plateau', 'woofunnels' ),
		'ZO' => __( 'Zou', 'woofunnels' ),
	),
	'BO' => array( // Bolivian states.
		'B' => __( 'Chuquisaca', 'woofunnels' ),
		'H' => __( 'Beni', 'woofunnels' ),
		'C' => __( 'Cochabamba', 'woofunnels' ),
		'L' => __( 'La Paz', 'woofunnels' ),
		'O' => __( 'Oruro', 'woofunnels' ),
		'N' => __( 'Pando', 'woofunnels' ),
		'P' => __( 'Potosí', 'woofunnels' ),
		'S' => __( 'Santa Cruz', 'woofunnels' ),
		'T' => __( 'Tarija', 'woofunnels' ),
	),
	'BR' => array( // Brazillian states.
		'AC' => __( 'Acre', 'woofunnels' ),
		'AL' => __( 'Alagoas', 'woofunnels' ),
		'AP' => __( 'Amapá', 'woofunnels' ),
		'AM' => __( 'Amazonas', 'woofunnels' ),
		'BA' => __( 'Bahia', 'woofunnels' ),
		'CE' => __( 'Ceará', 'woofunnels' ),
		'DF' => __( 'Distrito Federal', 'woofunnels' ),
		'ES' => __( 'Espírito Santo', 'woofunnels' ),
		'GO' => __( 'Goiás', 'woofunnels' ),
		'MA' => __( 'Maranhão', 'woofunnels' ),
		'MT' => __( 'Mato Grosso', 'woofunnels' ),
		'MS' => __( 'Mato Grosso do Sul', 'woofunnels' ),
		'MG' => __( 'Minas Gerais', 'woofunnels' ),
		'PA' => __( 'Pará', 'woofunnels' ),
		'PB' => __( 'Paraíba', 'woofunnels' ),
		'PR' => __( 'Paraná', 'woofunnels' ),
		'PE' => __( 'Pernambuco', 'woofunnels' ),
		'PI' => __( 'Piauí', 'woofunnels' ),
		'RJ' => __( 'Rio de Janeiro', 'woofunnels' ),
		'RN' => __( 'Rio Grande do Norte', 'woofunnels' ),
		'RS' => __( 'Rio Grande do Sul', 'woofunnels' ),
		'RO' => __( 'Rondônia', 'woofunnels' ),
		'RR' => __( 'Roraima', 'woofunnels' ),
		'SC' => __( 'Santa Catarina', 'woofunnels' ),
		'SP' => __( 'São Paulo', 'woofunnels' ),
		'SE' => __( 'Sergipe', 'woofunnels' ),
		'TO' => __( 'Tocantins', 'woofunnels' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'woofunnels' ),
		'BC' => __( 'British Columbia', 'woofunnels' ),
		'MB' => __( 'Manitoba', 'woofunnels' ),
		'NB' => __( 'New Brunswick', 'woofunnels' ),
		'NL' => __( 'Newfoundland and Labrador', 'woofunnels' ),
		'NT' => __( 'Northwest Territories', 'woofunnels' ),
		'NS' => __( 'Nova Scotia', 'woofunnels' ),
		'NU' => __( 'Nunavut', 'woofunnels' ),
		'ON' => __( 'Ontario', 'woofunnels' ),
		'PE' => __( 'Prince Edward Island', 'woofunnels' ),
		'QC' => __( 'Quebec', 'woofunnels' ),
		'SK' => __( 'Saskatchewan', 'woofunnels' ),
		'YT' => __( 'Yukon Territory', 'woofunnels' ),
	),
	'CH' => array( // Cantons of Switzerland.
		'AG' => __( 'Aargau', 'woofunnels' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'woofunnels' ),
		'AI' => __( 'Appenzell Innerrhoden', 'woofunnels' ),
		'BL' => __( 'Basel-Landschaft', 'woofunnels' ),
		'BS' => __( 'Basel-Stadt', 'woofunnels' ),
		'BE' => __( 'Bern', 'woofunnels' ),
		'FR' => __( 'Fribourg', 'woofunnels' ),
		'GE' => __( 'Geneva', 'woofunnels' ),
		'GL' => __( 'Glarus', 'woofunnels' ),
		'GR' => __( 'Graubünden', 'woofunnels' ),
		'JU' => __( 'Jura', 'woofunnels' ),
		'LU' => __( 'Luzern', 'woofunnels' ),
		'NE' => __( 'Neuchâtel', 'woofunnels' ),
		'NW' => __( 'Nidwalden', 'woofunnels' ),
		'OW' => __( 'Obwalden', 'woofunnels' ),
		'SH' => __( 'Schaffhausen', 'woofunnels' ),
		'SZ' => __( 'Schwyz', 'woofunnels' ),
		'SO' => __( 'Solothurn', 'woofunnels' ),
		'SG' => __( 'St. Gallen', 'woofunnels' ),
		'TG' => __( 'Thurgau', 'woofunnels' ),
		'TI' => __( 'Ticino', 'woofunnels' ),
		'UR' => __( 'Uri', 'woofunnels' ),
		'VS' => __( 'Valais', 'woofunnels' ),
		'VD' => __( 'Vaud', 'woofunnels' ),
		'ZG' => __( 'Zug', 'woofunnels' ),
		'ZH' => __( 'Zürich', 'woofunnels' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'woofunnels' ),
		'CN2'  => __( 'Beijing / 北京', 'woofunnels' ),
		'CN3'  => __( 'Tianjin / 天津', 'woofunnels' ),
		'CN4'  => __( 'Hebei / 河北', 'woofunnels' ),
		'CN5'  => __( 'Shanxi / 山西', 'woofunnels' ),
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'woofunnels' ),
		'CN7'  => __( 'Liaoning / 辽宁', 'woofunnels' ),
		'CN8'  => __( 'Jilin / 吉林', 'woofunnels' ),
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'woofunnels' ),
		'CN10' => __( 'Shanghai / 上海', 'woofunnels' ),
		'CN11' => __( 'Jiangsu / 江苏', 'woofunnels' ),
		'CN12' => __( 'Zhejiang / 浙江', 'woofunnels' ),
		'CN13' => __( 'Anhui / 安徽', 'woofunnels' ),
		'CN14' => __( 'Fujian / 福建', 'woofunnels' ),
		'CN15' => __( 'Jiangxi / 江西', 'woofunnels' ),
		'CN16' => __( 'Shandong / 山东', 'woofunnels' ),
		'CN17' => __( 'Henan / 河南', 'woofunnels' ),
		'CN18' => __( 'Hubei / 湖北', 'woofunnels' ),
		'CN19' => __( 'Hunan / 湖南', 'woofunnels' ),
		'CN20' => __( 'Guangdong / 广东', 'woofunnels' ),
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'woofunnels' ),
		'CN22' => __( 'Hainan / 海南', 'woofunnels' ),
		'CN23' => __( 'Chongqing / 重庆', 'woofunnels' ),
		'CN24' => __( 'Sichuan / 四川', 'woofunnels' ),
		'CN25' => __( 'Guizhou / 贵州', 'woofunnels' ),
		'CN26' => __( 'Shaanxi / 陕西', 'woofunnels' ),
		'CN27' => __( 'Gansu / 甘肃', 'woofunnels' ),
		'CN28' => __( 'Qinghai / 青海', 'woofunnels' ),
		'CN29' => __( 'Ningxia Hui / 宁夏', 'woofunnels' ),
		'CN30' => __( 'Macao / 澳门', 'woofunnels' ),
		'CN31' => __( 'Tibet / 西藏', 'woofunnels' ),
		'CN32' => __( 'Xinjiang / 新疆', 'woofunnels' ),
	),
	'CZ' => array(),
	'DE' => array(),
	'DK' => array(),
	'DZ' => array(
		'DZ-01' => __( 'Adrar', 'woofunnels' ),
		'DZ-02' => __( 'Chlef', 'woofunnels' ),
		'DZ-03' => __( 'Laghouat', 'woofunnels' ),
		'DZ-04' => __( 'Oum El Bouaghi', 'woofunnels' ),
		'DZ-05' => __( 'Batna', 'woofunnels' ),
		'DZ-06' => __( 'Béjaïa', 'woofunnels' ),
		'DZ-07' => __( 'Biskra', 'woofunnels' ),
		'DZ-08' => __( 'Béchar', 'woofunnels' ),
		'DZ-09' => __( 'Blida', 'woofunnels' ),
		'DZ-10' => __( 'Bouira', 'woofunnels' ),
		'DZ-11' => __( 'Tamanghasset', 'woofunnels' ),
		'DZ-12' => __( 'Tébessa', 'woofunnels' ),
		'DZ-13' => __( 'Tlemcen', 'woofunnels' ),
		'DZ-14' => __( 'Tiaret', 'woofunnels' ),
		'DZ-15' => __( 'Tizi Ouzou', 'woofunnels' ),
		'DZ-16' => __( 'Algiers', 'woofunnels' ),
		'DZ-17' => __( 'Djelfa', 'woofunnels' ),
		'DZ-18' => __( 'Jijel', 'woofunnels' ),
		'DZ-19' => __( 'Sétif', 'woofunnels' ),
		'DZ-20' => __( 'Saïda', 'woofunnels' ),
		'DZ-21' => __( 'Skikda', 'woofunnels' ),
		'DZ-22' => __( 'Sidi Bel Abbès', 'woofunnels' ),
		'DZ-23' => __( 'Annaba', 'woofunnels' ),
		'DZ-24' => __( 'Guelma', 'woofunnels' ),
		'DZ-25' => __( 'Constantine', 'woofunnels' ),
		'DZ-26' => __( 'Médéa', 'woofunnels' ),
		'DZ-27' => __( 'Mostaganem', 'woofunnels' ),
		'DZ-28' => __( 'M’Sila', 'woofunnels' ),
		'DZ-29' => __( 'Mascara', 'woofunnels' ),
		'DZ-30' => __( 'Ouargla', 'woofunnels' ),
		'DZ-31' => __( 'Oran', 'woofunnels' ),
		'DZ-32' => __( 'El Bayadh', 'woofunnels' ),
		'DZ-33' => __( 'Illizi', 'woofunnels' ),
		'DZ-34' => __( 'Bordj Bou Arréridj', 'woofunnels' ),
		'DZ-35' => __( 'Boumerdès', 'woofunnels' ),
		'DZ-36' => __( 'El Tarf', 'woofunnels' ),
		'DZ-37' => __( 'Tindouf', 'woofunnels' ),
		'DZ-38' => __( 'Tissemsilt', 'woofunnels' ),
		'DZ-39' => __( 'El Oued', 'woofunnels' ),
		'DZ-40' => __( 'Khenchela', 'woofunnels' ),
		'DZ-41' => __( 'Souk Ahras', 'woofunnels' ),
		'DZ-42' => __( 'Tipasa', 'woofunnels' ),
		'DZ-43' => __( 'Mila', 'woofunnels' ),
		'DZ-44' => __( 'Aïn Defla', 'woofunnels' ),
		'DZ-45' => __( 'Naama', 'woofunnels' ),
		'DZ-46' => __( 'Aïn Témouchent', 'woofunnels' ),
		'DZ-47' => __( 'Ghardaïa', 'woofunnels' ),
		'DZ-48' => __( 'Relizane', 'woofunnels' ),
	),
	'EE' => array(),
	'EG' => array( // Egypt states.
		'EGALX' => __( 'Alexandria', 'woofunnels' ),
		'EGASN' => __( 'Aswan', 'woofunnels' ),
		'EGAST' => __( 'Asyut', 'woofunnels' ),
		'EGBA'  => __( 'Red Sea', 'woofunnels' ),
		'EGBH'  => __( 'Beheira', 'woofunnels' ),
		'EGBNS' => __( 'Beni Suef', 'woofunnels' ),
		'EGC'   => __( 'Cairo', 'woofunnels' ),
		'EGDK'  => __( 'Dakahlia', 'woofunnels' ),
		'EGDT'  => __( 'Damietta', 'woofunnels' ),
		'EGFYM' => __( 'Faiyum', 'woofunnels' ),
		'EGGH'  => __( 'Gharbia', 'woofunnels' ),
		'EGGZ'  => __( 'Giza', 'woofunnels' ),
		'EGIS'  => __( 'Ismailia', 'woofunnels' ),
		'EGJS'  => __( 'South Sinai', 'woofunnels' ),
		'EGKB'  => __( 'Qalyubia', 'woofunnels' ),
		'EGKFS' => __( 'Kafr el-Sheikh', 'woofunnels' ),
		'EGKN'  => __( 'Qena', 'woofunnels' ),
		'EGLX'  => __( 'Luxor', 'woofunnels' ),
		'EGMN'  => __( 'Minya', 'woofunnels' ),
		'EGMNF' => __( 'Monufia', 'woofunnels' ),
		'EGMT'  => __( 'Matrouh', 'woofunnels' ),
		'EGPTS' => __( 'Port Said', 'woofunnels' ),
		'EGSHG' => __( 'Sohag', 'woofunnels' ),
		'EGSHR' => __( 'Al Sharqia', 'woofunnels' ),
		'EGSIN' => __( 'North Sinai', 'woofunnels' ),
		'EGSUZ' => __( 'Suez', 'woofunnels' ),
		'EGWAD' => __( 'New Valley', 'woofunnels' ),
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'woofunnels' ),
		'VI' => __( 'Araba/Álava', 'woofunnels' ),
		'AB' => __( 'Albacete', 'woofunnels' ),
		'A'  => __( 'Alicante', 'woofunnels' ),
		'AL' => __( 'Almería', 'woofunnels' ),
		'O'  => __( 'Asturias', 'woofunnels' ),
		'AV' => __( 'Ávila', 'woofunnels' ),
		'BA' => __( 'Badajoz', 'woofunnels' ),
		'PM' => __( 'Baleares', 'woofunnels' ),
		'B'  => __( 'Barcelona', 'woofunnels' ),
		'BU' => __( 'Burgos', 'woofunnels' ),
		'CC' => __( 'Cáceres', 'woofunnels' ),
		'CA' => __( 'Cádiz', 'woofunnels' ),
		'S'  => __( 'Cantabria', 'woofunnels' ),
		'CS' => __( 'Castellón', 'woofunnels' ),
		'CE' => __( 'Ceuta', 'woofunnels' ),
		'CR' => __( 'Ciudad Real', 'woofunnels' ),
		'CO' => __( 'Córdoba', 'woofunnels' ),
		'CU' => __( 'Cuenca', 'woofunnels' ),
		'GI' => __( 'Girona', 'woofunnels' ),
		'GR' => __( 'Granada', 'woofunnels' ),
		'GU' => __( 'Guadalajara', 'woofunnels' ),
		'SS' => __( 'Gipuzkoa', 'woofunnels' ),
		'H'  => __( 'Huelva', 'woofunnels' ),
		'HU' => __( 'Huesca', 'woofunnels' ),
		'J'  => __( 'Jaén', 'woofunnels' ),
		'LO' => __( 'La Rioja', 'woofunnels' ),
		'GC' => __( 'Las Palmas', 'woofunnels' ),
		'LE' => __( 'León', 'woofunnels' ),
		'L'  => __( 'Lleida', 'woofunnels' ),
		'LU' => __( 'Lugo', 'woofunnels' ),
		'M'  => __( 'Madrid', 'woofunnels' ),
		'MA' => __( 'Málaga', 'woofunnels' ),
		'ML' => __( 'Melilla', 'woofunnels' ),
		'MU' => __( 'Murcia', 'woofunnels' ),
		'NA' => __( 'Navarra', 'woofunnels' ),
		'OR' => __( 'Ourense', 'woofunnels' ),
		'P'  => __( 'Palencia', 'woofunnels' ),
		'PO' => __( 'Pontevedra', 'woofunnels' ),
		'SA' => __( 'Salamanca', 'woofunnels' ),
		'TF' => __( 'Santa Cruz de Tenerife', 'woofunnels' ),
		'SG' => __( 'Segovia', 'woofunnels' ),
		'SE' => __( 'Sevilla', 'woofunnels' ),
		'SO' => __( 'Soria', 'woofunnels' ),
		'T'  => __( 'Tarragona', 'woofunnels' ),
		'TE' => __( 'Teruel', 'woofunnels' ),
		'TO' => __( 'Toledo', 'woofunnels' ),
		'V'  => __( 'Valencia', 'woofunnels' ),
		'VA' => __( 'Valladolid', 'woofunnels' ),
		'BI' => __( 'Biscay', 'woofunnels' ),
		'ZA' => __( 'Zamora', 'woofunnels' ),
		'Z'  => __( 'Zaragoza', 'woofunnels' ),
	),
	'FI' => array(),
	'FR' => array(),
	'GH' => array( // Ghanaian Regions.
		'AF' => __( 'Ahafo', 'woofunnels' ),
		'AH' => __( 'Ashanti', 'woofunnels' ),
		'BA' => __( 'Brong-Ahafo', 'woofunnels' ),
		'BO' => __( 'Bono', 'woofunnels' ),
		'BE' => __( 'Bono East', 'woofunnels' ),
		'CP' => __( 'Central', 'woofunnels' ),
		'EP' => __( 'Eastern', 'woofunnels' ),
		'AA' => __( 'Greater Accra', 'woofunnels' ),
		'NE' => __( 'North East', 'woofunnels' ),
		'NP' => __( 'Northern', 'woofunnels' ),
		'OT' => __( 'Oti', 'woofunnels' ),
		'SV' => __( 'Savannah', 'woofunnels' ),
		'UE' => __( 'Upper East', 'woofunnels' ),
		'UW' => __( 'Upper West', 'woofunnels' ),
		'TV' => __( 'Volta', 'woofunnels' ),
		'WP' => __( 'Western', 'woofunnels' ),
		'WN' => __( 'Western North', 'woofunnels' ),
	),
	'GP' => array(),
	'GR' => array( // Greek Regions.
		'I' => __( 'Attica', 'woofunnels' ),
		'A' => __( 'East Macedonia and Thrace', 'woofunnels' ),
		'B' => __( 'Central Macedonia', 'woofunnels' ),
		'C' => __( 'West Macedonia', 'woofunnels' ),
		'D' => __( 'Epirus', 'woofunnels' ),
		'E' => __( 'Thessaly', 'woofunnels' ),
		'F' => __( 'Ionian Islands', 'woofunnels' ),
		'G' => __( 'West Greece', 'woofunnels' ),
		'H' => __( 'Central Greece', 'woofunnels' ),
		'J' => __( 'Peloponnese', 'woofunnels' ),
		'K' => __( 'North Aegean', 'woofunnels' ),
		'L' => __( 'South Aegean', 'woofunnels' ),
		'M' => __( 'Crete', 'woofunnels' ),
	),
	'GF' => array(),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'woofunnels' ),
		'KOWLOON'         => __( 'Kowloon', 'woofunnels' ),
		'NEW TERRITORIES' => __( 'New Territories', 'woofunnels' ),
	),
	'HU' => array( // Hungary states.
		'BK' => __( 'Bács-Kiskun', 'woofunnels' ),
		'BE' => __( 'Békés', 'woofunnels' ),
		'BA' => __( 'Baranya', 'woofunnels' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'woofunnels' ),
		'BU' => __( 'Budapest', 'woofunnels' ),
		'CS' => __( 'Csongrád-Csanád', 'woofunnels' ),
		'FE' => __( 'Fejér', 'woofunnels' ),
		'GS' => __( 'Győr-Moson-Sopron', 'woofunnels' ),
		'HB' => __( 'Hajdú-Bihar', 'woofunnels' ),
		'HE' => __( 'Heves', 'woofunnels' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'woofunnels' ),
		'KE' => __( 'Komárom-Esztergom', 'woofunnels' ),
		'NO' => __( 'Nógrád', 'woofunnels' ),
		'PE' => __( 'Pest', 'woofunnels' ),
		'SO' => __( 'Somogy', 'woofunnels' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'woofunnels' ),
		'TO' => __( 'Tolna', 'woofunnels' ),
		'VA' => __( 'Vas', 'woofunnels' ),
		'VE' => __( 'Veszprém', 'woofunnels' ),
		'ZA' => __( 'Zala', 'woofunnels' ),
	),
	'ID' => array( // Indonesia Provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'woofunnels' ),
		'SU' => __( 'Sumatera Utara', 'woofunnels' ),
		'SB' => __( 'Sumatera Barat', 'woofunnels' ),
		'RI' => __( 'Riau', 'woofunnels' ),
		'KR' => __( 'Kepulauan Riau', 'woofunnels' ),
		'JA' => __( 'Jambi', 'woofunnels' ),
		'SS' => __( 'Sumatera Selatan', 'woofunnels' ),
		'BB' => __( 'Bangka Belitung', 'woofunnels' ),
		'BE' => __( 'Bengkulu', 'woofunnels' ),
		'LA' => __( 'Lampung', 'woofunnels' ),
		'JK' => __( 'DKI Jakarta', 'woofunnels' ),
		'JB' => __( 'Jawa Barat', 'woofunnels' ),
		'BT' => __( 'Banten', 'woofunnels' ),
		'JT' => __( 'Jawa Tengah', 'woofunnels' ),
		'JI' => __( 'Jawa Timur', 'woofunnels' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'woofunnels' ),
		'BA' => __( 'Bali', 'woofunnels' ),
		'NB' => __( 'Nusa Tenggara Barat', 'woofunnels' ),
		'NT' => __( 'Nusa Tenggara Timur', 'woofunnels' ),
		'KB' => __( 'Kalimantan Barat', 'woofunnels' ),
		'KT' => __( 'Kalimantan Tengah', 'woofunnels' ),
		'KI' => __( 'Kalimantan Timur', 'woofunnels' ),
		'KS' => __( 'Kalimantan Selatan', 'woofunnels' ),
		'KU' => __( 'Kalimantan Utara', 'woofunnels' ),
		'SA' => __( 'Sulawesi Utara', 'woofunnels' ),
		'ST' => __( 'Sulawesi Tengah', 'woofunnels' ),
		'SG' => __( 'Sulawesi Tenggara', 'woofunnels' ),
		'SR' => __( 'Sulawesi Barat', 'woofunnels' ),
		'SN' => __( 'Sulawesi Selatan', 'woofunnels' ),
		'GO' => __( 'Gorontalo', 'woofunnels' ),
		'MA' => __( 'Maluku', 'woofunnels' ),
		'MU' => __( 'Maluku Utara', 'woofunnels' ),
		'PA' => __( 'Papua', 'woofunnels' ),
		'PB' => __( 'Papua Barat', 'woofunnels' ),
	),
	'IE' => array( // Republic of Ireland.
		'CW' => __( 'Carlow', 'woofunnels' ),
		'CN' => __( 'Cavan', 'woofunnels' ),
		'CE' => __( 'Clare', 'woofunnels' ),
		'CO' => __( 'Cork', 'woofunnels' ),
		'DL' => __( 'Donegal', 'woofunnels' ),
		'D'  => __( 'Dublin', 'woofunnels' ),
		'G'  => __( 'Galway', 'woofunnels' ),
		'KY' => __( 'Kerry', 'woofunnels' ),
		'KE' => __( 'Kildare', 'woofunnels' ),
		'KK' => __( 'Kilkenny', 'woofunnels' ),
		'LS' => __( 'Laois', 'woofunnels' ),
		'LM' => __( 'Leitrim', 'woofunnels' ),
		'LK' => __( 'Limerick', 'woofunnels' ),
		'LD' => __( 'Longford', 'woofunnels' ),
		'LH' => __( 'Louth', 'woofunnels' ),
		'MO' => __( 'Mayo', 'woofunnels' ),
		'MH' => __( 'Meath', 'woofunnels' ),
		'MN' => __( 'Monaghan', 'woofunnels' ),
		'OY' => __( 'Offaly', 'woofunnels' ),
		'RN' => __( 'Roscommon', 'woofunnels' ),
		'SO' => __( 'Sligo', 'woofunnels' ),
		'TA' => __( 'Tipperary', 'woofunnels' ),
		'WD' => __( 'Waterford', 'woofunnels' ),
		'WH' => __( 'Westmeath', 'woofunnels' ),
		'WX' => __( 'Wexford', 'woofunnels' ),
		'WW' => __( 'Wicklow', 'woofunnels' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'woofunnels' ),
		'AR' => __( 'Arunachal Pradesh', 'woofunnels' ),
		'AS' => __( 'Assam', 'woofunnels' ),
		'BR' => __( 'Bihar', 'woofunnels' ),
		'CT' => __( 'Chhattisgarh', 'woofunnels' ),
		'GA' => __( 'Goa', 'woofunnels' ),
		'GJ' => __( 'Gujarat', 'woofunnels' ),
		'HR' => __( 'Haryana', 'woofunnels' ),
		'HP' => __( 'Himachal Pradesh', 'woofunnels' ),
		'JK' => __( 'Jammu and Kashmir', 'woofunnels' ),
		'JH' => __( 'Jharkhand', 'woofunnels' ),
		'KA' => __( 'Karnataka', 'woofunnels' ),
		'KL' => __( 'Kerala', 'woofunnels' ),
		'MP' => __( 'Madhya Pradesh', 'woofunnels' ),
		'MH' => __( 'Maharashtra', 'woofunnels' ),
		'MN' => __( 'Manipur', 'woofunnels' ),
		'ML' => __( 'Meghalaya', 'woofunnels' ),
		'MZ' => __( 'Mizoram', 'woofunnels' ),
		'NL' => __( 'Nagaland', 'woofunnels' ),
		'OR' => __( 'Orissa', 'woofunnels' ),
		'PB' => __( 'Punjab', 'woofunnels' ),
		'RJ' => __( 'Rajasthan', 'woofunnels' ),
		'SK' => __( 'Sikkim', 'woofunnels' ),
		'TN' => __( 'Tamil Nadu', 'woofunnels' ),
		'TS' => __( 'Telangana', 'woofunnels' ),
		'TR' => __( 'Tripura', 'woofunnels' ),
		'UK' => __( 'Uttarakhand', 'woofunnels' ),
		'UP' => __( 'Uttar Pradesh', 'woofunnels' ),
		'WB' => __( 'West Bengal', 'woofunnels' ),
		'AN' => __( 'Andaman and Nicobar Islands', 'woofunnels' ),
		'CH' => __( 'Chandigarh', 'woofunnels' ),
		'DN' => __( 'Dadra and Nagar Haveli', 'woofunnels' ),
		'DD' => __( 'Daman and Diu', 'woofunnels' ),
		'DL' => __( 'Delhi', 'woofunnels' ),
		'LD' => __( 'Lakshadeep', 'woofunnels' ),
		'PY' => __( 'Pondicherry (Puducherry)', 'woofunnels' ),
	),
	'IR' => array( // Iran States.
		'KHZ' => __( 'Khuzestan  (خوزستان)', 'woofunnels' ),
		'THR' => __( 'Tehran  (تهران)', 'woofunnels' ),
		'ILM' => __( 'Ilaam (ایلام)', 'woofunnels' ),
		'BHR' => __( 'Bushehr (بوشهر)', 'woofunnels' ),
		'ADL' => __( 'Ardabil (اردبیل)', 'woofunnels' ),
		'ESF' => __( 'Isfahan (اصفهان)', 'woofunnels' ),
		'YZD' => __( 'Yazd (یزد)', 'woofunnels' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'woofunnels' ),
		'KRN' => __( 'Kerman (کرمان)', 'woofunnels' ),
		'HDN' => __( 'Hamadan (همدان)', 'woofunnels' ),
		'GZN' => __( 'Ghazvin (قزوین)', 'woofunnels' ),
		'ZJN' => __( 'Zanjan (زنجان)', 'woofunnels' ),
		'LRS' => __( 'Luristan (لرستان)', 'woofunnels' ),
		'ABZ' => __( 'Alborz (البرز)', 'woofunnels' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'woofunnels' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'woofunnels' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'woofunnels' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'woofunnels' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'woofunnels' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'woofunnels' ),
		'SMN' => __( 'Semnan (سمنان)', 'woofunnels' ),
		'FRS' => __( 'Fars (فارس)', 'woofunnels' ),
		'QHM' => __( 'Qom (قم)', 'woofunnels' ),
		'KRD' => __( 'Kurdistan / کردستان)', 'woofunnels' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'woofunnels' ),
		'GLS' => __( 'Golestan (گلستان)', 'woofunnels' ),
		'GIL' => __( 'Gilan (گیلان)', 'woofunnels' ),
		'MZN' => __( 'Mazandaran (مازندران)', 'woofunnels' ),
		'MKZ' => __( 'Markazi (مرکزی)', 'woofunnels' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'woofunnels' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'woofunnels' ),
	),
	'IS' => array(),
	'IT' => array( // Italy Provinces.
		'AG' => __( 'Agrigento', 'woofunnels' ),
		'AL' => __( 'Alessandria', 'woofunnels' ),
		'AN' => __( 'Ancona', 'woofunnels' ),
		'AO' => __( 'Aosta', 'woofunnels' ),
		'AR' => __( 'Arezzo', 'woofunnels' ),
		'AP' => __( 'Ascoli Piceno', 'woofunnels' ),
		'AT' => __( 'Asti', 'woofunnels' ),
		'AV' => __( 'Avellino', 'woofunnels' ),
		'BA' => __( 'Bari', 'woofunnels' ),
		'BT' => __( 'Barletta-Andria-Trani', 'woofunnels' ),
		'BL' => __( 'Belluno', 'woofunnels' ),
		'BN' => __( 'Benevento', 'woofunnels' ),
		'BG' => __( 'Bergamo', 'woofunnels' ),
		'BI' => __( 'Biella', 'woofunnels' ),
		'BO' => __( 'Bologna', 'woofunnels' ),
		'BZ' => __( 'Bolzano', 'woofunnels' ),
		'BS' => __( 'Brescia', 'woofunnels' ),
		'BR' => __( 'Brindisi', 'woofunnels' ),
		'CA' => __( 'Cagliari', 'woofunnels' ),
		'CL' => __( 'Caltanissetta', 'woofunnels' ),
		'CB' => __( 'Campobasso', 'woofunnels' ),
		'CE' => __( 'Caserta', 'woofunnels' ),
		'CT' => __( 'Catania', 'woofunnels' ),
		'CZ' => __( 'Catanzaro', 'woofunnels' ),
		'CH' => __( 'Chieti', 'woofunnels' ),
		'CO' => __( 'Como', 'woofunnels' ),
		'CS' => __( 'Cosenza', 'woofunnels' ),
		'CR' => __( 'Cremona', 'woofunnels' ),
		'KR' => __( 'Crotone', 'woofunnels' ),
		'CN' => __( 'Cuneo', 'woofunnels' ),
		'EN' => __( 'Enna', 'woofunnels' ),
		'FM' => __( 'Fermo', 'woofunnels' ),
		'FE' => __( 'Ferrara', 'woofunnels' ),
		'FI' => __( 'Firenze', 'woofunnels' ),
		'FG' => __( 'Foggia', 'woofunnels' ),
		'FC' => __( 'Forlì-Cesena', 'woofunnels' ),
		'FR' => __( 'Frosinone', 'woofunnels' ),
		'GE' => __( 'Genova', 'woofunnels' ),
		'GO' => __( 'Gorizia', 'woofunnels' ),
		'GR' => __( 'Grosseto', 'woofunnels' ),
		'IM' => __( 'Imperia', 'woofunnels' ),
		'IS' => __( 'Isernia', 'woofunnels' ),
		'SP' => __( 'La Spezia', 'woofunnels' ),
		'AQ' => __( "L'Aquila", 'woofunnels' ),
		'LT' => __( 'Latina', 'woofunnels' ),
		'LE' => __( 'Lecce', 'woofunnels' ),
		'LC' => __( 'Lecco', 'woofunnels' ),
		'LI' => __( 'Livorno', 'woofunnels' ),
		'LO' => __( 'Lodi', 'woofunnels' ),
		'LU' => __( 'Lucca', 'woofunnels' ),
		'MC' => __( 'Macerata', 'woofunnels' ),
		'MN' => __( 'Mantova', 'woofunnels' ),
		'MS' => __( 'Massa-Carrara', 'woofunnels' ),
		'MT' => __( 'Matera', 'woofunnels' ),
		'ME' => __( 'Messina', 'woofunnels' ),
		'MI' => __( 'Milano', 'woofunnels' ),
		'MO' => __( 'Modena', 'woofunnels' ),
		'MB' => __( 'Monza e della Brianza', 'woofunnels' ),
		'NA' => __( 'Napoli', 'woofunnels' ),
		'NO' => __( 'Novara', 'woofunnels' ),
		'NU' => __( 'Nuoro', 'woofunnels' ),
		'OR' => __( 'Oristano', 'woofunnels' ),
		'PD' => __( 'Padova', 'woofunnels' ),
		'PA' => __( 'Palermo', 'woofunnels' ),
		'PR' => __( 'Parma', 'woofunnels' ),
		'PV' => __( 'Pavia', 'woofunnels' ),
		'PG' => __( 'Perugia', 'woofunnels' ),
		'PU' => __( 'Pesaro e Urbino', 'woofunnels' ),
		'PE' => __( 'Pescara', 'woofunnels' ),
		'PC' => __( 'Piacenza', 'woofunnels' ),
		'PI' => __( 'Pisa', 'woofunnels' ),
		'PT' => __( 'Pistoia', 'woofunnels' ),
		'PN' => __( 'Pordenone', 'woofunnels' ),
		'PZ' => __( 'Potenza', 'woofunnels' ),
		'PO' => __( 'Prato', 'woofunnels' ),
		'RG' => __( 'Ragusa', 'woofunnels' ),
		'RA' => __( 'Ravenna', 'woofunnels' ),
		'RC' => __( 'Reggio Calabria', 'woofunnels' ),
		'RE' => __( 'Reggio Emilia', 'woofunnels' ),
		'RI' => __( 'Rieti', 'woofunnels' ),
		'RN' => __( 'Rimini', 'woofunnels' ),
		'RM' => __( 'Roma', 'woofunnels' ),
		'RO' => __( 'Rovigo', 'woofunnels' ),
		'SA' => __( 'Salerno', 'woofunnels' ),
		'SS' => __( 'Sassari', 'woofunnels' ),
		'SV' => __( 'Savona', 'woofunnels' ),
		'SI' => __( 'Siena', 'woofunnels' ),
		'SR' => __( 'Siracusa', 'woofunnels' ),
		'SO' => __( 'Sondrio', 'woofunnels' ),
		'SU' => __( 'Sud Sardegna', 'woofunnels' ),
		'TA' => __( 'Taranto', 'woofunnels' ),
		'TE' => __( 'Teramo', 'woofunnels' ),
		'TR' => __( 'Terni', 'woofunnels' ),
		'TO' => __( 'Torino', 'woofunnels' ),
		'TP' => __( 'Trapani', 'woofunnels' ),
		'TN' => __( 'Trento', 'woofunnels' ),
		'TV' => __( 'Treviso', 'woofunnels' ),
		'TS' => __( 'Trieste', 'woofunnels' ),
		'UD' => __( 'Udine', 'woofunnels' ),
		'VA' => __( 'Varese', 'woofunnels' ),
		'VE' => __( 'Venezia', 'woofunnels' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'woofunnels' ),
		'VC' => __( 'Vercelli', 'woofunnels' ),
		'VR' => __( 'Verona', 'woofunnels' ),
		'VV' => __( 'Vibo Valentia', 'woofunnels' ),
		'VI' => __( 'Vicenza', 'woofunnels' ),
		'VT' => __( 'Viterbo', 'woofunnels' ),
	),
	'IL' => array(),
	'IM' => array(),

	/**
	 * Japan States.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'woofunnels' ),
		'JP02' => __( 'Aomori', 'woofunnels' ),
		'JP03' => __( 'Iwate', 'woofunnels' ),
		'JP04' => __( 'Miyagi', 'woofunnels' ),
		'JP05' => __( 'Akita', 'woofunnels' ),
		'JP06' => __( 'Yamagata', 'woofunnels' ),
		'JP07' => __( 'Fukushima', 'woofunnels' ),
		'JP08' => __( 'Ibaraki', 'woofunnels' ),
		'JP09' => __( 'Tochigi', 'woofunnels' ),
		'JP10' => __( 'Gunma', 'woofunnels' ),
		'JP11' => __( 'Saitama', 'woofunnels' ),
		'JP12' => __( 'Chiba', 'woofunnels' ),
		'JP13' => __( 'Tokyo', 'woofunnels' ),
		'JP14' => __( 'Kanagawa', 'woofunnels' ),
		'JP15' => __( 'Niigata', 'woofunnels' ),
		'JP16' => __( 'Toyama', 'woofunnels' ),
		'JP17' => __( 'Ishikawa', 'woofunnels' ),
		'JP18' => __( 'Fukui', 'woofunnels' ),
		'JP19' => __( 'Yamanashi', 'woofunnels' ),
		'JP20' => __( 'Nagano', 'woofunnels' ),
		'JP21' => __( 'Gifu', 'woofunnels' ),
		'JP22' => __( 'Shizuoka', 'woofunnels' ),
		'JP23' => __( 'Aichi', 'woofunnels' ),
		'JP24' => __( 'Mie', 'woofunnels' ),
		'JP25' => __( 'Shiga', 'woofunnels' ),
		'JP26' => __( 'Kyoto', 'woofunnels' ),
		'JP27' => __( 'Osaka', 'woofunnels' ),
		'JP28' => __( 'Hyogo', 'woofunnels' ),
		'JP29' => __( 'Nara', 'woofunnels' ),
		'JP30' => __( 'Wakayama', 'woofunnels' ),
		'JP31' => __( 'Tottori', 'woofunnels' ),
		'JP32' => __( 'Shimane', 'woofunnels' ),
		'JP33' => __( 'Okayama', 'woofunnels' ),
		'JP34' => __( 'Hiroshima', 'woofunnels' ),
		'JP35' => __( 'Yamaguchi', 'woofunnels' ),
		'JP36' => __( 'Tokushima', 'woofunnels' ),
		'JP37' => __( 'Kagawa', 'woofunnels' ),
		'JP38' => __( 'Ehime', 'woofunnels' ),
		'JP39' => __( 'Kochi', 'woofunnels' ),
		'JP40' => __( 'Fukuoka', 'woofunnels' ),
		'JP41' => __( 'Saga', 'woofunnels' ),
		'JP42' => __( 'Nagasaki', 'woofunnels' ),
		'JP43' => __( 'Kumamoto', 'woofunnels' ),
		'JP44' => __( 'Oita', 'woofunnels' ),
		'JP45' => __( 'Miyazaki', 'woofunnels' ),
		'JP46' => __( 'Kagoshima', 'woofunnels' ),
		'JP47' => __( 'Okinawa', 'woofunnels' ),
	),
	'KE' => array( // Kenya counties.
		'KE01' => __( 'Baringo', 'woofunnels' ),
		'KE02' => __( 'Bomet', 'woofunnels' ),
		'KE03' => __( 'Bungoma', 'woofunnels' ),
		'KE04' => __( 'Busia', 'woofunnels' ),
		'KE05' => __( 'Elgeyo-Marakwet', 'woofunnels' ),
		'KE06' => __( 'Embu', 'woofunnels' ),
		'KE07' => __( 'Garissa', 'woofunnels' ),
		'KE08' => __( 'Homa Bay', 'woofunnels' ),
		'KE09' => __( 'Isiolo', 'woofunnels' ),
		'KE10' => __( 'Kajiado', 'woofunnels' ),
		'KE11' => __( 'Kakamega', 'woofunnels' ),
		'KE12' => __( 'Kericho', 'woofunnels' ),
		'KE13' => __( 'Kiambu', 'woofunnels' ),
		'KE14' => __( 'Kilifi', 'woofunnels' ),
		'KE15' => __( 'Kirinyaga', 'woofunnels' ),
		'KE16' => __( 'Kisii', 'woofunnels' ),
		'KE17' => __( 'Kisumu', 'woofunnels' ),
		'KE18' => __( 'Kitui', 'woofunnels' ),
		'KE19' => __( 'Kwale', 'woofunnels' ),
		'KE20' => __( 'Laikipia', 'woofunnels' ),
		'KE21' => __( 'Lamu', 'woofunnels' ),
		'KE22' => __( 'Machakos', 'woofunnels' ),
		'KE23' => __( 'Makueni', 'woofunnels' ),
		'KE24' => __( 'Mandera', 'woofunnels' ),
		'KE25' => __( 'Marsabit', 'woofunnels' ),
		'KE26' => __( 'Meru', 'woofunnels' ),
		'KE27' => __( 'Migori', 'woofunnels' ),
		'KE28' => __( 'Mombasa', 'woofunnels' ),
		'KE29' => __( 'Murang’a', 'woofunnels' ),
		'KE30' => __( 'Nairobi County', 'woofunnels' ),
		'KE31' => __( 'Nakuru', 'woofunnels' ),
		'KE32' => __( 'Nandi', 'woofunnels' ),
		'KE33' => __( 'Narok', 'woofunnels' ),
		'KE34' => __( 'Nyamira', 'woofunnels' ),
		'KE35' => __( 'Nyandarua', 'woofunnels' ),
		'KE36' => __( 'Nyeri', 'woofunnels' ),
		'KE37' => __( 'Samburu', 'woofunnels' ),
		'KE38' => __( 'Siaya', 'woofunnels' ),
		'KE39' => __( 'Taita-Taveta', 'woofunnels' ),
		'KE40' => __( 'Tana River', 'woofunnels' ),
		'KE41' => __( 'Tharaka-Nithi', 'woofunnels' ),
		'KE42' => __( 'Trans Nzoia', 'woofunnels' ),
		'KE43' => __( 'Turkana', 'woofunnels' ),
		'KE44' => __( 'Uasin Gishu', 'woofunnels' ),
		'KE45' => __( 'Vihiga', 'woofunnels' ),
		'KE46' => __( 'Wajir', 'woofunnels' ),
		'KE47' => __( 'West Pokot', 'woofunnels' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array(
		'AT' => __( 'Attapeu', 'woofunnels' ),
		'BK' => __( 'Bokeo', 'woofunnels' ),
		'BL' => __( 'Bolikhamsai', 'woofunnels' ),
		'CH' => __( 'Champasak', 'woofunnels' ),
		'HO' => __( 'Houaphanh', 'woofunnels' ),
		'KH' => __( 'Khammouane', 'woofunnels' ),
		'LM' => __( 'Luang Namtha', 'woofunnels' ),
		'LP' => __( 'Luang Prabang', 'woofunnels' ),
		'OU' => __( 'Oudomxay', 'woofunnels' ),
		'PH' => __( 'Phongsaly', 'woofunnels' ),
		'SL' => __( 'Salavan', 'woofunnels' ),
		'SV' => __( 'Savannakhet', 'woofunnels' ),
		'VI' => __( 'Vientiane Province', 'woofunnels' ),
		'VT' => __( 'Vientiane', 'woofunnels' ),
		'XA' => __( 'Sainyabuli', 'woofunnels' ),
		'XE' => __( 'Sekong', 'woofunnels' ),
		'XI' => __( 'Xiangkhouang', 'woofunnels' ),
		'XS' => __( 'Xaisomboun', 'woofunnels' ),
	),
	'LB' => array(),
	'LR' => array( // Liberia provinces.
		'BM' => __( 'Bomi', 'woofunnels' ),
		'BN' => __( 'Bong', 'woofunnels' ),
		'GA' => __( 'Gbarpolu', 'woofunnels' ),
		'GB' => __( 'Grand Bassa', 'woofunnels' ),
		'GC' => __( 'Grand Cape Mount', 'woofunnels' ),
		'GG' => __( 'Grand Gedeh', 'woofunnels' ),
		'GK' => __( 'Grand Kru', 'woofunnels' ),
		'LO' => __( 'Lofa', 'woofunnels' ),
		'MA' => __( 'Margibi', 'woofunnels' ),
		'MY' => __( 'Maryland', 'woofunnels' ),
		'MO' => __( 'Montserrado', 'woofunnels' ),
		'NM' => __( 'Nimba', 'woofunnels' ),
		'RV' => __( 'Rivercess', 'woofunnels' ),
		'RG' => __( 'River Gee', 'woofunnels' ),
		'SN' => __( 'Sinoe', 'woofunnels' ),
	),
	'LU' => array(),
	'MD' => array( // Moldova states.
		'C'  => __( 'Chișinău', 'woofunnels' ),
		'BL' => __( 'Bălți', 'woofunnels' ),
		'AN' => __( 'Anenii Noi', 'woofunnels' ),
		'BS' => __( 'Basarabeasca', 'woofunnels' ),
		'BR' => __( 'Briceni', 'woofunnels' ),
		'CH' => __( 'Cahul', 'woofunnels' ),
		'CT' => __( 'Cantemir', 'woofunnels' ),
		'CL' => __( 'Călărași', 'woofunnels' ),
		'CS' => __( 'Căușeni', 'woofunnels' ),
		'CM' => __( 'Cimișlia', 'woofunnels' ),
		'CR' => __( 'Criuleni', 'woofunnels' ),
		'DN' => __( 'Dondușeni', 'woofunnels' ),
		'DR' => __( 'Drochia', 'woofunnels' ),
		'DB' => __( 'Dubăsari', 'woofunnels' ),
		'ED' => __( 'Edineț', 'woofunnels' ),
		'FL' => __( 'Fălești', 'woofunnels' ),
		'FR' => __( 'Florești', 'woofunnels' ),
		'GE' => __( 'UTA Găgăuzia', 'woofunnels' ),
		'GL' => __( 'Glodeni', 'woofunnels' ),
		'HN' => __( 'Hîncești', 'woofunnels' ),
		'IL' => __( 'Ialoveni', 'woofunnels' ),
		'LV' => __( 'Leova', 'woofunnels' ),
		'NS' => __( 'Nisporeni', 'woofunnels' ),
		'OC' => __( 'Ocnița', 'woofunnels' ),
		'OR' => __( 'Orhei', 'woofunnels' ),
		'RZ' => __( 'Rezina', 'woofunnels' ),
		'RS' => __( 'Rîșcani', 'woofunnels' ),
		'SG' => __( 'Sîngerei', 'woofunnels' ),
		'SR' => __( 'Soroca', 'woofunnels' ),
		'ST' => __( 'Strășeni', 'woofunnels' ),
		'SD' => __( 'Șoldănești', 'woofunnels' ),
		'SV' => __( 'Ștefan Vodă', 'woofunnels' ),
		'TR' => __( 'Taraclia', 'woofunnels' ),
		'TL' => __( 'Telenești', 'woofunnels' ),
		'UN' => __( 'Ungheni', 'woofunnels' ),
	),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexico States.
		'DF' => __( 'Ciudad de México', 'woofunnels' ),
		'JA' => __( 'Jalisco', 'woofunnels' ),
		'NL' => __( 'Nuevo León', 'woofunnels' ),
		'AG' => __( 'Aguascalientes', 'woofunnels' ),
		'BC' => __( 'Baja California', 'woofunnels' ),
		'BS' => __( 'Baja California Sur', 'woofunnels' ),
		'CM' => __( 'Campeche', 'woofunnels' ),
		'CS' => __( 'Chiapas', 'woofunnels' ),
		'CH' => __( 'Chihuahua', 'woofunnels' ),
		'CO' => __( 'Coahuila', 'woofunnels' ),
		'CL' => __( 'Colima', 'woofunnels' ),
		'DG' => __( 'Durango', 'woofunnels' ),
		'GT' => __( 'Guanajuato', 'woofunnels' ),
		'GR' => __( 'Guerrero', 'woofunnels' ),
		'HG' => __( 'Hidalgo', 'woofunnels' ),
		'MX' => __( 'Estado de México', 'woofunnels' ),
		'MI' => __( 'Michoacán', 'woofunnels' ),
		'MO' => __( 'Morelos', 'woofunnels' ),
		'NA' => __( 'Nayarit', 'woofunnels' ),
		'OA' => __( 'Oaxaca', 'woofunnels' ),
		'PU' => __( 'Puebla', 'woofunnels' ),
		'QT' => __( 'Querétaro', 'woofunnels' ),
		'QR' => __( 'Quintana Roo', 'woofunnels' ),
		'SL' => __( 'San Luis Potosí', 'woofunnels' ),
		'SI' => __( 'Sinaloa', 'woofunnels' ),
		'SO' => __( 'Sonora', 'woofunnels' ),
		'TB' => __( 'Tabasco', 'woofunnels' ),
		'TM' => __( 'Tamaulipas', 'woofunnels' ),
		'TL' => __( 'Tlaxcala', 'woofunnels' ),
		'VE' => __( 'Veracruz', 'woofunnels' ),
		'YU' => __( 'Yucatán', 'woofunnels' ),
		'ZA' => __( 'Zacatecas', 'woofunnels' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'woofunnels' ),
		'KDH' => __( 'Kedah', 'woofunnels' ),
		'KTN' => __( 'Kelantan', 'woofunnels' ),
		'LBN' => __( 'Labuan', 'woofunnels' ),
		'MLK' => __( 'Malacca (Melaka)', 'woofunnels' ),
		'NSN' => __( 'Negeri Sembilan', 'woofunnels' ),
		'PHG' => __( 'Pahang', 'woofunnels' ),
		'PNG' => __( 'Penang (Pulau Pinang)', 'woofunnels' ),
		'PRK' => __( 'Perak', 'woofunnels' ),
		'PLS' => __( 'Perlis', 'woofunnels' ),
		'SBH' => __( 'Sabah', 'woofunnels' ),
		'SWK' => __( 'Sarawak', 'woofunnels' ),
		'SGR' => __( 'Selangor', 'woofunnels' ),
		'TRG' => __( 'Terengganu', 'woofunnels' ),
		'PJY' => __( 'Putrajaya', 'woofunnels' ),
		'KUL' => __( 'Kuala Lumpur', 'woofunnels' ),
	),
	'MZ' => array( // Mozambique provinces.
		'MZP'   => __( 'Cabo Delgado', 'woofunnels' ),
		'MZG'   => __( 'Gaza', 'woofunnels' ),
		'MZI'   => __( 'Inhambane', 'woofunnels' ),
		'MZB'   => __( 'Manica', 'woofunnels' ),
		'MZL'   => __( 'Maputo Province', 'woofunnels' ),
		'MZMPM' => __( 'Maputo', 'woofunnels' ),
		'MZN'   => __( 'Nampula', 'woofunnels' ),
		'MZA'   => __( 'Niassa', 'woofunnels' ),
		'MZS'   => __( 'Sofala', 'woofunnels' ),
		'MZT'   => __( 'Tete', 'woofunnels' ),
		'MZQ'   => __( 'Zambézia', 'woofunnels' ),
	),
	'NA' => array( // Namibia regions.
		'ER' => __( 'Erongo', 'woofunnels' ),
		'HA' => __( 'Hardap', 'woofunnels' ),
		'KA' => __( 'Karas', 'woofunnels' ),
		'KE' => __( 'Kavango East', 'woofunnels' ),
		'KW' => __( 'Kavango West', 'woofunnels' ),
		'KH' => __( 'Khomas', 'woofunnels' ),
		'KU' => __( 'Kunene', 'woofunnels' ),
		'OW' => __( 'Ohangwena', 'woofunnels' ),
		'OH' => __( 'Omaheke', 'woofunnels' ),
		'OS' => __( 'Omusati', 'woofunnels' ),
		'ON' => __( 'Oshana', 'woofunnels' ),
		'OT' => __( 'Oshikoto', 'woofunnels' ),
		'OD' => __( 'Otjozondjupa', 'woofunnels' ),
		'CA' => __( 'Zambezi', 'woofunnels' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'woofunnels' ),
		'FC' => __( 'Abuja', 'woofunnels' ),
		'AD' => __( 'Adamawa', 'woofunnels' ),
		'AK' => __( 'Akwa Ibom', 'woofunnels' ),
		'AN' => __( 'Anambra', 'woofunnels' ),
		'BA' => __( 'Bauchi', 'woofunnels' ),
		'BY' => __( 'Bayelsa', 'woofunnels' ),
		'BE' => __( 'Benue', 'woofunnels' ),
		'BO' => __( 'Borno', 'woofunnels' ),
		'CR' => __( 'Cross River', 'woofunnels' ),
		'DE' => __( 'Delta', 'woofunnels' ),
		'EB' => __( 'Ebonyi', 'woofunnels' ),
		'ED' => __( 'Edo', 'woofunnels' ),
		'EK' => __( 'Ekiti', 'woofunnels' ),
		'EN' => __( 'Enugu', 'woofunnels' ),
		'GO' => __( 'Gombe', 'woofunnels' ),
		'IM' => __( 'Imo', 'woofunnels' ),
		'JI' => __( 'Jigawa', 'woofunnels' ),
		'KD' => __( 'Kaduna', 'woofunnels' ),
		'KN' => __( 'Kano', 'woofunnels' ),
		'KT' => __( 'Katsina', 'woofunnels' ),
		'KE' => __( 'Kebbi', 'woofunnels' ),
		'KO' => __( 'Kogi', 'woofunnels' ),
		'KW' => __( 'Kwara', 'woofunnels' ),
		'LA' => __( 'Lagos', 'woofunnels' ),
		'NA' => __( 'Nasarawa', 'woofunnels' ),
		'NI' => __( 'Niger', 'woofunnels' ),
		'OG' => __( 'Ogun', 'woofunnels' ),
		'ON' => __( 'Ondo', 'woofunnels' ),
		'OS' => __( 'Osun', 'woofunnels' ),
		'OY' => __( 'Oyo', 'woofunnels' ),
		'PL' => __( 'Plateau', 'woofunnels' ),
		'RI' => __( 'Rivers', 'woofunnels' ),
		'SO' => __( 'Sokoto', 'woofunnels' ),
		'TA' => __( 'Taraba', 'woofunnels' ),
		'YO' => __( 'Yobe', 'woofunnels' ),
		'ZA' => __( 'Zamfara', 'woofunnels' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepal states (Zones).
		'BAG' => __( 'Bagmati', 'woofunnels' ),
		'BHE' => __( 'Bheri', 'woofunnels' ),
		'DHA' => __( 'Dhaulagiri', 'woofunnels' ),
		'GAN' => __( 'Gandaki', 'woofunnels' ),
		'JAN' => __( 'Janakpur', 'woofunnels' ),
		'KAR' => __( 'Karnali', 'woofunnels' ),
		'KOS' => __( 'Koshi', 'woofunnels' ),
		'LUM' => __( 'Lumbini', 'woofunnels' ),
		'MAH' => __( 'Mahakali', 'woofunnels' ),
		'MEC' => __( 'Mechi', 'woofunnels' ),
		'NAR' => __( 'Narayani', 'woofunnels' ),
		'RAP' => __( 'Rapti', 'woofunnels' ),
		'SAG' => __( 'Sagarmatha', 'woofunnels' ),
		'SET' => __( 'Seti', 'woofunnels' ),
	),
	'NZ' => array( // New Zealand States.
		'NL' => __( 'Northland', 'woofunnels' ),
		'AK' => __( 'Auckland', 'woofunnels' ),
		'WA' => __( 'Waikato', 'woofunnels' ),
		'BP' => __( 'Bay of Plenty', 'woofunnels' ),
		'TK' => __( 'Taranaki', 'woofunnels' ),
		'GI' => __( 'Gisborne', 'woofunnels' ),
		'HB' => __( 'Hawke’s Bay', 'woofunnels' ),
		'MW' => __( 'Manawatu-Wanganui', 'woofunnels' ),
		'WE' => __( 'Wellington', 'woofunnels' ),
		'NS' => __( 'Nelson', 'woofunnels' ),
		'MB' => __( 'Marlborough', 'woofunnels' ),
		'TM' => __( 'Tasman', 'woofunnels' ),
		'WC' => __( 'West Coast', 'woofunnels' ),
		'CT' => __( 'Canterbury', 'woofunnels' ),
		'OT' => __( 'Otago', 'woofunnels' ),
		'SL' => __( 'Southland', 'woofunnels' ),
	),
	'PE' => array( // Peru states.
		'CAL' => __( 'El Callao', 'woofunnels' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'woofunnels' ),
		'AMA' => __( 'Amazonas', 'woofunnels' ),
		'ANC' => __( 'Ancash', 'woofunnels' ),
		'APU' => __( 'Apurímac', 'woofunnels' ),
		'ARE' => __( 'Arequipa', 'woofunnels' ),
		'AYA' => __( 'Ayacucho', 'woofunnels' ),
		'CAJ' => __( 'Cajamarca', 'woofunnels' ),
		'CUS' => __( 'Cusco', 'woofunnels' ),
		'HUV' => __( 'Huancavelica', 'woofunnels' ),
		'HUC' => __( 'Huánuco', 'woofunnels' ),
		'ICA' => __( 'Ica', 'woofunnels' ),
		'JUN' => __( 'Junín', 'woofunnels' ),
		'LAL' => __( 'La Libertad', 'woofunnels' ),
		'LAM' => __( 'Lambayeque', 'woofunnels' ),
		'LIM' => __( 'Lima', 'woofunnels' ),
		'LOR' => __( 'Loreto', 'woofunnels' ),
		'MDD' => __( 'Madre de Dios', 'woofunnels' ),
		'MOQ' => __( 'Moquegua', 'woofunnels' ),
		'PAS' => __( 'Pasco', 'woofunnels' ),
		'PIU' => __( 'Piura', 'woofunnels' ),
		'PUN' => __( 'Puno', 'woofunnels' ),
		'SAM' => __( 'San Martín', 'woofunnels' ),
		'TAC' => __( 'Tacna', 'woofunnels' ),
		'TUM' => __( 'Tumbes', 'woofunnels' ),
		'UCA' => __( 'Ucayali', 'woofunnels' ),
	),

	/**
	 * Philippine Provinces.
	 */
	'PH' => array(
		'ABR' => __( 'Abra', 'woofunnels' ),
		'AGN' => __( 'Agusan del Norte', 'woofunnels' ),
		'AGS' => __( 'Agusan del Sur', 'woofunnels' ),
		'AKL' => __( 'Aklan', 'woofunnels' ),
		'ALB' => __( 'Albay', 'woofunnels' ),
		'ANT' => __( 'Antique', 'woofunnels' ),
		'APA' => __( 'Apayao', 'woofunnels' ),
		'AUR' => __( 'Aurora', 'woofunnels' ),
		'BAS' => __( 'Basilan', 'woofunnels' ),
		'BAN' => __( 'Bataan', 'woofunnels' ),
		'BTN' => __( 'Batanes', 'woofunnels' ),
		'BTG' => __( 'Batangas', 'woofunnels' ),
		'BEN' => __( 'Benguet', 'woofunnels' ),
		'BIL' => __( 'Biliran', 'woofunnels' ),
		'BOH' => __( 'Bohol', 'woofunnels' ),
		'BUK' => __( 'Bukidnon', 'woofunnels' ),
		'BUL' => __( 'Bulacan', 'woofunnels' ),
		'CAG' => __( 'Cagayan', 'woofunnels' ),
		'CAN' => __( 'Camarines Norte', 'woofunnels' ),
		'CAS' => __( 'Camarines Sur', 'woofunnels' ),
		'CAM' => __( 'Camiguin', 'woofunnels' ),
		'CAP' => __( 'Capiz', 'woofunnels' ),
		'CAT' => __( 'Catanduanes', 'woofunnels' ),
		'CAV' => __( 'Cavite', 'woofunnels' ),
		'CEB' => __( 'Cebu', 'woofunnels' ),
		'COM' => __( 'Compostela Valley', 'woofunnels' ),
		'NCO' => __( 'Cotabato', 'woofunnels' ),
		'DAV' => __( 'Davao del Norte', 'woofunnels' ),
		'DAS' => __( 'Davao del Sur', 'woofunnels' ),
		'DAC' => __( 'Davao Occidental', 'woofunnels' ),
		'DAO' => __( 'Davao Oriental', 'woofunnels' ),
		'DIN' => __( 'Dinagat Islands', 'woofunnels' ),
		'EAS' => __( 'Eastern Samar', 'woofunnels' ),
		'GUI' => __( 'Guimaras', 'woofunnels' ),
		'IFU' => __( 'Ifugao', 'woofunnels' ),
		'ILN' => __( 'Ilocos Norte', 'woofunnels' ),
		'ILS' => __( 'Ilocos Sur', 'woofunnels' ),
		'ILI' => __( 'Iloilo', 'woofunnels' ),
		'ISA' => __( 'Isabela', 'woofunnels' ),
		'KAL' => __( 'Kalinga', 'woofunnels' ),
		'LUN' => __( 'La Union', 'woofunnels' ),
		'LAG' => __( 'Laguna', 'woofunnels' ),
		'LAN' => __( 'Lanao del Norte', 'woofunnels' ),
		'LAS' => __( 'Lanao del Sur', 'woofunnels' ),
		'LEY' => __( 'Leyte', 'woofunnels' ),
		'MAG' => __( 'Maguindanao', 'woofunnels' ),
		'MAD' => __( 'Marinduque', 'woofunnels' ),
		'MAS' => __( 'Masbate', 'woofunnels' ),
		'MSC' => __( 'Misamis Occidental', 'woofunnels' ),
		'MSR' => __( 'Misamis Oriental', 'woofunnels' ),
		'MOU' => __( 'Mountain Province', 'woofunnels' ),
		'NEC' => __( 'Negros Occidental', 'woofunnels' ),
		'NER' => __( 'Negros Oriental', 'woofunnels' ),
		'NSA' => __( 'Northern Samar', 'woofunnels' ),
		'NUE' => __( 'Nueva Ecija', 'woofunnels' ),
		'NUV' => __( 'Nueva Vizcaya', 'woofunnels' ),
		'MDC' => __( 'Occidental Mindoro', 'woofunnels' ),
		'MDR' => __( 'Oriental Mindoro', 'woofunnels' ),
		'PLW' => __( 'Palawan', 'woofunnels' ),
		'PAM' => __( 'Pampanga', 'woofunnels' ),
		'PAN' => __( 'Pangasinan', 'woofunnels' ),
		'QUE' => __( 'Quezon', 'woofunnels' ),
		'QUI' => __( 'Quirino', 'woofunnels' ),
		'RIZ' => __( 'Rizal', 'woofunnels' ),
		'ROM' => __( 'Romblon', 'woofunnels' ),
		'WSA' => __( 'Samar', 'woofunnels' ),
		'SAR' => __( 'Sarangani', 'woofunnels' ),
		'SIQ' => __( 'Siquijor', 'woofunnels' ),
		'SOR' => __( 'Sorsogon', 'woofunnels' ),
		'SCO' => __( 'South Cotabato', 'woofunnels' ),
		'SLE' => __( 'Southern Leyte', 'woofunnels' ),
		'SUK' => __( 'Sultan Kudarat', 'woofunnels' ),
		'SLU' => __( 'Sulu', 'woofunnels' ),
		'SUN' => __( 'Surigao del Norte', 'woofunnels' ),
		'SUR' => __( 'Surigao del Sur', 'woofunnels' ),
		'TAR' => __( 'Tarlac', 'woofunnels' ),
		'TAW' => __( 'Tawi-Tawi', 'woofunnels' ),
		'ZMB' => __( 'Zambales', 'woofunnels' ),
		'ZAN' => __( 'Zamboanga del Norte', 'woofunnels' ),
		'ZAS' => __( 'Zamboanga del Sur', 'woofunnels' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'woofunnels' ),
		'00'  => __( 'Metro Manila', 'woofunnels' ),
	),
	'PK' => array( // Pakistan's states.
		'JK' => __( 'Azad Kashmir', 'woofunnels' ),
		'BA' => __( 'Balochistan', 'woofunnels' ),
		'TA' => __( 'FATA', 'woofunnels' ),
		'GB' => __( 'Gilgit Baltistan', 'woofunnels' ),
		'IS' => __( 'Islamabad Capital Territory', 'woofunnels' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'woofunnels' ),
		'PB' => __( 'Punjab', 'woofunnels' ),
		'SD' => __( 'Sindh', 'woofunnels' ),
	),
	'PL' => array(),
	'PT' => array(),
	'PY' => array( // Paraguay states.
		'PY-ASU' => __( 'Asunción', 'woofunnels' ),
		'PY-1'   => __( 'Concepción', 'woofunnels' ),
		'PY-2'   => __( 'San Pedro', 'woofunnels' ),
		'PY-3'   => __( 'Cordillera', 'woofunnels' ),
		'PY-4'   => __( 'Guairá', 'woofunnels' ),
		'PY-5'   => __( 'Caaguazú', 'woofunnels' ),
		'PY-6'   => __( 'Caazapá', 'woofunnels' ),
		'PY-7'   => __( 'Itapúa', 'woofunnels' ),
		'PY-8'   => __( 'Misiones', 'woofunnels' ),
		'PY-9'   => __( 'Paraguarí', 'woofunnels' ),
		'PY-10'  => __( 'Alto Paraná', 'woofunnels' ),
		'PY-11'  => __( 'Central', 'woofunnels' ),
		'PY-12'  => __( 'Ñeembucú', 'woofunnels' ),
		'PY-13'  => __( 'Amambay', 'woofunnels' ),
		'PY-14'  => __( 'Canindeyú', 'woofunnels' ),
		'PY-15'  => __( 'Presidente Hayes', 'woofunnels' ),
		'PY-16'  => __( 'Alto Paraguay', 'woofunnels' ),
		'PY-17'  => __( 'Boquerón', 'woofunnels' ),
	),
	'RE' => array(),
	'RO' => array( // Romania states.
		'AB' => __( 'Alba', 'woofunnels' ),
		'AR' => __( 'Arad', 'woofunnels' ),
		'AG' => __( 'Argeș', 'woofunnels' ),
		'BC' => __( 'Bacău', 'woofunnels' ),
		'BH' => __( 'Bihor', 'woofunnels' ),
		'BN' => __( 'Bistrița-Năsăud', 'woofunnels' ),
		'BT' => __( 'Botoșani', 'woofunnels' ),
		'BR' => __( 'Brăila', 'woofunnels' ),
		'BV' => __( 'Brașov', 'woofunnels' ),
		'B'  => __( 'București', 'woofunnels' ),
		'BZ' => __( 'Buzău', 'woofunnels' ),
		'CL' => __( 'Călărași', 'woofunnels' ),
		'CS' => __( 'Caraș-Severin', 'woofunnels' ),
		'CJ' => __( 'Cluj', 'woofunnels' ),
		'CT' => __( 'Constanța', 'woofunnels' ),
		'CV' => __( 'Covasna', 'woofunnels' ),
		'DB' => __( 'Dâmbovița', 'woofunnels' ),
		'DJ' => __( 'Dolj', 'woofunnels' ),
		'GL' => __( 'Galați', 'woofunnels' ),
		'GR' => __( 'Giurgiu', 'woofunnels' ),
		'GJ' => __( 'Gorj', 'woofunnels' ),
		'HR' => __( 'Harghita', 'woofunnels' ),
		'HD' => __( 'Hunedoara', 'woofunnels' ),
		'IL' => __( 'Ialomița', 'woofunnels' ),
		'IS' => __( 'Iași', 'woofunnels' ),
		'IF' => __( 'Ilfov', 'woofunnels' ),
		'MM' => __( 'Maramureș', 'woofunnels' ),
		'MH' => __( 'Mehedinți', 'woofunnels' ),
		'MS' => __( 'Mureș', 'woofunnels' ),
		'NT' => __( 'Neamț', 'woofunnels' ),
		'OT' => __( 'Olt', 'woofunnels' ),
		'PH' => __( 'Prahova', 'woofunnels' ),
		'SJ' => __( 'Sălaj', 'woofunnels' ),
		'SM' => __( 'Satu Mare', 'woofunnels' ),
		'SB' => __( 'Sibiu', 'woofunnels' ),
		'SV' => __( 'Suceava', 'woofunnels' ),
		'TR' => __( 'Teleorman', 'woofunnels' ),
		'TM' => __( 'Timiș', 'woofunnels' ),
		'TL' => __( 'Tulcea', 'woofunnels' ),
		'VL' => __( 'Vâlcea', 'woofunnels' ),
		'VS' => __( 'Vaslui', 'woofunnels' ),
		'VN' => __( 'Vrancea', 'woofunnels' ),
	),
	'RS' => array(),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'TH' => array( // Thailand states.
		'TH-37' => __( 'Amnat Charoen', 'woofunnels' ),
		'TH-15' => __( 'Ang Thong', 'woofunnels' ),
		'TH-14' => __( 'Ayutthaya', 'woofunnels' ),
		'TH-10' => __( 'Bangkok', 'woofunnels' ),
		'TH-38' => __( 'Bueng Kan', 'woofunnels' ),
		'TH-31' => __( 'Buri Ram', 'woofunnels' ),
		'TH-24' => __( 'Chachoengsao', 'woofunnels' ),
		'TH-18' => __( 'Chai Nat', 'woofunnels' ),
		'TH-36' => __( 'Chaiyaphum', 'woofunnels' ),
		'TH-22' => __( 'Chanthaburi', 'woofunnels' ),
		'TH-50' => __( 'Chiang Mai', 'woofunnels' ),
		'TH-57' => __( 'Chiang Rai', 'woofunnels' ),
		'TH-20' => __( 'Chonburi', 'woofunnels' ),
		'TH-86' => __( 'Chumphon', 'woofunnels' ),
		'TH-46' => __( 'Kalasin', 'woofunnels' ),
		'TH-62' => __( 'Kamphaeng Phet', 'woofunnels' ),
		'TH-71' => __( 'Kanchanaburi', 'woofunnels' ),
		'TH-40' => __( 'Khon Kaen', 'woofunnels' ),
		'TH-81' => __( 'Krabi', 'woofunnels' ),
		'TH-52' => __( 'Lampang', 'woofunnels' ),
		'TH-51' => __( 'Lamphun', 'woofunnels' ),
		'TH-42' => __( 'Loei', 'woofunnels' ),
		'TH-16' => __( 'Lopburi', 'woofunnels' ),
		'TH-58' => __( 'Mae Hong Son', 'woofunnels' ),
		'TH-44' => __( 'Maha Sarakham', 'woofunnels' ),
		'TH-49' => __( 'Mukdahan', 'woofunnels' ),
		'TH-26' => __( 'Nakhon Nayok', 'woofunnels' ),
		'TH-73' => __( 'Nakhon Pathom', 'woofunnels' ),
		'TH-48' => __( 'Nakhon Phanom', 'woofunnels' ),
		'TH-30' => __( 'Nakhon Ratchasima', 'woofunnels' ),
		'TH-60' => __( 'Nakhon Sawan', 'woofunnels' ),
		'TH-80' => __( 'Nakhon Si Thammarat', 'woofunnels' ),
		'TH-55' => __( 'Nan', 'woofunnels' ),
		'TH-96' => __( 'Narathiwat', 'woofunnels' ),
		'TH-39' => __( 'Nong Bua Lam Phu', 'woofunnels' ),
		'TH-43' => __( 'Nong Khai', 'woofunnels' ),
		'TH-12' => __( 'Nonthaburi', 'woofunnels' ),
		'TH-13' => __( 'Pathum Thani', 'woofunnels' ),
		'TH-94' => __( 'Pattani', 'woofunnels' ),
		'TH-82' => __( 'Phang Nga', 'woofunnels' ),
		'TH-93' => __( 'Phatthalung', 'woofunnels' ),
		'TH-56' => __( 'Phayao', 'woofunnels' ),
		'TH-67' => __( 'Phetchabun', 'woofunnels' ),
		'TH-76' => __( 'Phetchaburi', 'woofunnels' ),
		'TH-66' => __( 'Phichit', 'woofunnels' ),
		'TH-65' => __( 'Phitsanulok', 'woofunnels' ),
		'TH-54' => __( 'Phrae', 'woofunnels' ),
		'TH-83' => __( 'Phuket', 'woofunnels' ),
		'TH-25' => __( 'Prachin Buri', 'woofunnels' ),
		'TH-77' => __( 'Prachuap Khiri Khan', 'woofunnels' ),
		'TH-85' => __( 'Ranong', 'woofunnels' ),
		'TH-70' => __( 'Ratchaburi', 'woofunnels' ),
		'TH-21' => __( 'Rayong', 'woofunnels' ),
		'TH-45' => __( 'Roi Et', 'woofunnels' ),
		'TH-27' => __( 'Sa Kaeo', 'woofunnels' ),
		'TH-47' => __( 'Sakon Nakhon', 'woofunnels' ),
		'TH-11' => __( 'Samut Prakan', 'woofunnels' ),
		'TH-74' => __( 'Samut Sakhon', 'woofunnels' ),
		'TH-75' => __( 'Samut Songkhram', 'woofunnels' ),
		'TH-19' => __( 'Saraburi', 'woofunnels' ),
		'TH-91' => __( 'Satun', 'woofunnels' ),
		'TH-17' => __( 'Sing Buri', 'woofunnels' ),
		'TH-33' => __( 'Sisaket', 'woofunnels' ),
		'TH-90' => __( 'Songkhla', 'woofunnels' ),
		'TH-64' => __( 'Sukhothai', 'woofunnels' ),
		'TH-72' => __( 'Suphan Buri', 'woofunnels' ),
		'TH-84' => __( 'Surat Thani', 'woofunnels' ),
		'TH-32' => __( 'Surin', 'woofunnels' ),
		'TH-63' => __( 'Tak', 'woofunnels' ),
		'TH-92' => __( 'Trang', 'woofunnels' ),
		'TH-23' => __( 'Trat', 'woofunnels' ),
		'TH-34' => __( 'Ubon Ratchathani', 'woofunnels' ),
		'TH-41' => __( 'Udon Thani', 'woofunnels' ),
		'TH-61' => __( 'Uthai Thani', 'woofunnels' ),
		'TH-53' => __( 'Uttaradit', 'woofunnels' ),
		'TH-95' => __( 'Yala', 'woofunnels' ),
		'TH-35' => __( 'Yasothon', 'woofunnels' ),
	),
	'TR' => array( // Turkey States.
		'TR01' => __( 'Adana', 'woofunnels' ),
		'TR02' => __( 'Adıyaman', 'woofunnels' ),
		'TR03' => __( 'Afyon', 'woofunnels' ),
		'TR04' => __( 'Ağrı', 'woofunnels' ),
		'TR05' => __( 'Amasya', 'woofunnels' ),
		'TR06' => __( 'Ankara', 'woofunnels' ),
		'TR07' => __( 'Antalya', 'woofunnels' ),
		'TR08' => __( 'Artvin', 'woofunnels' ),
		'TR09' => __( 'Aydın', 'woofunnels' ),
		'TR10' => __( 'Balıkesir', 'woofunnels' ),
		'TR11' => __( 'Bilecik', 'woofunnels' ),
		'TR12' => __( 'Bingöl', 'woofunnels' ),
		'TR13' => __( 'Bitlis', 'woofunnels' ),
		'TR14' => __( 'Bolu', 'woofunnels' ),
		'TR15' => __( 'Burdur', 'woofunnels' ),
		'TR16' => __( 'Bursa', 'woofunnels' ),
		'TR17' => __( 'Çanakkale', 'woofunnels' ),
		'TR18' => __( 'Çankırı', 'woofunnels' ),
		'TR19' => __( 'Çorum', 'woofunnels' ),
		'TR20' => __( 'Denizli', 'woofunnels' ),
		'TR21' => __( 'Diyarbakır', 'woofunnels' ),
		'TR22' => __( 'Edirne', 'woofunnels' ),
		'TR23' => __( 'Elazığ', 'woofunnels' ),
		'TR24' => __( 'Erzincan', 'woofunnels' ),
		'TR25' => __( 'Erzurum', 'woofunnels' ),
		'TR26' => __( 'Eskişehir', 'woofunnels' ),
		'TR27' => __( 'Gaziantep', 'woofunnels' ),
		'TR28' => __( 'Giresun', 'woofunnels' ),
		'TR29' => __( 'Gümüşhane', 'woofunnels' ),
		'TR30' => __( 'Hakkari', 'woofunnels' ),
		'TR31' => __( 'Hatay', 'woofunnels' ),
		'TR32' => __( 'Isparta', 'woofunnels' ),
		'TR33' => __( 'İçel', 'woofunnels' ),
		'TR34' => __( 'İstanbul', 'woofunnels' ),
		'TR35' => __( 'İzmir', 'woofunnels' ),
		'TR36' => __( 'Kars', 'woofunnels' ),
		'TR37' => __( 'Kastamonu', 'woofunnels' ),
		'TR38' => __( 'Kayseri', 'woofunnels' ),
		'TR39' => __( 'Kırklareli', 'woofunnels' ),
		'TR40' => __( 'Kırşehir', 'woofunnels' ),
		'TR41' => __( 'Kocaeli', 'woofunnels' ),
		'TR42' => __( 'Konya', 'woofunnels' ),
		'TR43' => __( 'Kütahya', 'woofunnels' ),
		'TR44' => __( 'Malatya', 'woofunnels' ),
		'TR45' => __( 'Manisa', 'woofunnels' ),
		'TR46' => __( 'Kahramanmaraş', 'woofunnels' ),
		'TR47' => __( 'Mardin', 'woofunnels' ),
		'TR48' => __( 'Muğla', 'woofunnels' ),
		'TR49' => __( 'Muş', 'woofunnels' ),
		'TR50' => __( 'Nevşehir', 'woofunnels' ),
		'TR51' => __( 'Niğde', 'woofunnels' ),
		'TR52' => __( 'Ordu', 'woofunnels' ),
		'TR53' => __( 'Rize', 'woofunnels' ),
		'TR54' => __( 'Sakarya', 'woofunnels' ),
		'TR55' => __( 'Samsun', 'woofunnels' ),
		'TR56' => __( 'Siirt', 'woofunnels' ),
		'TR57' => __( 'Sinop', 'woofunnels' ),
		'TR58' => __( 'Sivas', 'woofunnels' ),
		'TR59' => __( 'Tekirdağ', 'woofunnels' ),
		'TR60' => __( 'Tokat', 'woofunnels' ),
		'TR61' => __( 'Trabzon', 'woofunnels' ),
		'TR62' => __( 'Tunceli', 'woofunnels' ),
		'TR63' => __( 'Şanlıurfa', 'woofunnels' ),
		'TR64' => __( 'Uşak', 'woofunnels' ),
		'TR65' => __( 'Van', 'woofunnels' ),
		'TR66' => __( 'Yozgat', 'woofunnels' ),
		'TR67' => __( 'Zonguldak', 'woofunnels' ),
		'TR68' => __( 'Aksaray', 'woofunnels' ),
		'TR69' => __( 'Bayburt', 'woofunnels' ),
		'TR70' => __( 'Karaman', 'woofunnels' ),
		'TR71' => __( 'Kırıkkale', 'woofunnels' ),
		'TR72' => __( 'Batman', 'woofunnels' ),
		'TR73' => __( 'Şırnak', 'woofunnels' ),
		'TR74' => __( 'Bartın', 'woofunnels' ),
		'TR75' => __( 'Ardahan', 'woofunnels' ),
		'TR76' => __( 'Iğdır', 'woofunnels' ),
		'TR77' => __( 'Yalova', 'woofunnels' ),
		'TR78' => __( 'Karabük', 'woofunnels' ),
		'TR79' => __( 'Kilis', 'woofunnels' ),
		'TR80' => __( 'Osmaniye', 'woofunnels' ),
		'TR81' => __( 'Düzce', 'woofunnels' ),
	),
	'TZ' => array( // Tanzania States.
		'TZ01' => __( 'Arusha', 'woofunnels' ),
		'TZ02' => __( 'Dar es Salaam', 'woofunnels' ),
		'TZ03' => __( 'Dodoma', 'woofunnels' ),
		'TZ04' => __( 'Iringa', 'woofunnels' ),
		'TZ05' => __( 'Kagera', 'woofunnels' ),
		'TZ06' => __( 'Pemba North', 'woofunnels' ),
		'TZ07' => __( 'Zanzibar North', 'woofunnels' ),
		'TZ08' => __( 'Kigoma', 'woofunnels' ),
		'TZ09' => __( 'Kilimanjaro', 'woofunnels' ),
		'TZ10' => __( 'Pemba South', 'woofunnels' ),
		'TZ11' => __( 'Zanzibar South', 'woofunnels' ),
		'TZ12' => __( 'Lindi', 'woofunnels' ),
		'TZ13' => __( 'Mara', 'woofunnels' ),
		'TZ14' => __( 'Mbeya', 'woofunnels' ),
		'TZ15' => __( 'Zanzibar West', 'woofunnels' ),
		'TZ16' => __( 'Morogoro', 'woofunnels' ),
		'TZ17' => __( 'Mtwara', 'woofunnels' ),
		'TZ18' => __( 'Mwanza', 'woofunnels' ),
		'TZ19' => __( 'Coast', 'woofunnels' ),
		'TZ20' => __( 'Rukwa', 'woofunnels' ),
		'TZ21' => __( 'Ruvuma', 'woofunnels' ),
		'TZ22' => __( 'Shinyanga', 'woofunnels' ),
		'TZ23' => __( 'Singida', 'woofunnels' ),
		'TZ24' => __( 'Tabora', 'woofunnels' ),
		'TZ25' => __( 'Tanga', 'woofunnels' ),
		'TZ26' => __( 'Manyara', 'woofunnels' ),
		'TZ27' => __( 'Geita', 'woofunnels' ),
		'TZ28' => __( 'Katavi', 'woofunnels' ),
		'TZ29' => __( 'Njombe', 'woofunnels' ),
		'TZ30' => __( 'Simiyu', 'woofunnels' ),
	),
	'LK' => array(),
	'SE' => array(),
	'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
		'UG314' => __( 'Abim', 'woofunnels' ),
		'UG301' => __( 'Adjumani', 'woofunnels' ),
		'UG322' => __( 'Agago', 'woofunnels' ),
		'UG323' => __( 'Alebtong', 'woofunnels' ),
		'UG315' => __( 'Amolatar', 'woofunnels' ),
		'UG324' => __( 'Amudat', 'woofunnels' ),
		'UG216' => __( 'Amuria', 'woofunnels' ),
		'UG316' => __( 'Amuru', 'woofunnels' ),
		'UG302' => __( 'Apac', 'woofunnels' ),
		'UG303' => __( 'Arua', 'woofunnels' ),
		'UG217' => __( 'Budaka', 'woofunnels' ),
		'UG218' => __( 'Bududa', 'woofunnels' ),
		'UG201' => __( 'Bugiri', 'woofunnels' ),
		'UG235' => __( 'Bugweri', 'woofunnels' ),
		'UG420' => __( 'Buhweju', 'woofunnels' ),
		'UG117' => __( 'Buikwe', 'woofunnels' ),
		'UG219' => __( 'Bukedea', 'woofunnels' ),
		'UG118' => __( 'Bukomansimbi', 'woofunnels' ),
		'UG220' => __( 'Bukwa', 'woofunnels' ),
		'UG225' => __( 'Bulambuli', 'woofunnels' ),
		'UG416' => __( 'Buliisa', 'woofunnels' ),
		'UG401' => __( 'Bundibugyo', 'woofunnels' ),
		'UG430' => __( 'Bunyangabu', 'woofunnels' ),
		'UG402' => __( 'Bushenyi', 'woofunnels' ),
		'UG202' => __( 'Busia', 'woofunnels' ),
		'UG221' => __( 'Butaleja', 'woofunnels' ),
		'UG119' => __( 'Butambala', 'woofunnels' ),
		'UG233' => __( 'Butebo', 'woofunnels' ),
		'UG120' => __( 'Buvuma', 'woofunnels' ),
		'UG226' => __( 'Buyende', 'woofunnels' ),
		'UG317' => __( 'Dokolo', 'woofunnels' ),
		'UG121' => __( 'Gomba', 'woofunnels' ),
		'UG304' => __( 'Gulu', 'woofunnels' ),
		'UG403' => __( 'Hoima', 'woofunnels' ),
		'UG417' => __( 'Ibanda', 'woofunnels' ),
		'UG203' => __( 'Iganga', 'woofunnels' ),
		'UG418' => __( 'Isingiro', 'woofunnels' ),
		'UG204' => __( 'Jinja', 'woofunnels' ),
		'UG318' => __( 'Kaabong', 'woofunnels' ),
		'UG404' => __( 'Kabale', 'woofunnels' ),
		'UG405' => __( 'Kabarole', 'woofunnels' ),
		'UG213' => __( 'Kaberamaido', 'woofunnels' ),
		'UG427' => __( 'Kagadi', 'woofunnels' ),
		'UG428' => __( 'Kakumiro', 'woofunnels' ),
		'UG101' => __( 'Kalangala', 'woofunnels' ),
		'UG222' => __( 'Kaliro', 'woofunnels' ),
		'UG122' => __( 'Kalungu', 'woofunnels' ),
		'UG102' => __( 'Kampala', 'woofunnels' ),
		'UG205' => __( 'Kamuli', 'woofunnels' ),
		'UG413' => __( 'Kamwenge', 'woofunnels' ),
		'UG414' => __( 'Kanungu', 'woofunnels' ),
		'UG206' => __( 'Kapchorwa', 'woofunnels' ),
		'UG236' => __( 'Kapelebyong', 'woofunnels' ),
		'UG126' => __( 'Kasanda', 'woofunnels' ),
		'UG406' => __( 'Kasese', 'woofunnels' ),
		'UG207' => __( 'Katakwi', 'woofunnels' ),
		'UG112' => __( 'Kayunga', 'woofunnels' ),
		'UG407' => __( 'Kibaale', 'woofunnels' ),
		'UG103' => __( 'Kiboga', 'woofunnels' ),
		'UG227' => __( 'Kibuku', 'woofunnels' ),
		'UG432' => __( 'Kikuube', 'woofunnels' ),
		'UG419' => __( 'Kiruhura', 'woofunnels' ),
		'UG421' => __( 'Kiryandongo', 'woofunnels' ),
		'UG408' => __( 'Kisoro', 'woofunnels' ),
		'UG305' => __( 'Kitgum', 'woofunnels' ),
		'UG319' => __( 'Koboko', 'woofunnels' ),
		'UG325' => __( 'Kole', 'woofunnels' ),
		'UG306' => __( 'Kotido', 'woofunnels' ),
		'UG208' => __( 'Kumi', 'woofunnels' ),
		'UG333' => __( 'Kwania', 'woofunnels' ),
		'UG228' => __( 'Kween', 'woofunnels' ),
		'UG123' => __( 'Kyankwanzi', 'woofunnels' ),
		'UG422' => __( 'Kyegegwa', 'woofunnels' ),
		'UG415' => __( 'Kyenjojo', 'woofunnels' ),
		'UG125' => __( 'Kyotera', 'woofunnels' ),
		'UG326' => __( 'Lamwo', 'woofunnels' ),
		'UG307' => __( 'Lira', 'woofunnels' ),
		'UG229' => __( 'Luuka', 'woofunnels' ),
		'UG104' => __( 'Luwero', 'woofunnels' ),
		'UG124' => __( 'Lwengo', 'woofunnels' ),
		'UG114' => __( 'Lyantonde', 'woofunnels' ),
		'UG223' => __( 'Manafwa', 'woofunnels' ),
		'UG320' => __( 'Maracha', 'woofunnels' ),
		'UG105' => __( 'Masaka', 'woofunnels' ),
		'UG409' => __( 'Masindi', 'woofunnels' ),
		'UG214' => __( 'Mayuge', 'woofunnels' ),
		'UG209' => __( 'Mbale', 'woofunnels' ),
		'UG410' => __( 'Mbarara', 'woofunnels' ),
		'UG423' => __( 'Mitooma', 'woofunnels' ),
		'UG115' => __( 'Mityana', 'woofunnels' ),
		'UG308' => __( 'Moroto', 'woofunnels' ),
		'UG309' => __( 'Moyo', 'woofunnels' ),
		'UG106' => __( 'Mpigi', 'woofunnels' ),
		'UG107' => __( 'Mubende', 'woofunnels' ),
		'UG108' => __( 'Mukono', 'woofunnels' ),
		'UG334' => __( 'Nabilatuk', 'woofunnels' ),
		'UG311' => __( 'Nakapiripirit', 'woofunnels' ),
		'UG116' => __( 'Nakaseke', 'woofunnels' ),
		'UG109' => __( 'Nakasongola', 'woofunnels' ),
		'UG230' => __( 'Namayingo', 'woofunnels' ),
		'UG234' => __( 'Namisindwa', 'woofunnels' ),
		'UG224' => __( 'Namutumba', 'woofunnels' ),
		'UG327' => __( 'Napak', 'woofunnels' ),
		'UG310' => __( 'Nebbi', 'woofunnels' ),
		'UG231' => __( 'Ngora', 'woofunnels' ),
		'UG424' => __( 'Ntoroko', 'woofunnels' ),
		'UG411' => __( 'Ntungamo', 'woofunnels' ),
		'UG328' => __( 'Nwoya', 'woofunnels' ),
		'UG331' => __( 'Omoro', 'woofunnels' ),
		'UG329' => __( 'Otuke', 'woofunnels' ),
		'UG321' => __( 'Oyam', 'woofunnels' ),
		'UG312' => __( 'Pader', 'woofunnels' ),
		'UG332' => __( 'Pakwach', 'woofunnels' ),
		'UG210' => __( 'Pallisa', 'woofunnels' ),
		'UG110' => __( 'Rakai', 'woofunnels' ),
		'UG429' => __( 'Rubanda', 'woofunnels' ),
		'UG425' => __( 'Rubirizi', 'woofunnels' ),
		'UG431' => __( 'Rukiga', 'woofunnels' ),
		'UG412' => __( 'Rukungiri', 'woofunnels' ),
		'UG111' => __( 'Sembabule', 'woofunnels' ),
		'UG232' => __( 'Serere', 'woofunnels' ),
		'UG426' => __( 'Sheema', 'woofunnels' ),
		'UG215' => __( 'Sironko', 'woofunnels' ),
		'UG211' => __( 'Soroti', 'woofunnels' ),
		'UG212' => __( 'Tororo', 'woofunnels' ),
		'UG113' => __( 'Wakiso', 'woofunnels' ),
		'UG313' => __( 'Yumbe', 'woofunnels' ),
		'UG330' => __( 'Zombo', 'woofunnels' ),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'woofunnels' ),
		'84' => __( 'Howland Island', 'woofunnels' ),
		'86' => __( 'Jarvis Island', 'woofunnels' ),
		'67' => __( 'Johnston Atoll', 'woofunnels' ),
		'89' => __( 'Kingman Reef', 'woofunnels' ),
		'71' => __( 'Midway Atoll', 'woofunnels' ),
		'76' => __( 'Navassa Island', 'woofunnels' ),
		'95' => __( 'Palmyra Atoll', 'woofunnels' ),
		'79' => __( 'Wake Island', 'woofunnels' ),
	),
	'US' => array( // United States.
		'AL' => __( 'Alabama', 'woofunnels' ),
		'AK' => __( 'Alaska', 'woofunnels' ),
		'AZ' => __( 'Arizona', 'woofunnels' ),
		'AR' => __( 'Arkansas', 'woofunnels' ),
		'CA' => __( 'California', 'woofunnels' ),
		'CO' => __( 'Colorado', 'woofunnels' ),
		'CT' => __( 'Connecticut', 'woofunnels' ),
		'DE' => __( 'Delaware', 'woofunnels' ),
		'DC' => __( 'District Of Columbia', 'woofunnels' ),
		'FL' => __( 'Florida', 'woofunnels' ),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'woofunnels' ),
		'HI' => __( 'Hawaii', 'woofunnels' ),
		'ID' => __( 'Idaho', 'woofunnels' ),
		'IL' => __( 'Illinois', 'woofunnels' ),
		'IN' => __( 'Indiana', 'woofunnels' ),
		'IA' => __( 'Iowa', 'woofunnels' ),
		'KS' => __( 'Kansas', 'woofunnels' ),
		'KY' => __( 'Kentucky', 'woofunnels' ),
		'LA' => __( 'Louisiana', 'woofunnels' ),
		'ME' => __( 'Maine', 'woofunnels' ),
		'MD' => __( 'Maryland', 'woofunnels' ),
		'MA' => __( 'Massachusetts', 'woofunnels' ),
		'MI' => __( 'Michigan', 'woofunnels' ),
		'MN' => __( 'Minnesota', 'woofunnels' ),
		'MS' => __( 'Mississippi', 'woofunnels' ),
		'MO' => __( 'Missouri', 'woofunnels' ),
		'MT' => __( 'Montana', 'woofunnels' ),
		'NE' => __( 'Nebraska', 'woofunnels' ),
		'NV' => __( 'Nevada', 'woofunnels' ),
		'NH' => __( 'New Hampshire', 'woofunnels' ),
		'NJ' => __( 'New Jersey', 'woofunnels' ),
		'NM' => __( 'New Mexico', 'woofunnels' ),
		'NY' => __( 'New York', 'woofunnels' ),
		'NC' => __( 'North Carolina', 'woofunnels' ),
		'ND' => __( 'North Dakota', 'woofunnels' ),
		'OH' => __( 'Ohio', 'woofunnels' ),
		'OK' => __( 'Oklahoma', 'woofunnels' ),
		'OR' => __( 'Oregon', 'woofunnels' ),
		'PA' => __( 'Pennsylvania', 'woofunnels' ),
		'RI' => __( 'Rhode Island', 'woofunnels' ),
		'SC' => __( 'South Carolina', 'woofunnels' ),
		'SD' => __( 'South Dakota', 'woofunnels' ),
		'TN' => __( 'Tennessee', 'woofunnels' ),
		'TX' => __( 'Texas', 'woofunnels' ),
		'UT' => __( 'Utah', 'woofunnels' ),
		'VT' => __( 'Vermont', 'woofunnels' ),
		'VA' => __( 'Virginia', 'woofunnels' ),
		'WA' => __( 'Washington', 'woofunnels' ),
		'WV' => __( 'West Virginia', 'woofunnels' ),
		'WI' => __( 'Wisconsin', 'woofunnels' ),
		'WY' => __( 'Wyoming', 'woofunnels' ),
		'AA' => __( 'Armed Forces (AA)', 'woofunnels' ),
		'AE' => __( 'Armed Forces (AE)', 'woofunnels' ),
		'AP' => __( 'Armed Forces (AP)', 'woofunnels' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'woofunnels' ),
		'FS'  => __( 'Free State', 'woofunnels' ),
		'GP'  => __( 'Gauteng', 'woofunnels' ),
		'KZN' => __( 'KwaZulu-Natal', 'woofunnels' ),
		'LP'  => __( 'Limpopo', 'woofunnels' ),
		'MP'  => __( 'Mpumalanga', 'woofunnels' ),
		'NC'  => __( 'Northern Cape', 'woofunnels' ),
		'NW'  => __( 'North West', 'woofunnels' ),
		'WC'  => __( 'Western Cape', 'woofunnels' ),
	),
	'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
		'ZM-01' => __( 'Western', 'woofunnels' ),
		'ZM-02' => __( 'Central', 'woofunnels' ),
		'ZM-03' => __( 'Eastern', 'woofunnels' ),
		'ZM-04' => __( 'Luapula', 'woofunnels' ),
		'ZM-05' => __( 'Northern', 'woofunnels' ),
		'ZM-06' => __( 'North-Western', 'woofunnels' ),
		'ZM-07' => __( 'Southern', 'woofunnels' ),
		'ZM-08' => __( 'Copperbelt', 'woofunnels' ),
		'ZM-09' => __( 'Lusaka', 'woofunnels' ),
		'ZM-10' => __( 'Muchinga', 'woofunnels' ),
	),
);
