<?php

abstract class BWFAN_Action {

	/** Action Response Statuses */
	public static $RESPONSE_SUCCESS = 1;
	public static $RESPONSE_FAILED = 2;
	public static $RESPONSE_REATTEMPT = 3;
	public static $RESPONSE_SKIPPED = 4;
	/**
	 * Connector slug for current action. Tells to which connector current action relates to.
	 * @var null
	 */
	public $connector = null;
	/**
	 * For actions which support wysiwyg editor
	 * @var bool
	 */
	public $is_action_tag = false;
	public $automation_id = false;
	public $support_language = false;
	public $support_v2 = false;
	public $support_sideheader = [ 'merge-tag', 'link-trigger' ];
	public $support_v1 = true;
	public $analytics_mode = '';
	protected $localize_data = [];
	protected $action_priority = 0;
	/**
	 * Restrict events on which current action will not shown
	 * @var array
	 */
	protected $excluded_events = array();
	protected $included_events = array();
	/**
	 * Stores current action's data
	 * @var array
	 */
	protected $data = [];
	protected $allowed_responses = [ 200, 201, 202 ];
	/**
	 * Tells to which integration this action belongs to.
	 * @var null
	 */
	protected $fields_missing = false;
	/** @var string Action name */
	protected $action_name = '';
	/** @var string Action description */
	protected $action_desc = '';
	/**
	 * Required fields to run the action.
	 * @var array
	 */
	protected $required_fields = [];
	protected $is_editor_supported = false;
	protected $missing_field = array();
	protected $integration_type = 'wp';

	public function get_random_api_error() {
		return __( 'Api Error: No response from API', 'wp-marketing-automations' );
	}

	public function register_action() {

	}

	public function get_action_priority() {
		return $this->action_priority;
	}

	public function load_hooks() {
		//
	}

	public function get_view() {
		?>
        <script type="text/html" id="tmpl-action-<?php echo esc_js( $this->get_slug() ); ?>">
		</script>
		<?php
	}

	public function get_slug() {
		return str_replace( array( 'bwfan_' ), '', sanitize_title( get_class( $this ) ) );
	}

	public function add_description( $desc, $size = 'm', $position = 'top', $esc = true ) {
		if ( empty( $desc ) ) {
			return '';
		}

		ob_start();
		?>
        <div class="bwfan_tooltip" data-size="<?php echo esc_attr( $size ); ?>">
            <span class="bwfan_tooltip_text" data-position="<?php echo esc_attr( $position ); ?>"><?php echo ( true === $esc ) ? esc_js( $desc ) : $desc; ?></span>
        </div>
		<?php
		$return = ob_get_clean();

		return $return;
	}

	public function inline_template_mergetags_selector_invoke() {
		ob_start();
		?>
        <style>
            .bwfan-crm-icons {
                display: flex;
                align-items: center;
                gap: 10px;
            }

            .bwfan-crm-icons a {
                display: flex;
            }
        </style>
        <div class="bwfan-crm-icons">
            <a href="javascript:void(0)" class="bwfan_inline_merge_tag" data-izimodal-open="#modal-show-merge-tags" data-izimodal-title="Use Merge Tags" data-izimodal-transitionin="comingIn" title="Merge tags">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none">
                    <path d="M16.875 0H3.125C1.40188 0 0 1.40184 0 3.12492V9.99977C0 10.4313 0.349766 10.781 0.78125 10.781H4.6875V19.2179C4.6875 19.7838 5.27355 20.1648 5.79203 19.9291L12.3437 16.9511L18.8955 19.9291C19.4093 20.1626 20 19.7885 20 19.2179V3.12492C20 1.40184 18.5981 0 16.875 0ZM4.6875 9.21855H1.5625V3.12492C1.5625 2.2634 2.26344 1.56246 3.125 1.56246C3.98656 1.56246 4.6875 2.2634 4.6875 3.12492V9.21855ZM18.4375 18.0046L12.667 15.3817C12.4615 15.2883 12.2259 15.2883 12.0204 15.3817L6.25 18.0046V9.99977V3.12492C6.25 2.55594 6.09641 2.02246 5.82957 1.56246H16.875C17.7366 1.56246 18.4375 2.2634 18.4375 3.12492V18.0046Z" fill="#353030"/>
                    <path d="M8.59273 10.7897V10.3222H8.50961C8.41263 10.3222 8.34682 10.3023 8.31219 10.2624C8.27755 10.2226 8.26023 10.1351 8.26023 10.0001C8.26023 9.86844 8.2637 9.73856 8.27062 9.61041C8.27755 9.48226 8.28102 9.34199 8.28102 9.18959C8.28102 8.98178 8.24638 8.83371 8.17711 8.74539C8.10784 8.65707 8.00393 8.59732 7.86539 8.56615V8.54537C8.00393 8.5142 8.10784 8.45445 8.17711 8.36613C8.24638 8.27781 8.28102 8.12975 8.28102 7.92193C8.28102 7.76954 8.27755 7.62926 8.27062 7.50111C8.2637 7.37296 8.26023 7.24308 8.26023 7.11146C8.26023 6.97639 8.27755 6.88893 8.31219 6.8491C8.34682 6.80927 8.41263 6.78936 8.50961 6.78936H8.59273V6.32178H8.22906C7.99008 6.32178 7.81604 6.37719 7.70693 6.48803C7.59783 6.59886 7.54328 6.79628 7.54328 7.08029C7.54328 7.17035 7.54588 7.25001 7.55107 7.31928C7.55627 7.38855 7.56233 7.45436 7.56926 7.5167C7.57618 7.57904 7.58225 7.64225 7.58744 7.70633C7.59264 7.7704 7.59523 7.84227 7.59523 7.92193C7.59523 8.01199 7.56233 8.09511 7.49652 8.17131C7.43072 8.24751 7.31469 8.28907 7.14844 8.296V8.81553C7.31469 8.82245 7.43072 8.86402 7.49652 8.94021C7.56233 9.01641 7.59523 9.09954 7.59523 9.18959C7.59523 9.26925 7.59264 9.34112 7.58744 9.4052C7.58225 9.46927 7.57618 9.53248 7.56926 9.59482C7.56233 9.65717 7.55627 9.72298 7.55107 9.79225C7.54588 9.86152 7.54328 9.94118 7.54328 10.0312C7.54328 10.1732 7.55627 10.2927 7.58225 10.3897C7.60822 10.4867 7.64979 10.5646 7.70693 10.6235C7.76408 10.6824 7.83508 10.7248 7.91994 10.7508C8.0048 10.7768 8.10784 10.7897 8.22906 10.7897H8.59273ZM10.463 10.7897V10.3222H10.3799C10.2829 10.3222 10.2171 10.3023 10.1825 10.2624C10.1479 10.2226 10.1305 10.1351 10.1305 10.0001C10.1305 9.86844 10.134 9.73856 10.1409 9.61041C10.1479 9.48226 10.1513 9.34199 10.1513 9.18959C10.1513 8.98178 10.1167 8.83371 10.0474 8.74539C9.97815 8.65707 9.87424 8.59732 9.7357 8.56615V8.54537C9.87424 8.5142 9.97815 8.45445 10.0474 8.36613C10.1167 8.27781 10.1513 8.12975 10.1513 7.92193C10.1513 7.76954 10.1479 7.62926 10.1409 7.50111C10.134 7.37296 10.1305 7.24308 10.1305 7.11146C10.1305 6.97639 10.1479 6.88893 10.1825 6.8491C10.2171 6.80927 10.2829 6.78936 10.3799 6.78936H10.463V6.32178H10.0994C9.86039 6.32178 9.68635 6.37719 9.57725 6.48803C9.46814 6.59886 9.41359 6.79628 9.41359 7.08029C9.41359 7.17035 9.41619 7.25001 9.42139 7.31928C9.42658 7.38855 9.43264 7.45436 9.43957 7.5167C9.4465 7.57904 9.45256 7.64225 9.45775 7.70633C9.46295 7.7704 9.46555 7.84227 9.46555 7.92193C9.46555 8.01199 9.43264 8.09511 9.36684 8.17131C9.30103 8.24751 9.185 8.28907 9.01875 8.296V8.81553C9.185 8.82245 9.30103 8.86402 9.36684 8.94021C9.43264 9.01641 9.46555 9.09954 9.46555 9.18959C9.46555 9.26925 9.46295 9.34112 9.45775 9.4052C9.45256 9.46927 9.4465 9.53248 9.43957 9.59482C9.43264 9.65717 9.42658 9.72298 9.42139 9.79225C9.41619 9.86152 9.41359 9.94118 9.41359 10.0312C9.41359 10.1732 9.42658 10.2927 9.45256 10.3897C9.47853 10.4867 9.5201 10.5646 9.57725 10.6235C9.63439 10.6824 9.7054 10.7248 9.79025 10.7508C9.87511 10.7768 9.97815 10.7897 10.0994 10.7897H10.463ZM11.5645 10.0624C11.7168 10.0624 11.8415 10.0104 11.9385 9.90654C12.0355 9.80264 12.084 9.67449 12.084 9.52209C12.084 9.36969 12.0355 9.24154 11.9385 9.13764C11.8415 9.03373 11.7168 8.98178 11.5645 8.98178C11.4121 8.98178 11.2874 9.03373 11.1904 9.13764C11.0934 9.24154 11.0449 9.36969 11.0449 9.52209C11.0449 9.67449 11.0934 9.80264 11.1904 9.90654C11.2874 10.0104 11.4121 10.0624 11.5645 10.0624ZM13.227 10.0624C13.3793 10.0624 13.504 10.0104 13.601 9.90654C13.698 9.80264 13.7465 9.67449 13.7465 9.52209C13.7465 9.36969 13.698 9.24154 13.601 9.13764C13.504 9.03373 13.3793 8.98178 13.227 8.98178C13.0746 8.98178 12.9499 9.03373 12.8529 9.13764C12.7559 9.24154 12.7074 9.36969 12.7074 9.52209C12.7074 9.67449 12.7559 9.80264 12.8529 9.90654C12.9499 10.0104 13.0746 10.0624 13.227 10.0624ZM14.692 10.7897C14.8098 10.7897 14.912 10.7768 14.9986 10.7508C15.0851 10.7248 15.157 10.6824 15.2142 10.6235C15.2713 10.5646 15.3129 10.4867 15.3388 10.3897C15.3648 10.2927 15.3778 10.1732 15.3778 10.0312C15.3778 9.94118 15.3752 9.86152 15.37 9.79225C15.3648 9.72298 15.3588 9.65717 15.3518 9.59482C15.3449 9.53248 15.3388 9.46927 15.3337 9.4052C15.3285 9.34112 15.3259 9.26925 15.3259 9.18959C15.3259 9.09954 15.3588 9.01641 15.4246 8.94021C15.4904 8.86402 15.6064 8.82245 15.7727 8.81553V8.296C15.6064 8.28907 15.4904 8.24751 15.4246 8.17131C15.3588 8.09511 15.3259 8.01199 15.3259 7.92193C15.3259 7.84227 15.3285 7.7704 15.3337 7.70633C15.3388 7.64225 15.3449 7.57904 15.3518 7.5167C15.3588 7.45436 15.3648 7.38855 15.37 7.31928C15.3752 7.25001 15.3778 7.17035 15.3778 7.08029C15.3778 6.79628 15.3233 6.59886 15.2142 6.48803C15.1051 6.37719 14.931 6.32178 14.692 6.32178H14.3284V6.78936H14.4115C14.5085 6.78936 14.5743 6.80927 14.6089 6.8491C14.6435 6.88893 14.6609 6.97639 14.6609 7.11146C14.6609 7.24308 14.6574 7.37296 14.6505 7.50111C14.6435 7.62926 14.6401 7.76954 14.6401 7.92193C14.6401 8.12975 14.6747 8.27781 14.744 8.36613C14.8133 8.45445 14.9172 8.5142 15.0557 8.54537V8.56615C14.9172 8.59732 14.8133 8.65707 14.744 8.74539C14.6747 8.83371 14.6401 8.98178 14.6401 9.18959C14.6401 9.34199 14.6435 9.48226 14.6505 9.61041C14.6574 9.73856 14.6609 9.86844 14.6609 10.0001C14.6609 10.1351 14.6435 10.2226 14.6089 10.2624C14.5743 10.3023 14.5085 10.3222 14.4115 10.3222H14.3284V10.7897H14.692ZM16.5623 10.7897C16.6801 10.7897 16.7823 10.7768 16.8689 10.7508C16.9555 10.7248 17.0273 10.6824 17.0845 10.6235C17.1416 10.5646 17.1832 10.4867 17.2092 10.3897C17.2351 10.2927 17.2481 10.1732 17.2481 10.0312C17.2481 9.94118 17.2455 9.86152 17.2403 9.79225C17.2351 9.72298 17.2291 9.65717 17.2221 9.59482C17.2152 9.53248 17.2092 9.46927 17.204 9.4052C17.1988 9.34112 17.1962 9.26925 17.1962 9.18959C17.1962 9.09954 17.2291 9.01641 17.2949 8.94021C17.3607 8.86402 17.4767 8.82245 17.643 8.81553V8.296C17.4767 8.28907 17.3607 8.24751 17.2949 8.17131C17.2291 8.09511 17.1962 8.01199 17.1962 7.92193C17.1962 7.84227 17.1988 7.7704 17.204 7.70633C17.2092 7.64225 17.2152 7.57904 17.2221 7.5167C17.2291 7.45436 17.2351 7.38855 17.2403 7.31928C17.2455 7.25001 17.2481 7.17035 17.2481 7.08029C17.2481 6.79628 17.1936 6.59886 17.0845 6.48803C16.9754 6.37719 16.8013 6.32178 16.5623 6.32178H16.1987V6.78936H16.2818C16.3788 6.78936 16.4446 6.80927 16.4792 6.8491C16.5139 6.88893 16.5312 6.97639 16.5312 7.11146C16.5312 7.24308 16.5277 7.37296 16.5208 7.50111C16.5139 7.62926 16.5104 7.76954 16.5104 7.92193C16.5104 8.12975 16.545 8.27781 16.6143 8.36613C16.6836 8.45445 16.7875 8.5142 16.926 8.54537V8.56615C16.7875 8.59732 16.6836 8.65707 16.6143 8.74539C16.545 8.83371 16.5104 8.98178 16.5104 9.18959C16.5104 9.34199 16.5139 9.48226 16.5208 9.61041C16.5277 9.73856 16.5312 9.86844 16.5312 10.0001C16.5312 10.1351 16.5139 10.2226 16.4792 10.2624C16.4446 10.3023 16.3788 10.3222 16.2818 10.3222H16.1987V10.7897H16.5623Z" fill="#353030"/>
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.59965 6.3829C7.74895 6.23122 7.97065 6.17188 8.22867 6.17188H8.74234V6.93945H8.50922C8.46992 6.93945 8.44493 6.94362 8.43058 6.94796C8.42889 6.94847 8.42744 6.94895 8.42621 6.9494C8.42457 6.95425 8.4223 6.96208 8.41997 6.9738C8.41392 7.00438 8.40984 7.04936 8.40984 7.11156C8.40984 7.24055 8.41324 7.36773 8.42002 7.49311C8.42711 7.6244 8.43062 7.76742 8.43062 7.92203C8.43062 8.13847 8.39613 8.32953 8.29475 8.4588C8.26608 8.49535 8.23363 8.52761 8.19785 8.55586C8.23363 8.58411 8.26608 8.61637 8.29475 8.65292C8.39613 8.78218 8.43062 8.97325 8.43062 9.18969C8.43062 9.3443 8.42711 9.48731 8.42002 9.6186C8.41324 9.74399 8.40984 9.87117 8.40984 10.0002C8.40984 10.0624 8.41392 10.1073 8.41997 10.1379C8.4223 10.1496 8.42457 10.1575 8.42621 10.1623C8.42744 10.1628 8.42889 10.1632 8.43058 10.1638C8.44493 10.1681 8.46992 10.1723 8.50922 10.1723H8.74234V10.9398H8.22867C8.09761 10.9398 7.97886 10.9259 7.87564 10.8943C7.76862 10.8615 7.67509 10.8066 7.59891 10.7281C7.52037 10.6472 7.46809 10.5448 7.43696 10.4286C7.40652 10.315 7.39289 10.1815 7.39289 10.0313C7.39289 9.93856 7.39556 9.85503 7.4011 9.78113C7.40642 9.71026 7.41264 9.64266 7.41978 9.57836C7.42654 9.51753 7.43246 9.4558 7.43754 9.39317C7.44234 9.33394 7.44484 9.26622 7.44484 9.18969C7.44484 9.13993 7.42786 9.09075 7.38261 9.03836C7.3571 9.00882 7.29255 8.97178 7.1418 8.96549L6.99805 8.95951V8.15221L7.1418 8.14622C7.29255 8.13994 7.3571 8.1029 7.38261 8.07336C7.42786 8.02097 7.44484 7.97178 7.44484 7.92203C7.44484 7.8455 7.44234 7.77777 7.43754 7.71855C7.43246 7.65592 7.42654 7.59419 7.41978 7.53336C7.41264 7.46906 7.40642 7.40146 7.4011 7.33059C7.39556 7.25669 7.39289 7.17316 7.39289 7.08039C7.39289 6.78644 7.44752 6.53744 7.59965 6.3829ZM8.22867 6.47188C8.00872 6.47188 7.88234 6.52336 7.81344 6.59335C7.74736 6.66048 7.69289 6.80632 7.69289 7.08039C7.69289 7.16773 7.69542 7.24352 7.70026 7.30816C7.70534 7.37583 7.71124 7.43984 7.71795 7.50023C7.72504 7.56409 7.73125 7.62878 7.73656 7.6943C7.74215 7.76323 7.74484 7.83924 7.74484 7.92203C7.74484 8.05238 7.69602 8.16945 7.60966 8.26945C7.53232 8.359 7.42236 8.40776 7.29805 8.43055V8.68117C7.42236 8.70396 7.53232 8.75272 7.60966 8.84227C7.69602 8.94227 7.74484 9.05934 7.74484 9.18969C7.74484 9.27248 7.74215 9.34849 7.73656 9.41742C7.73125 9.48294 7.72504 9.54763 7.71795 9.61149C7.71124 9.67188 7.70534 9.73589 7.70026 9.80356C7.69542 9.8682 7.69289 9.94399 7.69289 10.0313C7.69289 10.1652 7.70524 10.2707 7.72675 10.351C7.74757 10.4287 7.77842 10.4823 7.81418 10.5191C7.85229 10.5584 7.90076 10.5883 7.96346 10.6074C8.02996 10.6278 8.11729 10.6398 8.22867 10.6398H8.44234V10.4694C8.35367 10.4612 8.26194 10.4338 8.19861 10.3609C8.15606 10.312 8.13634 10.25 8.12569 10.1962C8.11443 10.1393 8.10984 10.073 8.10984 10.0002C8.10984 9.86591 8.11338 9.73333 8.12045 9.60241C8.12721 9.4774 8.13062 9.33987 8.13062 9.18969C8.13062 8.9905 8.09585 8.88543 8.05869 8.83806C8.01589 8.78348 7.94603 8.73823 7.83207 8.71259L7.715 8.68625V8.42547L7.83207 8.39913C7.94603 8.37349 8.01589 8.32824 8.05869 8.27366C8.09585 8.22629 8.13062 8.12122 8.13062 7.92203C8.13062 7.77185 8.12721 7.63432 8.12045 7.50931C8.11338 7.37839 8.10984 7.24581 8.10984 7.11156C8.10984 7.03869 8.11443 6.9724 8.12569 6.91553C8.13634 6.86172 8.15606 6.79969 8.19861 6.75077C8.26194 6.67794 8.35367 6.65051 8.44234 6.64236V6.47188H8.22867ZM9.46996 6.3829C9.61926 6.23122 9.84097 6.17188 10.099 6.17188H10.6127V6.93945H10.3795C10.3402 6.93945 10.3152 6.94362 10.3009 6.94796C10.2992 6.94847 10.2978 6.94895 10.2965 6.9494C10.2949 6.95425 10.2926 6.96208 10.2903 6.9738C10.2842 7.00438 10.2802 7.04936 10.2802 7.11156C10.2802 7.24055 10.2836 7.36773 10.2903 7.49311C10.2974 7.6244 10.3009 7.76742 10.3009 7.92203C10.3009 8.13847 10.2664 8.32953 10.1651 8.4588C10.1364 8.49535 10.1039 8.52761 10.0682 8.55586C10.1039 8.58411 10.1364 8.61637 10.1651 8.65292C10.2664 8.78218 10.3009 8.97325 10.3009 9.18969C10.3009 9.3443 10.2974 9.48731 10.2903 9.6186C10.2836 9.74399 10.2802 9.87117 10.2802 10.0002C10.2802 10.0624 10.2842 10.1073 10.2903 10.1379C10.2926 10.1496 10.2949 10.1575 10.2965 10.1623C10.2978 10.1628 10.2992 10.1632 10.3009 10.1638C10.3152 10.1681 10.3402 10.1723 10.3795 10.1723H10.6127V10.9398H10.099C9.96792 10.9398 9.84917 10.9259 9.74596 10.8943C9.63894 10.8615 9.5454 10.8066 9.46922 10.7281C9.39068 10.6472 9.3384 10.5448 9.30728 10.4286C9.27683 10.315 9.2632 10.1815 9.2632 10.0313C9.2632 9.93856 9.26587 9.85503 9.27142 9.78113C9.27673 9.71026 9.28295 9.64266 9.2901 9.57836C9.29686 9.51753 9.30278 9.4558 9.30785 9.39317C9.31266 9.33394 9.31516 9.26622 9.31516 9.18969C9.31516 9.13993 9.29817 9.09075 9.25292 9.03836C9.22742 9.00882 9.16286 8.97178 9.01211 8.96549L8.86836 8.95951V8.15221L9.01211 8.14622C9.16286 8.13994 9.22742 8.1029 9.25292 8.07336C9.29817 8.02097 9.31516 7.97178 9.31516 7.92203C9.31516 7.8455 9.31266 7.77777 9.30785 7.71855C9.30278 7.65592 9.29686 7.59419 9.2901 7.53336C9.28295 7.46906 9.27673 7.40146 9.27142 7.33059C9.26587 7.25669 9.2632 7.17316 9.2632 7.08039C9.2632 6.78644 9.31783 6.53744 9.46996 6.3829ZM10.099 6.47188C9.87903 6.47188 9.75265 6.52336 9.68375 6.59335C9.61767 6.66048 9.5632 6.80632 9.5632 7.08039C9.5632 7.16773 9.56573 7.24352 9.57058 7.30816C9.57565 7.37583 9.58155 7.43984 9.58826 7.50023C9.59536 7.56409 9.60156 7.62878 9.60687 7.6943C9.61246 7.76323 9.61516 7.83924 9.61516 7.92203C9.61516 8.05238 9.56633 8.16945 9.47997 8.26945C9.40263 8.359 9.29267 8.40776 9.16836 8.43055V8.68117C9.29267 8.70396 9.40263 8.75272 9.47997 8.84227C9.56633 8.94227 9.61516 9.05934 9.61516 9.18969C9.61516 9.27248 9.61246 9.34849 9.60687 9.41742C9.60156 9.48294 9.59536 9.54763 9.58826 9.61149C9.58155 9.67188 9.57565 9.73589 9.57058 9.80356C9.56573 9.8682 9.5632 9.94399 9.5632 10.0313C9.5632 10.1652 9.57555 10.2707 9.59706 10.351C9.61789 10.4287 9.64873 10.4823 9.68449 10.5191C9.7226 10.5584 9.77108 10.5883 9.83377 10.6074C9.90027 10.6278 9.9876 10.6398 10.099 10.6398H10.3127V10.4694C10.224 10.4612 10.1322 10.4338 10.0689 10.3609C10.0264 10.312 10.0067 10.25 9.996 10.1962C9.98474 10.1393 9.98016 10.073 9.98016 10.0002C9.98016 9.86591 9.98369 9.73333 9.99077 9.60241C9.99752 9.4774 10.0009 9.33987 10.0009 9.18969C10.0009 8.9905 9.96616 8.88543 9.929 8.83806C9.8862 8.78348 9.81635 8.73823 9.70239 8.71259L9.58531 8.68625V8.42547L9.70239 8.39913C9.81635 8.37349 9.8862 8.32824 9.929 8.27366C9.96616 8.22629 10.0009 8.12122 10.0009 7.92203C10.0009 7.77185 9.99752 7.63432 9.99077 7.50931C9.98369 7.37839 9.98016 7.24581 9.98016 7.11156C9.98016 7.03869 9.98474 6.9724 9.996 6.91553C10.0067 6.86172 10.0264 6.7997 10.0689 6.75077C10.1322 6.67794 10.224 6.65051 10.3127 6.64236V6.47188H10.099ZM14.178 6.17188H14.6916C14.9497 6.17188 15.1714 6.23122 15.3207 6.3829C15.4728 6.53744 15.5274 6.78645 15.5274 7.08039C15.5274 7.17316 15.5248 7.25669 15.5192 7.33059C15.5139 7.40146 15.5077 7.46906 15.5005 7.53336C15.4938 7.59419 15.4878 7.65592 15.4828 7.71855C15.478 7.77777 15.4755 7.8455 15.4755 7.92203C15.4755 7.97178 15.4925 8.02097 15.5377 8.07336C15.5632 8.1029 15.6278 8.13994 15.7785 8.14622L15.9223 8.15221V8.95951L15.7785 8.96549C15.6278 8.97178 15.5632 9.00882 15.5377 9.03836C15.4925 9.09075 15.4755 9.13994 15.4755 9.18969C15.4755 9.26622 15.478 9.33394 15.4828 9.39317C15.4878 9.4558 15.4938 9.51753 15.5005 9.57836C15.5077 9.64266 15.5139 9.71026 15.5192 9.78113C15.5248 9.85503 15.5274 9.93856 15.5274 10.0313C15.5274 10.1815 15.5138 10.315 15.4833 10.4286C15.4522 10.5448 15.3999 10.6472 15.3214 10.7281C15.2447 10.8071 15.1498 10.862 15.0413 10.8946C14.9372 10.9258 14.8198 10.9398 14.6916 10.9398H14.178V10.1723H14.4111C14.4504 10.1723 14.4754 10.1681 14.4897 10.1638C14.4914 10.1632 14.4929 10.1628 14.4941 10.1623C14.4957 10.1575 14.498 10.1496 14.5003 10.1379C14.5064 10.1073 14.5105 10.0624 14.5105 10.0002C14.5105 9.87117 14.5071 9.74399 14.5003 9.6186C14.4932 9.48731 14.4897 9.3443 14.4897 9.18969C14.4897 8.97325 14.5242 8.78218 14.6256 8.65292C14.6542 8.61637 14.6867 8.58411 14.7225 8.55586C14.6867 8.52761 14.6542 8.49535 14.6256 8.4588C14.5242 8.32953 14.4897 8.13847 14.4897 7.92203C14.4897 7.76742 14.4932 7.6244 14.5003 7.49311C14.5071 7.36773 14.5105 7.24054 14.5105 7.11156C14.5105 7.04936 14.5064 7.00438 14.5003 6.9738C14.498 6.96208 14.4957 6.95425 14.4941 6.9494C14.4929 6.94895 14.4914 6.94847 14.4897 6.94796C14.4754 6.94362 14.4504 6.93945 14.4111 6.93945H14.178V6.17188ZM14.478 6.47188V6.64236C14.5666 6.65051 14.6584 6.67794 14.7217 6.75077C14.7642 6.79969 14.784 6.86172 14.7946 6.91553C14.8059 6.9724 14.8105 7.03869 14.8105 7.11156C14.8105 7.24581 14.8069 7.37839 14.7999 7.50931C14.7931 7.63432 14.7897 7.77185 14.7897 7.92203C14.7897 8.12122 14.8245 8.22629 14.8616 8.27366C14.9044 8.32824 14.9743 8.37349 15.0882 8.39913L15.2053 8.42547V8.68625L15.0882 8.71259C14.9743 8.73823 14.9044 8.78348 14.8616 8.83806C14.8245 8.88543 14.7897 8.9905 14.7897 9.18969C14.7897 9.33987 14.7931 9.4774 14.7999 9.60241C14.8069 9.73333 14.8105 9.86591 14.8105 10.0002C14.8105 10.073 14.8059 10.1393 14.7946 10.1962C14.784 10.25 14.7642 10.312 14.7217 10.3609C14.6584 10.4338 14.5666 10.4612 14.478 10.4694V10.6398H14.6916C14.799 10.6398 14.8859 10.6279 14.9551 10.6072C15.0197 10.5878 15.0686 10.5578 15.1061 10.5191C15.1419 10.4823 15.1727 10.4287 15.1936 10.351C15.2151 10.2707 15.2274 10.1652 15.2274 10.0313C15.2274 9.94399 15.2249 9.8682 15.22 9.80356C15.215 9.73589 15.2091 9.67187 15.2024 9.61149C15.1953 9.54763 15.1891 9.48294 15.1838 9.41742C15.1782 9.34849 15.1755 9.27248 15.1755 9.18969C15.1755 9.05934 15.2243 8.94227 15.3107 8.84227C15.388 8.75272 15.4979 8.70396 15.6223 8.68117V8.43055C15.4979 8.40776 15.388 8.359 15.3107 8.26945C15.2243 8.16945 15.1755 8.05238 15.1755 7.92203C15.1755 7.83924 15.1782 7.76323 15.1838 7.6943C15.1891 7.62878 15.1953 7.56409 15.2024 7.50023C15.2091 7.43984 15.215 7.37583 15.22 7.30816C15.2249 7.24352 15.2274 7.16773 15.2274 7.08039C15.2274 6.80631 15.173 6.66048 15.1069 6.59335C15.038 6.52336 14.9116 6.47188 14.6916 6.47188H14.478ZM16.0483 6.17188H16.562C16.82 6.17188 17.0417 6.23122 17.191 6.3829C17.3431 6.53744 17.3977 6.78644 17.3977 7.08039C17.3977 7.17316 17.3951 7.25669 17.3895 7.33059C17.3842 7.40146 17.378 7.46906 17.3708 7.53336C17.3641 7.59419 17.3582 7.65592 17.3531 7.71855C17.3483 7.77778 17.3458 7.84551 17.3458 7.92203C17.3458 7.97178 17.3628 8.02097 17.408 8.07336C17.4335 8.1029 17.4981 8.13994 17.6488 8.14622L17.7926 8.15221V8.95951L17.6488 8.96549C17.4981 8.97178 17.4335 9.00882 17.408 9.03836C17.3628 9.09075 17.3458 9.13994 17.3458 9.18969C17.3458 9.26621 17.3483 9.33394 17.3531 9.39317C17.3582 9.4558 17.3641 9.51753 17.3708 9.57836C17.378 9.64266 17.3842 9.71026 17.3895 9.78113C17.3951 9.85503 17.3977 9.93856 17.3977 10.0313C17.3977 10.1815 17.3841 10.315 17.3537 10.4286C17.3225 10.5448 17.2703 10.6472 17.1917 10.7281C17.115 10.8071 17.0201 10.862 16.9116 10.8946C16.8075 10.9258 16.6902 10.9398 16.562 10.9398H16.0483V10.1723H16.2814C16.3207 10.1723 16.3457 10.1681 16.36 10.1638C16.3617 10.1632 16.3632 10.1628 16.3644 10.1623C16.3661 10.1575 16.3683 10.1496 16.3706 10.1379C16.3767 10.1073 16.3808 10.0624 16.3808 10.0002C16.3808 9.87117 16.3774 9.74399 16.3706 9.6186C16.3635 9.48731 16.36 9.3443 16.36 9.18969C16.36 8.97325 16.3945 8.78218 16.4959 8.65292C16.5245 8.61637 16.557 8.58411 16.5928 8.55586C16.557 8.52761 16.5245 8.49535 16.4959 8.4588C16.3945 8.32953 16.36 8.13847 16.36 7.92203C16.36 7.76742 16.3635 7.6244 16.3706 7.49311C16.3774 7.36773 16.3808 7.24055 16.3808 7.11156C16.3808 7.04936 16.3767 7.00438 16.3706 6.9738C16.3683 6.96208 16.3661 6.95425 16.3644 6.9494C16.3632 6.94895 16.3617 6.94847 16.36 6.94796C16.3457 6.94362 16.3207 6.93945 16.2814 6.93945H16.0483V6.17188ZM16.3483 6.47188V6.64236C16.437 6.65051 16.5287 6.67794 16.592 6.75077C16.6346 6.7997 16.6543 6.86172 16.6649 6.91553C16.6762 6.9724 16.6808 7.03869 16.6808 7.11156C16.6808 7.24581 16.6772 7.37839 16.6702 7.50931C16.6634 7.63432 16.66 7.77185 16.66 7.92203C16.66 8.12122 16.6948 8.22629 16.7319 8.27366C16.7747 8.32824 16.8446 8.37349 16.9586 8.39913L17.0756 8.42547V8.68625L16.9586 8.71259C16.8446 8.73823 16.7747 8.78348 16.7319 8.83806C16.6948 8.88543 16.66 8.9905 16.66 9.18969C16.66 9.33987 16.6634 9.4774 16.6702 9.60241C16.6772 9.73333 16.6808 9.86591 16.6808 10.0002C16.6808 10.073 16.6762 10.1393 16.6649 10.1962C16.6543 10.25 16.6346 10.312 16.592 10.3609C16.5287 10.4338 16.437 10.4612 16.3483 10.4694V10.6398H16.562C16.6693 10.6398 16.7563 10.6279 16.8254 10.6072C16.89 10.5878 16.9389 10.5578 16.9764 10.5191C17.0122 10.4823 17.0431 10.4287 17.0639 10.351C17.0854 10.2707 17.0977 10.1652 17.0977 10.0313C17.0977 9.94399 17.0952 9.8682 17.0904 9.80356C17.0853 9.73589 17.0794 9.67187 17.0727 9.61149C17.0656 9.54763 17.0594 9.48294 17.0541 9.41742C17.0485 9.34849 17.0458 9.27248 17.0458 9.18969C17.0458 9.05933 17.0946 8.94227 17.181 8.84227C17.2583 8.75272 17.3683 8.70396 17.4926 8.68117V8.43055C17.3683 8.40776 17.2583 8.359 17.181 8.26945C17.0946 8.16945 17.0458 8.05238 17.0458 7.92203C17.0458 7.83923 17.0485 7.76323 17.0541 7.6943C17.0594 7.62878 17.0656 7.56409 17.0727 7.50023C17.0794 7.43985 17.0853 7.37583 17.0904 7.30816C17.0952 7.24352 17.0977 7.16773 17.0977 7.08039C17.0977 6.80632 17.0433 6.66048 16.9772 6.59335C16.9083 6.52336 16.7819 6.47188 16.562 6.47188H16.3483ZM11.0803 9.03539C11.2079 8.89871 11.3734 8.83188 11.5641 8.83188C11.7547 8.83188 11.9202 8.89871 12.0478 9.03539C12.1727 9.16919 12.2336 9.3348 12.2336 9.52219C12.2336 9.70957 12.1727 9.87519 12.0478 10.009C11.9202 10.1457 11.7547 10.2125 11.5641 10.2125C11.3734 10.2125 11.2079 10.1457 11.0803 10.009C10.9555 9.87519 10.8945 9.70957 10.8945 9.52219C10.8945 9.3348 10.9555 9.16919 11.0803 9.03539ZM11.5641 9.13188C11.4499 9.13188 11.3661 9.16894 11.2997 9.24008C11.2306 9.31409 11.1945 9.40478 11.1945 9.52219C11.1945 9.63959 11.2306 9.73028 11.2997 9.80429C11.3661 9.87543 11.4499 9.9125 11.5641 9.9125C11.6782 9.9125 11.7621 9.87543 11.8285 9.80429C11.8975 9.73028 11.9336 9.63959 11.9336 9.52219C11.9336 9.40478 11.8975 9.31409 11.8285 9.24008C11.7621 9.16894 11.6782 9.13188 11.5641 9.13188ZM12.7428 9.03539C12.8704 8.89871 13.0359 8.83188 13.2266 8.83188C13.4172 8.83188 13.5827 8.89871 13.7103 9.03539C13.8352 9.16919 13.8961 9.3348 13.8961 9.52219C13.8961 9.70957 13.8352 9.87519 13.7103 10.009C13.5827 10.1457 13.4172 10.2125 13.2266 10.2125C13.0359 10.2125 12.8704 10.1457 12.7428 10.009C12.618 9.87519 12.557 9.70957 12.557 9.52219C12.557 9.3348 12.618 9.16919 12.7428 9.03539ZM13.2266 9.13188C13.1124 9.13188 13.0286 9.16894 12.9622 9.24008C12.8931 9.31409 12.857 9.40478 12.857 9.52219C12.857 9.63959 12.8931 9.73028 12.9622 9.80429C13.0286 9.87543 13.1124 9.9125 13.2266 9.9125C13.3407 9.9125 13.4246 9.87543 13.491 9.80429C13.56 9.73028 13.5961 9.63959 13.5961 9.52219C13.5961 9.40478 13.56 9.31409 13.491 9.24008C13.4246 9.16894 13.3407 9.13188 13.2266 9.13188Z" fill="#353030"/>
                </svg>
            </a>
            <a href="javascript:void(0)" class="bwfan_inline_merge_tag" data-izimodal-open="#modal-autonami-link-trigger-selector" data-izimodal-title="Use Link Triggers" data-izimodal-transitionin="comingIn" title="Link Triggers">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none">
                    <path d="M10.6196 13.1113C10.9775 13.5897 11.4341 13.9856 11.9584 14.2721C12.4827 14.5585 13.0626 14.7289 13.6585 14.7716C14.2545 14.8143 14.8526 14.7283 15.4124 14.5195C15.9722 14.3106 16.4806 13.9839 16.903 13.5613L19.403 11.0613C20.162 10.2755 20.5819 9.22295 20.5724 8.13046C20.5629 7.03797 20.1247 5.99292 19.3522 5.22039C18.5797 4.44785 17.5346 4.00965 16.4421 4.00016C15.3496 3.99066 14.2971 4.41064 13.5113 5.16963L12.078 6.59463" stroke="#353030" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                    <path d="M13.953 11.4448C13.5951 10.9664 13.1385 10.5705 12.6142 10.2841C12.0898 9.9976 11.51 9.82725 10.9141 9.78457C10.3181 9.74189 9.71998 9.82788 9.16018 10.0367C8.60038 10.2455 8.09204 10.5723 7.66963 10.9948L5.16963 13.4948C4.41064 14.2807 3.99066 15.3332 4.00016 16.4257C4.00965 17.5182 4.44785 18.5632 5.22039 19.3358C5.99292 20.1083 7.03797 20.5465 8.13046 20.556C9.22295 20.5655 10.2755 20.1455 11.0613 19.3865L12.4863 17.9615" stroke="#353030" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </a>
            <a href="javascript:void(0)" class="bwfan_inline_merge_tag" data-izimodal-open="#modal-autonami-template-selector" data-izimodal-title="Templates" data-izimodal-transitionin="comingIn" title="Templates">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M19.8595 1.99609H4.1561C2.97156 1.99609 2.00781 2.95984 2.00781 4.14438V19.8478C2.00781 21.0323 2.97156 21.9961 4.1561 21.9961H19.8595C21.0441 21.9961 22.0078 21.0323 22.0078 19.8478V4.14438C22.0078 2.95984 21.0441 1.99609 19.8595 1.99609V1.99609ZM4.1561 3.16797H19.8595C20.3979 3.16797 20.8359 3.60605 20.8359 4.14438V6.72266H3.17969V4.14438C3.17969 3.60605 3.61777 3.16797 4.1561 3.16797ZM19.8595 20.8242H4.1561C3.61777 20.8242 3.17969 20.3861 3.17969 19.8478V7.89453H20.8359V19.8478C20.8359 20.3861 20.3979 20.8242 19.8595 20.8242Z" fill="#353030"/>
                    <path d="M19.6172 4.96875C19.6172 5.29239 19.3549 5.55469 19.0312 5.55469C18.7076 5.55469 18.4453 5.29239 18.4453 4.96875C18.4453 4.64511 18.7076 4.38281 19.0312 4.38281C19.3549 4.38281 19.6172 4.64511 19.6172 4.96875Z" fill="#353030"/>
                    <path d="M17.2734 4.96875C17.2734 5.29239 17.0111 5.55469 16.6875 5.55469C16.3639 5.55469 16.1016 5.29239 16.1016 4.96875C16.1016 4.64511 16.3639 4.38281 16.6875 4.38281C17.0111 4.38281 17.2734 4.64511 17.2734 4.96875Z" fill="#353030"/>
                    <path d="M14.9297 4.96875C14.9297 5.29239 14.6674 5.55469 14.3438 5.55469C14.0201 5.55469 13.7578 5.29239 13.7578 4.96875C13.7578 4.64511 14.0201 4.38281 14.3438 4.38281C14.6674 4.38281 14.9297 4.64511 14.9297 4.96875Z" fill="#353030"/>
                    <path d="M19.0312 9.07031H4.96875C4.64511 9.07031 4.38281 9.33261 4.38281 9.65625V13.1719C4.38281 13.4955 4.64511 13.7578 4.96875 13.7578H19.0312C19.3549 13.7578 19.6172 13.4955 19.6172 13.1719V9.65625C19.6172 9.33261 19.3549 9.07031 19.0312 9.07031ZM18.4453 12.5859H5.55469V10.2422H18.4453V12.5859Z" fill="#353030"/>
                    <path d="M10.8281 14.9297H4.96875C4.64511 14.9297 4.38281 15.192 4.38281 15.5156V19.0312C4.38281 19.3549 4.64511 19.6172 4.96875 19.6172H10.8281C11.1518 19.6172 11.4141 19.3549 11.4141 19.0312V15.5156C11.4141 15.192 11.1518 14.9297 10.8281 14.9297ZM10.2422 18.4453H5.55469V16.1016H10.2422V18.4453Z" fill="#353030"/>
                    <path d="M19.0312 14.9297H13.1719C12.8482 14.9297 12.5859 15.192 12.5859 15.5156V19.0312C12.5859 19.3549 12.8482 19.6172 13.1719 19.6172H19.0312C19.3549 19.6172 19.6172 19.3549 19.6172 19.0312V15.5156C19.6172 15.192 19.3549 14.9297 19.0312 14.9297ZM18.4453 18.4453H13.7578V16.1016H18.4453V18.4453Z" fill="#353030"/>
                </svg>
            </a>
        </div>
		<?php
		return ob_get_clean();
	}

	public function inline_merge_tag_invoke() {
		ob_start();
		?>
        <a href="javascript:void(0)" class="bwfan_inline_merge_tag" data-izimodal-open="#modal-show-merge-tags" data-izimodal-title="Use Merge Tags" data-izimodal-transitionin="comingIn">
			<?php esc_html_e( 'Merge tags', 'wp-marketing-automations' ); ?>
        </a>
		<?php
		return ob_get_clean();
	}

	/** Add save template option in v1 automation screen when pro is activated  */
	public function save_email_option_template() {
		if ( ! bwfan_is_autonami_pro_active() ) {
			return '';
		}
		ob_start();
		?>
        <a href="javascript:void(0);" class="bwfan_save_template bwfan-mr-10" data-izimodal-open="#modal-autonami-save-as-template" data-izimodal-transitionin="comingIn">
			<?php esc_html_e( "Save as Template", "wp-marketing-automations" ); ?>
        </a>
		<?php
		return ob_get_clean();
	}

	/**
	 * Reset the data of an action
	 */
	public function reset_data() {
		$this->data = [];
	}

	/**
	 * Saves the request data and response data for every action into the DB
	 *
	 * @param $data
	 * @param $response
	 */
	public function save_data( $data, $response ) {

	}

	/**
	 * Checks the required fields for every action
	 *
	 * @param $data
	 * @param $required_fields
	 *
	 * @return bool
	 */
	public function check_fields( $data, $required_fields ) {
		$bool = true;
		foreach ( $required_fields as $single_field ) {
			if ( false === isset( $data[ $single_field ] ) ) {
				$this->missing_field = $single_field;
				$bool                = false;
				break;
			}
		}

		return $bool;
	}

	/**
	 * Return the error
	 *
	 * @return array
	 */
	public function show_fields_error() {
		$message = __( 'Required Field Missing', 'woofunnels' );
		$message .= ': ' . $this->missing_field;

		return array(
			'bwfan_response' => $message,
		);
	}

	/**
	 * Sends a wp remote call
	 *
	 * @param $url
	 * @param array $params
	 * @param int $req_method
	 *
	 * @return array|mixed|object|string
	 */
	public function make_wp_requests( $url, $params = array(), $headers = array(), $req_method = 1 ) {
		$body = array(
			'response' => 500,
			'body'     => __( 'Curl Error', 'wp-marketing-automations' ),
		);

		// $req_method
		// 1 stands for get
		// 2 stands for post
		// 3 stands for delete

		$args = array(
			'timeout'     => 45,
			'httpversion' => '1.0',
			'blocking'    => true,
			'body'        => $params,
		);

		if ( is_array( $headers ) && count( $headers ) > 0 ) {
			$args['headers'] = $headers;
		}

		switch ( $req_method ) {
			case 2:
				$args['method'] = 'POST';
				break;
			case 3:
				$args['method'] = 'DELETE';
				break;
			case 4:
				$args['method'] = 'PUT';
				break;
			case 5:
				$args['method'] = 'PATCH';
				break;
			default:
				$args['method'] = 'GET';
				break;
		}

		$response = wp_remote_request( $url, $args );

		if ( ! is_wp_error( $response ) ) {
			$body    = wp_remote_retrieve_body( $response );
			$headers = wp_remote_retrieve_headers( $response );
			if ( $this->is_json( $body ) ) {
				$body = json_decode( $body, true );
			}
			$body = maybe_unserialize( $body );
			if ( in_array( $response['response']['code'], $this->allowed_responses, true ) ) {
				$response_code = 200;
			} else {
				$response_code = $response['response']['code'];
			}

			$body = array(
				'response' => intval( $response_code ),
				'body'     => $body,
				'headers'  => $headers,
			);

			return $body;
		}

		$body['body'] = [ $response->get_error_message() ];

		return $body;
	}

	/**
	 * check if a string is json or not
	 *
	 * @param $string
	 *
	 * @return bool
	 */
	public function is_json( $string ) {
		json_decode( $string );

		return ( json_last_error() == JSON_ERROR_NONE );//phpcs:ignore WordPress.PHP.StrictComparisons
	}

	public function parse_unsubscribe_link() {
		if ( false === $this->automation_id ) {
			return;
		}

		add_filter( 'bwfan_unsubscribe_link', [ $this, 'bwfan_unsubscribe_link_add_aid' ] );
	}

	public function bwfan_unsubscribe_link_add_aid( $link ) {
		$link = add_query_arg( array(
			'automation_id' => $this->automation_id,
		), $link );

		return $link;
	}

	/**
	 * @param $integration_object BWFAN_Integration
	 * @param $task_meta
	 *
	 * @return array
	 */
	public function make_data( $integration_object, $task_meta ) {

		return $task_meta;
	}

	/**
	 * @param array $automation_data
	 * @param array $step_data
	 *
	 * @return array
	 */
	public function make_v2_data( $automation_data, $step_data ) {

		return array();
	}

	public function process_v2() {
		return $this->success_message();
	}

	public function success_message( $message = '' ) {
		if ( empty( $message ) ) {
			$message = __( 'Action Executed Successfully!', 'wp-marketing-automations' );
		}

		return array(
			'status'  => self::$RESPONSE_SUCCESS,
			'message' => $message,
		);
	}

	public function error_response( $message = '' ) {
		if ( empty( $message ) ) {
			$message = __( 'Unknown error occurred', 'wp-marketing-automations' );
		}

		return array(
			'status'  => self::$RESPONSE_FAILED,
			'message' => $message,
		);
	}

	public function skipped_response( $message = '' ) {
		if ( empty( $message ) ) {
			$message = __( 'Unknown error occurred', 'wp-marketing-automations' );
		}

		return array(
			'status'  => self::$RESPONSE_SKIPPED,
			'message' => $message,
		);
	}

	/**
	 * Execute the current action.
	 * Return 3 for successful execution , 4 for permanent failure.
	 *
	 * @param $action_data
	 *
	 * @return array
	 */
	public function execute_action( $action_data ) {

		$result = [
			'status'  => 0,
			'message' => __( 'Default Resource Message', 'wp-marketing-automations' ),
		];

		$integration = BWFAN_Core()->integration->get_integration( $action_data['integration_slug'] );

		if ( is_null( $integration ) ) {
			return $result;
		}

		$this->set_data( $action_data['processed_data'] );

		if ( $integration->need_connector() ) {
			$load_connector = WFCO_Load_Connectors::get_instance();

			$call_class = $load_connector->get_call( $this->call );
			if ( is_null( $call_class ) ) {
				return $result;
			}
			$call_class->set_data( $action_data['processed_data'] );
			$result = $call_class->process();
			$result = $integration->handle_response( $result, $this->connector, $this->call );
			$result = $this->handle_response( $result, $call_class );

		} else {
			$result = $this->process();
		}

		return $result;
	}

	/**
	 * @param $response
	 * @param $call_object WFCO_Call
	 *
	 * @return mixed
	 */
	protected function handle_response( $response, $call_object = null ) {
		return $response;
	}

	public function process() {
		return '';
	}

	/**
	 * Get the merge tags which are array types and convert their values as comma separated string
	 *
	 * @param $dynamic_array
	 * @param $integration_data
	 *
	 * @return array
	 */
	public function parse_merge_tags( $dynamic_array, $integration_data ) {
		$result = array();
		foreach ( $dynamic_array as $key1 => $value ) {
			if ( is_array( $value ) && count( $value ) > 0 ) {
				$dynamic_array[ $key1 ] = implode( ', ', $value );
			}
		}

		$result['parsed_merge_tags'] = $dynamic_array;
		$result['data']              = $integration_data;

		return $result;
	}

	public function parse_tags_fields( $dynamic_array, $integration_data ) {
		$result         = array();
		$new_merge_tags = array();
		foreach ( $dynamic_array as $key1 => $value ) {
			$key = array_search( '{{' . $key1 . '}}', $integration_data, true );

			if ( is_array( $integration_data ) && count( $integration_data ) > 0 ) {//phpcs:ignore WordPress.PHP.StrictComparisons
				foreach ( $integration_data as $possible_merge_tag ) {
					if ( is_array( $possible_merge_tag ) && count( $possible_merge_tag ) > 0 ) {
						foreach ( $possible_merge_tag as $p_m_t ) {
							if ( strpos( $p_m_t, '{{' . $key1 . '}}' ) !== false ) {
								if ( is_array( $value ) && count( $value ) > 0 ) {
									unset( $integration_data[ $key ] );
									foreach ( $value as $key2 => $value2 ) {
										$integration_data[]               = '{{tag_' . $key2 . '}}';
										$new_merge_tags[ 'tag_' . $key2 ] = str_replace( '{{' . $key1 . '}}', $value2, $p_m_t );
									}
								} elseif ( '' !== $value ) {
									$integration_data[]      = '{{' . $key1 . '}}';
									$new_merge_tags[ $key1 ] = str_replace( '{{' . $key1 . '}}', $value, $p_m_t );
								}
							}
						}
					} else {
						if ( strpos( $possible_merge_tag, '{{' . $key1 . '}}' ) !== false ) {
							if ( is_array( $value ) && count( $value ) > 0 ) {
								unset( $integration_data[ $key ] );
								foreach ( $value as $key2 => $value2 ) {
									$integration_data[]               = '{{tag_' . $key2 . '}}';
									$new_merge_tags[ 'tag_' . $key2 ] = str_replace( '{{' . $key1 . '}}', $value2, $possible_merge_tag );
								}
							} elseif ( '' !== $value ) {
								$integration_data[]      = '{{' . $key1 . '}}';
								$new_merge_tags[ $key1 ] = str_replace( '{{' . $key1 . '}}', $value, $possible_merge_tag );
							}
						}
					}
				}
			}
		}

		$integration_data = array_unique( $integration_data );

		$result['parsed_merge_tags'] = $new_merge_tags;
		$result['data']              = $integration_data;

		return $result;
	}

	public function set_data_for_merge_tags( $task_meta ) {
		$event_slug = $task_meta['event_data']['event_slug'];
		BWFAN_Merge_Tag_Loader::set_data( array(
			'automation_id' => $task_meta['automation_id'],
		) );
		$single_event = BWFAN_Core()->sources->get_event( $event_slug );
		if ( $single_event instanceof BWFAN_Event ) {
			$single_event->set_merge_tags_data( $task_meta ); // This function is written in every event class
		}
	}

	public function get_class_slug() {
		return str_replace( 'bwfan_', '', strtolower( get_class( $this ) ) );
	}

	public function before_executing_task() {

	}

	public function after_executing_task() {

	}

	public function get_integration_type() {
		return $this->integration_type;
	}

	public function set_integration_type( $type ) {
		$this->integration_type = $type;
	}

	public function get_included_events() {
		return $this->included_events;
	}

	public function get_excluded_events() {
		return $this->excluded_events;
	}

	/**
	 * Return localize data of event for frontend UI
	 * @return array
	 */
	public function get_localize_data() {
		$this->localize_data = [
			'included_events'  => $this->included_events,
			'excluded_events'  => $this->excluded_events,
			'action_name'      => $this->action_name,
			'action_desc'      => $this->action_desc,
			'slug'             => $this->get_slug(),
			'support_v1'       => $this->support_v1,
			'required'         => $this->required_fields,
			'support_language' => $this->support_language,
		];

		return apply_filters( 'bwfan_action_' . $this->get_slug() . '_localize_data', $this->localize_data, $this );
	}

	/**
	 * Returns actions data
	 *
	 * @return mixed
	 */
	public function get_action_data_for_api() {
		if ( ! $this->support_v2 ) {
			return [];
		}
		$data                     = $this->localize_data;
		$data['integration_slug'] = $this->integration_type;
		$data['fields']           = method_exists( $this, 'get_fields_schema' ) ? $this->get_fields_schema() : [];
		$data['default_values']   = method_exists( $this, 'get_default_values' ) ? $this->get_default_values() : [];
		$data['side_header']      = $this->support_sideheader;
		$data['support_v2']       = $this->support_v2;
		$data['analytics_mode']   = $this->analytics_mode;

		return $data;
	}

	/**
	 * Returns action side schema
	 *
	 * @return array
	 */
	public function get_fields_schema() {
		return array();
	}

	public function is_editor_supported() {
		return $this->is_editor_supported;
	}

	public function get_data() {
		return $this->data;
	}

	/**
	 * Set the data for every action
	 *
	 * @param $data
	 */
	public function set_data( $data ) {
		$this->data = $data;
	}

	public function get_name() {
		return $this->action_name;
	}

	public function check_required_data( $data ) {
		return true;
	}

	public function get_action_retry_data() {
		return array(
			HOUR_IN_SECONDS, // 1 hr
			6 * HOUR_IN_SECONDS, // 6 hrs
			18 * HOUR_IN_SECONDS, // 18 hrs
		);
	}

	public function __get( $key ) {
		if ( 'call' === $key ) {
			return 'wfco_' . $this->get_slug();
		}
	}

	/** v2 Methods: START */

	public function get_options( $search = '', $identifier = '' ) {
		return [];
	}

	/** v2 Methods: END */

	/**
	 * @param $response
	 *
	 * @return mixed
	 */
	public function handle_response_v2( $response ) {
		return $response;
	}

	/**
	 * to avoid unserialize of the current class
	 */
	public function __wakeup() {
		throw new ErrorException( 'BWFAN_Core can`t converted to string' );
	}

	/**
	 * to avoid serialize of the current class
	 */
	public function __sleep() {
		throw new ErrorException( 'BWFAN_Core can`t converted to string' );
	}

	/**
	 * To avoid cloning of current class
	 */
	protected function __clone() {
	}

}
