import intlTelInput from 'intl-tel-input';

var $j = jQuery.noConflict();

(function ($j) {
	var telInputs = wipiMainJsVars.wpiElements.split(', ');

	for (var i = 0; i < telInputs.length; i++) {

		let telInput = $j(telInputs[i]);

		telInput.after(`<span class="wcipi-label valid-msg hide">${wipiMainJsVars.successMessage}</span>`);
		telInput.after(`<span class="wcipi-label error-msg hide">${wipiMainJsVars.failMessage}</span>`);

		telInput.blur(function () {
			wpisValidateIntPhone(this);
		});

		// validate on phone input keyup
		// telInput.keyup(function (e) {
		// 	wpisValidateIntPhone(this);
		// });

		telInput.keydown(function () {
			wpisHideValidationErrors(this);
		});

		if (telInput.val() && telInput.val().length > 0) {
			setTimeout(function () {
				wpisValidateIntPhone(telInput[0]);
			}, 3000);
		}
	}
})($j);

function wpisHideValidationErrors(telInputEl) {
	$j(telInputEl).removeClass("error");
	$j(telInputEl).parent().parent().find(".error-msg").addClass("hide");
	$j(telInputEl).parent().parent().find(".valid-msg").addClass("hide");
}

function wpisValidateIntPhone(telInputEl) {

	let telInput = $j(telInputEl);

  let itiInstance = intlTelInput.getInstance(telInputEl);

	let errorMsg = telInput.parent().parent().find(".error-msg");
	let validMsg = telInput.parent().parent().find(".valid-msg");

	wpisHideValidationErrors(telInputEl);

	if ( itiInstance && $j.trim(telInput.val())) {
		if ( itiInstance.isValidNumber() ) {
			validMsg.removeClass("hide");
			const nationalPhone = itiInstance.getNumber();
			telInput.val(nationalPhone);

      if ( $j('.woocommerce #payment #place_order').length ) {
        $j('.woocommerce #payment #place_order').prop( "disabled", false );
      }
		} else {
			telInput.addClass("error");
			errorMsg.removeClass("hide");
			validMsg.addClass("hide");
      if ( $j('.woocommerce #payment #place_order').length ) {
        $j('.woocommerce #payment #place_order').prop( "disabled", true );
      }
		}
	}
}