/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.attachments.StreamedAttachments;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.transport.http.AbstractMessageSender;
import org.codehaus.xfire.transport.http.HttpChannel;
import org.codehaus.xfire.transport.http.OutMessageRequestEntity;
import org.codehaus.xfire.util.OutMessageDataSource;
import org.codehaus.xfire.util.STAXUtils;

public class CommonsHttpMessageSender
extends AbstractMessageSender {
    private PostMethod postMethod;
    private HttpClient client;
    private HttpState state;
    private static final String GZIP_CONTENT_ENCODING = "gzip";
    public static final String DISABLE_KEEP_ALIVE = "disable-keep-alive";
    public static final String DISABLE_EXPECT_CONTINUE = "disable.expect-continue";
    public static final String HTTP_CLIENT_PARAMS = "httpClient.params";
    public static final String USER_AGENT = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0; XFire Client +http://xfire.codehaus.org)";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_USER = "http.proxy.user";
    public static final String HTTP_PROXY_PASS = "http.proxy.password";
    public static final String HTTP_STATE = "httpClient.httpstate";
    public static final String HTTP_CLIENT = "httpClient";
    public static final String HTTP_TIMEOUT = "http.timeout";
    public static final String HTTP_CONNECTION_TIMEOUT = "http.connection.timeout";
    public static final String HTTP_CONNECTION_MANAGER_TIMEOUT = "http.connection.manager.timeout";
    public static final String MAX_CONN_PER_HOST = "max.connections.per.host";
    public static final String MAX_TOTAL_CONNECTIONS = "max.total.connections";
    public static final String HTTP_RETRY_COUNT = "http.retry.count";
    public static final String GZIP_ENABLED = "gzip.enabled";
    public static final String GZIP_RESPONSE_ENABLED = "gzip.response.enabled";
    public static final String GZIP_REQUEST_ENABLED = "gzip.request.enabled";
    private static final Log log = LogFactory.getLog((Class)CommonsHttpMessageSender.class);
    public static final String HTTP_HEADERS = "http.custom.headers.map";
    public static final String DISABLE_PROXY_UTILS = "http.disable.proxy.utils";
    public static final String PROXY_UTILS_CLASS = "proxy.utils.class";
    private static final String DEFAULT_PROXY_UTILS_CLASS = "org.codehaus.xfire.transport.http.ProxyUtils";
    private InputStream msgIs;
    private OutMessageDataSource source;
    private boolean useProxyUtils = true;
    private static final int DEFAULT_HTTP_CONNECTION_TIMEOUT = 5000;
    private static final int DEFAULT_HTTP_TIMEOUT = 10000;
    private static final int DEFAULT_HTTP_CONNECTION_MANAGER_TIMEOUT = 2000;
    private static final int DEFAULT_MAX_CONN_PER_HOST = 10;
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 20;
    private static final int DEFAULT_HTTP_RETRY_COUNT = 3;

    public CommonsHttpMessageSender(OutMessage message, MessageContext context) {
        super(message, context);
        Object disableProxyUtils = context.getContextualProperty(DISABLE_PROXY_UTILS);
        if (disableProxyUtils != null) {
            this.useProxyUtils = Boolean.valueOf(disableProxyUtils.toString()) == false;
        }
    }

    public void open() throws IOException, XFireException {
        Map headersMap;
        String username;
        MessageContext context = this.getMessageContext();
        this.createClient();
        this.state = this.getHttpState();
        this.postMethod = new PostMethod(this.getUri());
        if (Boolean.valueOf((String)context.getContextualProperty(DISABLE_KEEP_ALIVE)).booleanValue()) {
            this.postMethod.setRequestHeader("Connection", "Close");
        }
        if ((username = (String)context.getContextualProperty("username")) != null) {
            this.client.getParams().setAuthenticationPreemptive(true);
            String password = (String)context.getContextualProperty("password");
            this.state.setCredentials(AuthScope.ANY, this.getCredentials(username, password));
        }
        if (this.getSoapAction() != null) {
            this.postMethod.setRequestHeader("SOAPAction", this.getQuotedSoapAction());
        }
        OutMessage message = this.getMessage();
        boolean mtomEnabled = Boolean.valueOf((String)context.getContextualProperty("mtom-enabled"));
        Attachments atts = message.getAttachments();
        if (mtomEnabled || atts != null) {
            if (atts == null) {
                atts = new JavaMailAttachments();
                message.setAttachments(atts);
            }
            this.source = new OutMessageDataSource(context, message);
            DataHandler soapHandler = new DataHandler((DataSource)this.source);
            atts.setSoapContentType(HttpChannel.getSoapMimeType(message, false));
            atts.setSoapMessage(new SimpleAttachment(this.source.getName(), soapHandler));
            this.postMethod.setRequestHeader("Content-Type", atts.getContentType());
        } else {
            this.postMethod.setRequestHeader("Content-Type", HttpChannel.getSoapMimeType(this.getMessage(), true));
        }
        if (CommonsHttpMessageSender.isGzipResponseEnabled(context)) {
            this.postMethod.setRequestHeader("Accept-Encoding", GZIP_CONTENT_ENCODING);
        }
        if (CommonsHttpMessageSender.isGzipRequestEnabled(context)) {
            this.postMethod.setRequestHeader("Content-Encoding", GZIP_CONTENT_ENCODING);
        }
        if ((headersMap = (Map)context.getContextualProperty(HTTP_HEADERS)) != null) {
            Iterator iter = headersMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                this.postMethod.addRequestHeader(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    private int getIntValue(String key, int defaultValue) {
        int result = defaultValue;
        MessageContext context = this.getMessageContext();
        String str = (String)context.getContextualProperty(key);
        if (str != null) {
            result = Integer.parseInt(str);
        }
        return result;
    }

    protected HttpClient getClient() {
        return this.client;
    }

    protected synchronized void createClient() {
        MessageContext context = this.getMessageContext();
        this.client = (HttpClient)((HttpChannel)this.getMessage().getChannel()).getProperty(HTTP_CLIENT);
        if (this.client == null) {
            this.client = new HttpClient();
            MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams conParams = new HttpConnectionManagerParams();
            manager.setParams(conParams);
            int maxConnPerHost = this.getIntValue(MAX_CONN_PER_HOST, 10);
            conParams.setDefaultMaxConnectionsPerHost(maxConnPerHost);
            int maxTotalConn = this.getIntValue(MAX_TOTAL_CONNECTIONS, 20);
            conParams.setMaxTotalConnections(maxTotalConn);
            int connTimeout = this.getIntValue(HTTP_CONNECTION_TIMEOUT, 5000);
            conParams.setConnectionTimeout(connTimeout);
            int soTimeout = this.getIntValue(HTTP_TIMEOUT, 10000);
            conParams.setSoTimeout(soTimeout);
            int connectionManagerTimeout = this.getIntValue(HTTP_CONNECTION_MANAGER_TIMEOUT, 2000);
            this.client.getParams().setConnectionManagerTimeout((long)connectionManagerTimeout);
            this.client.setHttpConnectionManager((HttpConnectionManager)manager);
            ((HttpChannel)this.getMessage().getChannel()).setProperty(HTTP_CLIENT, this.client);
            HttpClientParams params = (HttpClientParams)context.getContextualProperty(HTTP_CLIENT_PARAMS);
            if (params == null) {
                params = this.client.getParams();
                this.client.getParams().setParameter("http.useragent", (Object)USER_AGENT);
                boolean disableEC = Boolean.valueOf((String)context.getContextualProperty(DISABLE_EXPECT_CONTINUE));
                this.client.getParams().setBooleanParameter("http.protocol.expect-continue", !disableEC);
                this.client.getParams().setVersion(HttpVersion.HTTP_1_1);
                String timeoutStr = (String)context.getContextualProperty(HTTP_TIMEOUT);
                if (timeoutStr != null) {
                    this.client.getParams().setSoTimeout(Integer.parseInt(timeoutStr));
                }
            } else {
                this.client.setParams(params);
            }
            Object retryHandler = context.getContextualProperty("http.method.retry-handler");
            if (null == retryHandler || !(retryHandler instanceof HttpMethodRetryHandler)) {
                int retryCount = this.getIntValue(HTTP_RETRY_COUNT, 3);
                retryHandler = new DefaultHttpMethodRetryHandler(retryCount, false);
            }
            this.client.getParams().setParameter("http.method.retry-handler", retryHandler);
            if (this.isNonProxyHost(this.getMessage().getUri(), context)) {
                return;
            }
            String proxyHost = (String)context.getContextualProperty(HTTP_PROXY_HOST);
            if (proxyHost == null) {
                proxyHost = System.getProperty(HTTP_PROXY_HOST);
            }
            if (proxyHost != null) {
                String portS = (String)context.getContextualProperty(HTTP_PROXY_PORT);
                if (portS == null) {
                    portS = System.getProperty(HTTP_PROXY_PORT);
                }
                int port = 80;
                if (portS != null) {
                    port = Integer.parseInt(portS);
                }
                this.client.getHostConfiguration().setProxy(proxyHost, port);
                String proxyUser = (String)context.getContextualProperty(HTTP_PROXY_USER);
                String proxyPass = (String)context.getContextualProperty(HTTP_PROXY_PASS);
                if (proxyUser != null && proxyPass != null) {
                    this.getHttpState().setProxyCredentials(AuthScope.ANY, this.getCredentials(proxyUser, proxyPass));
                }
            }
        }
    }

    private boolean isNonProxyHost(String strURI, MessageContext context) {
        if (!this.useProxyUtils) {
            return false;
        }
        if (!this.isJDK5andAbove()) {
            this.useProxyUtils = false;
            return false;
        }
        String className = (String)context.getContextualProperty(PROXY_UTILS_CLASS);
        if (className == null) {
            className = DEFAULT_PROXY_UTILS_CLASS;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Object proxyUtils = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("isNonProxyHost", String.class);
            Boolean result = (Boolean)method.invoke(proxyUtils, strURI);
            return result;
        }
        catch (Exception e) {
            log.debug((Object)("Could not load ProxyUtils class: " + className));
            return false;
        }
    }

    boolean isJDK5andAbove() {
        String v = System.getProperty("java.class.version", "44.0");
        return "49.0".compareTo(v) <= 0;
    }

    static boolean isGzipRequestEnabled(MessageContext context) {
        if (CommonsHttpMessageSender.isGzipEnabled(context)) {
            return true;
        }
        Object gzipReqEnabled = context.getContextualProperty(GZIP_REQUEST_ENABLED);
        return gzipReqEnabled != null && gzipReqEnabled.toString().toLowerCase().equals("true");
    }

    static boolean isGzipEnabled(MessageContext context) {
        Object gzipEnabled = context.getContextualProperty(GZIP_ENABLED);
        return gzipEnabled != null && gzipEnabled.toString().toLowerCase().equals("true");
    }

    static boolean isGzipResponseEnabled(MessageContext context) {
        if (CommonsHttpMessageSender.isGzipEnabled(context)) {
            return true;
        }
        Object gzipResEnabled = context.getContextualProperty(GZIP_RESPONSE_ENABLED);
        return gzipResEnabled != null && gzipResEnabled.toString().toLowerCase().equals("true");
    }

    public void send() throws HttpException, IOException, XFireException {
        boolean chunkingOn = Boolean.valueOf((String)this.getMessageContext().getContextualProperty("urn:xfire:transport:http:chunking-enabled"));
        Object requestEntity = !chunkingOn ? this.getByteArrayRequestEntity() : new OutMessageRequestEntity(this.getMessage(), this.getMessageContext());
        this.getMethod().setRequestEntity(requestEntity);
        this.client.executeMethod(null, (HttpMethod)this.postMethod, this.state);
    }

    public int getStatusCode() {
        return this.postMethod.getStatusCode();
    }

    public boolean hasResponse() {
        Header pair = this.postMethod.getResponseHeader("Content-Type");
        if (pair == null) {
            return false;
        }
        String ct = pair.getValue();
        return ct != null && ct.length() > 0;
    }

    public HttpState getHttpState() {
        HttpState state = (HttpState)((HttpChannel)this.getMessage().getChannel()).getProperty(HTTP_STATE);
        if (state == null) {
            state = new HttpState();
            ((HttpChannel)this.getMessage().getChannel()).setProperty(HTTP_STATE, state);
        }
        return state;
    }

    private RequestEntity getByteArrayRequestEntity() throws IOException, XFireException {
        Attachments atts;
        OutMessage message = this.getMessage();
        MessageContext context = this.getMessageContext();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream os = bos;
        if (CommonsHttpMessageSender.isGzipRequestEnabled(context)) {
            os = new GZIPOutputStream(os);
        }
        if ((atts = message.getAttachments()) != null) {
            atts.write(os);
        } else {
            HttpChannel.writeWithoutAttachments(context, message, os);
        }
        os.close();
        return new ByteArrayRequestEntity(bos.toByteArray());
    }

    public InMessage getInMessage() throws IOException {
        String ct = this.postMethod.getResponseHeader("Content-Type").getValue();
        InputStream in = this.postMethod.getResponseBodyAsStream();
        Header hce = this.postMethod.getResponseHeader("Content-Encoding");
        if (hce != null && hce.getValue().equals(GZIP_CONTENT_ENCODING)) {
            in = new GZIPInputStream(in);
        }
        if (ct.toLowerCase().indexOf("multipart/related") != -1) {
            StreamedAttachments atts = new StreamedAttachments(this.getMessageContext(), in, ct);
            this.msgIs = atts.getSoapMessage().getDataHandler().getInputStream();
            InMessage msg = new InMessage(STAXUtils.createXMLStreamReader(this.msgIs, this.getEncoding(), this.getMessageContext()), this.getUri());
            msg.setAttachments(atts);
            return msg;
        }
        return new InMessage(STAXUtils.createXMLStreamReader(in, this.getEncoding(), this.getMessageContext()), this.getUri());
    }

    public PostMethod getMethod() {
        return this.postMethod;
    }

    public void close() throws XFireException {
        if (this.msgIs != null) {
            try {
                this.msgIs.close();
            }
            catch (IOException e) {
                throw new XFireException("Could not close connection.", e);
            }
        }
        if (this.source != null) {
            this.source.dispose();
        }
        if (this.postMethod != null) {
            this.postMethod.releaseConnection();
        }
    }

    private Credentials getCredentials(String username, String password) {
        this.client.getParams().setAuthenticationPreemptive(true);
        int domainIndex = username.indexOf(92);
        if (domainIndex > 0 && username.length() > domainIndex + 1) {
            return new NTCredentials(username.substring(domainIndex + 1), password, "localhost", username.substring(0, domainIndex));
        }
        return new UsernamePasswordCredentials(username, password);
    }
}

