/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.http;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.util.STAXUtils;

public class HtmlServiceWriter {
    private HttpServletRequest request;
    private static final String XHTML_STRICT_DTD = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";

    public HtmlServiceWriter() {
    }

    public HtmlServiceWriter(HttpServletRequest request) {
        this.request = request;
    }

    public void write(OutputStream out, Collection services) throws XMLStreamException {
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(out, null, null);
        writer.writeStartDocument();
        this.writePreamble(writer, "XFire Services");
        writer.writeStartElement("body");
        writer.writeStartElement("p");
        writer.writeEndElement();
        if (!services.isEmpty()) {
            writer.writeStartElement("p");
            writer.writeCharacters("Available Services:");
            writer.writeEndElement();
            writer.writeStartElement("ul");
            int port = this.request.getServerPort();
            StringBuffer sb = new StringBuffer();
            sb.append(this.request.getScheme()).append("://").append(this.request.getServerName());
            if (port != 80 && port != 443 && port != 0) {
                sb.append(':').append(port);
            }
            if (this.request.getServletPath().startsWith("/")) {
                sb.append(this.request.getContextPath());
                sb.append(this.request.getServletPath());
                sb.append("/");
            } else {
                sb.append("".equals(this.request.getContextPath()) ? "/" : this.request.getContextPath());
                sb.append(this.request.getServletPath());
            }
            String base = sb.toString();
            ArrayList servicesList = new ArrayList();
            servicesList.addAll(services);
            Collections.sort(servicesList, new ServiceComperator());
            services = servicesList;
            Iterator iterator = services.iterator();
            while (iterator.hasNext()) {
                String[] parts;
                Service service = (Service)iterator.next();
                String simpleName = service.getSimpleName();
                if (simpleName != null && (parts = simpleName.split("/")).length > 0 && parts[0].equals(port + "")) {
                    simpleName = simpleName.substring(simpleName.indexOf("/") + 1);
                }
                String url = base + simpleName + "?wsdl";
                writer.writeStartElement("li");
                writer.writeCharacters(simpleName);
                Object obj = service.getProperty("wsdl.generation.disabled");
                if (obj == null || "false".equals(obj.toString().toLowerCase())) {
                    writer.writeCharacters(" ");
                    writer.writeStartElement("a");
                    writer.writeAttribute("href", url);
                    writer.writeCharacters("[wsdl]");
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeComment("Just filling space according to http://support.microsoft.com/default.aspx?scid=kb;en-us;Q294807");
        writer.writeComment("Just filling space according to http://support.microsoft.com/default.aspx?scid=kb;en-us;Q294807");
        writer.writeEmptyElement("br");
        writer.writeEmptyElement("br");
        writer.writeEmptyElement("br");
        writer.writeEmptyElement("br");
        writer.writeEmptyElement("br");
        writer.writeCharacters("       Generated by XFire ( http://xfire.codehaus.org ) ");
        writer.writeEmptyElement("hr");
        writer.writeEndDocument();
        writer.flush();
    }

    public void write(OutputStream out, Service service) throws XMLStreamException {
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(out, null, null);
        writer.writeStartDocument();
        String title = service.getSimpleName() + " Web Service";
        this.writePreamble(writer, title);
        writer.writeStartElement("body");
        writer.writeStartElement("h1");
        writer.writeCharacters(title);
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
    }

    private void writePreamble(XMLStreamWriter writer, String title) throws XMLStreamException {
        writer.writeDTD(XHTML_STRICT_DTD);
        writer.writeStartElement("html");
        writer.writeStartElement("head");
        writer.writeStartElement("title");
        writer.writeCharacters(title);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    class ServiceComperator
    implements Comparator {
        ServiceComperator() {
        }

        public int compare(Object service1, Object service2) {
            return ((Service)service1).getSimpleName().compareToIgnoreCase(((Service)service2).getSimpleName());
        }
    }
}

