/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.iopentools;

import com.alipay.iopentools.FormatEnums;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SignFrame
extends JFrame {
    private static final int WIDTH = 800;
    private static final int HEIGHT = 600;
    private JTextArea pubKeyTextArea;
    private JTextArea priKeyTextArea;
    private JButton copyPKCS8PubKeyButton;
    private JButton copyPKCS8PriKeyButton;
    private JButton changeFormat;
    private JScrollPane pubScroll;
    private JScrollPane priScroll;

    public SignFrame() {
        Container container = this.getContentPane();
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        this.setLocation((screenSize.width - 800) / 2, (screenSize.height - 600) / 2);
        this.setSize(800, 600);
        this.setResizable(false);
        this.setTitle("RSA2 Key Tool \u2014\u2014 Powered By Openplateform\n");
        this.setFont(new Font("Dialog", 0, 20));
        JLabel pubKeyLabel = new JLabel("publicKey:");
        pubKeyLabel.setBounds(40, 45, 80, 30);
        JLabel priKeyLabel = new JLabel("privateKey:");
        priKeyLabel.setBounds(40, 180, 80, 30);
        this.pubKeyTextArea = new JTextArea(5, 20);
        this.pubKeyTextArea.setLineWrap(true);
        this.pubKeyTextArea.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
        this.pubKeyTextArea.setBounds(120, 45, 520, 140);
        this.priKeyTextArea = new JTextArea(5, 20);
        this.priKeyTextArea.setLineWrap(true);
        this.priKeyTextArea.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
        this.priKeyTextArea.setBounds(120, 180, 520, 340);
        this.pubScroll = new JScrollPane(this.pubKeyTextArea);
        this.pubScroll.setBounds(120, 45, 520, 100);
        this.pubScroll.setVerticalScrollBarPolicy(20);
        this.priScroll = new JScrollPane(this.priKeyTextArea);
        this.priScroll.setBounds(120, 180, 520, 340);
        this.priScroll.setVerticalScrollBarPolicy(20);
        this.copyPKCS8PubKeyButton = new JButton("copy PKCS8 format");
        this.copyPKCS8PubKeyButton.setBounds(645, 50, 150, 30);
        this.copyPKCS8PubKeyButton.setBackground(Color.CYAN);
        this.add(this.copyPKCS8PubKeyButton);
        this.copyPKCS8PriKeyButton = new JButton("copy");
        this.copyPKCS8PriKeyButton.setBounds(645, 300, 150, 30);
        this.copyPKCS8PriKeyButton.setBackground(Color.CYAN);
        this.add(this.copyPKCS8PriKeyButton);
        this.changeFormat = new JButton("change format");
        this.changeFormat.setBounds(645, 330, 150, 30);
        this.changeFormat.setBackground(Color.CYAN);
        this.add(this.changeFormat);
        this.copyPKCS8PubKeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (StringUtils.isBlank(SignFrame.this.pubKeyTextArea.getText())) {
                    JOptionPane.showMessageDialog(SignFrame.this.copyPKCS8PubKeyButton, "can not copy an empty key.", "fail", 2);
                } else {
                    clipboard.setContents(new StringSelection(SignFrame.this.pubKeyTextArea.getText()), null);
                    JOptionPane.showMessageDialog(SignFrame.this.copyPKCS8PubKeyButton, "succeed to copy public key.", "success", 1);
                }
            }
        });
        this.copyPKCS8PriKeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (StringUtils.isBlank(SignFrame.this.priKeyTextArea.getText())) {
                    JOptionPane.showMessageDialog(SignFrame.this.copyPKCS8PriKeyButton, "can not copy an empty key.", "fail", 2);
                } else {
                    clipboard.setContents(new StringSelection(SignFrame.this.priKeyTextArea.getText()), null);
                    String priKeyStr = SignFrame.this.priKeyTextArea.getText();
                    if (SignFrame.getKeyFormat(priKeyStr).getFormat().equals("PKCS8")) {
                        JOptionPane.showMessageDialog(SignFrame.this.copyPKCS8PriKeyButton, "succeed to copy PKCS8 private key.", "success", 1);
                    } else if (SignFrame.getKeyFormat(priKeyStr).getFormat().equals("PKCS1")) {
                        JOptionPane.showMessageDialog(SignFrame.this.copyPKCS8PriKeyButton, "succeed to copy PKCS1 private key.", "success", 1);
                    }
                }
            }
        });
        this.changeFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean isPKC8 = false;
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (StringUtils.isBlank(SignFrame.this.priKeyTextArea.getText())) {
                    JOptionPane.showMessageDialog(SignFrame.this.changeFormat, "can not change format with an empty key.", "fail", 2);
                } else {
                    String originData = SignFrame.this.priKeyTextArea.getText();
                    if (SignFrame.getKeyFormat(originData).getFormat().equals("PKCS8")) {
                        String targetData = SignFrame.privatePKCS8ToPKCS1(originData);
                        clipboard.setContents(new StringSelection(targetData), null);
                        SignFrame.this.priKeyTextArea.setText(targetData);
                        JOptionPane.showMessageDialog(SignFrame.this.changeFormat, "succeed to change from PKCS8 to PKCS1 and has already been copied to the clipboard.", "success", 1);
                    } else if (SignFrame.getKeyFormat(originData).getFormat().equals("PKCS1")) {
                        String targetData = SignFrame.privatePKCS1ToPKCS8(originData);
                        clipboard.setContents(new StringSelection(targetData), null);
                        SignFrame.this.priKeyTextArea.setText(targetData);
                        JOptionPane.showMessageDialog(SignFrame.this.changeFormat, "succeed to change from PKCS1 to PKCS8 and has already been copied to the clipboard.", "success", 1);
                    }
                }
            }
        });
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(null);
        contentPanel.add(pubKeyLabel);
        contentPanel.add(priKeyLabel);
        contentPanel.add(this.copyPKCS8PubKeyButton);
        contentPanel.add(this.copyPKCS8PriKeyButton);
        contentPanel.add(this.pubScroll);
        contentPanel.add(this.priScroll);
        container.add(contentPanel);
        ButtonPanel southPanel = new ButtonPanel(contentPanel);
        container.add((Component)southPanel, "South");
        southPanel.setBackground(new Color(16, 142, 233));
    }

    private Map<String, String> createBtnActionPerformed(ActionEvent event) {
        return SignFrame.genKeys();
    }

    private boolean checkBtnActionPerformed(ActionEvent event, String pubString, String priString) {
        String unsignedStr = "for you, a thousand times over";
        String signedContent = null;
        boolean res = false;
        try {
            signedContent = this.doSign(unsignedStr, priString, "UTF-8");
            res = this.doCheck(unsignedStr, signedContent, pubString, "UTF-8");
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
        return res;
    }

    public String doSign(String content, String privateKey, String charset) throws SignatureException {
        try {
            PrivateKey priKey = this.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(priKey);
            signature.update(content.getBytes(charset));
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64(signed));
        }
        catch (Exception e) {
            throw new SignatureException("RSA\u7b7e\u540d[content = " + content + "; charset = " + charset + "]\u53d1\u751f\u5f02\u5e38!", e);
        }
    }

    public boolean doCheck(String content, String sign, String publicKey, String charset) throws SignatureException {
        try {
            PublicKey pubKey = this.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initVerify(pubKey);
            signature.update(content.getBytes(charset));
            return signature.verify(Base64.decodeBase64(sign.getBytes()));
        }
        catch (Exception e) {
            throw new SignatureException("RSA\u9a8c\u8bc1\u7b7e\u540d[content = " + content + "; charset = " + charset + "; signature = " + sign + "]\u53d1\u751f\u5f02\u5e38!", e);
        }
    }

    private PublicKey getPublicKeyFromX509(String algorithm, ByteArrayInputStream ins) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = IOUtils.toByteArray(ins);
            encodedKey = Base64.decodeBase64(encodedKey);
            return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchAlgorithmException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private PrivateKey getPrivateKeyFromPKCS8(String algorithm, ByteArrayInputStream ins) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = IOUtils.toByteArray(ins);
            encodedKey = Base64.decodeBase64(encodedKey);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
        }
        catch (IOException keyFactory) {
        }
        catch (InvalidKeySpecException keyFactory) {
        }
        catch (NoSuchAlgorithmException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static Map<String, String> genKeys() {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        String privateKeyString = Base64.encodeBase64String(privateKey.getEncoded());
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        String publicKeyString = Base64.encodeBase64String(publicKey.getEncoded());
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("pubKey", publicKeyString);
        keyMap.put("priKey", privateKeyString);
        return keyMap;
    }

    private static FormatEnums getKeyFormat(String data) {
        if (data.length() >= 1580 && data.length() <= 1600) {
            return FormatEnums.PKCS1;
        }
        if (data.length() >= 1620 && data.length() <= 1630) {
            return FormatEnums.PKCS8;
        }
        return FormatEnums.OTHERS;
    }

    public static String privatePKCS8ToPKCS1(String keyString) {
        byte[] privateBytes = Base64.decodeBase64(keyString);
        try {
            PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance(privateBytes);
            ASN1Encodable encodeable = pkInfo.parsePrivateKey();
            ASN1Primitive primitive = encodeable.toASN1Primitive();
            byte[] privateKeyPKCS1 = primitive.getEncoded();
            return new String(Base64.encodeBase64(privateKeyPKCS1));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String privatePKCS1ToPKCS8(String keyString) {
        try {
            byte[] privateBytes = Base64.decodeBase64(keyString);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(privateBytes);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, aSN1Primitive);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return new String(Base64.encodeBase64(privateKey.getEncoded()));
        }
        catch (Exception e) {
            return null;
        }
    }

    private class ButtonPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JPanel centerPanel;
        private JButton create;
        private JButton check;
        private JButton clear;

        public ButtonPanel(final JPanel centerPanel) {
            this.centerPanel = centerPanel;
            this.create = new JButton("generate");
            this.clear = new JButton("clear");
            this.check = new JButton("check");
            ButtonGroup group = new ButtonGroup();
            group.add(this.create);
            group.add(this.check);
            group.add(this.clear);
            this.add(this.create);
            this.add(this.clear);
            this.add(this.check);
            this.create.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SignFrame.this.pubKeyTextArea.setText("");
                    SignFrame.this.priKeyTextArea.setText("");
                    Map map = SignFrame.this.createBtnActionPerformed(event);
                    SignFrame.this.pubKeyTextArea.append((String)map.get("pubKey"));
                    SignFrame.this.priKeyTextArea.append((String)map.get("priKey"));
                    JOptionPane.showMessageDialog(centerPanel, "succeed to generate a PKCS8 key pair.", "success", 1);
                }
            });
            this.clear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SignFrame.this.pubKeyTextArea.setText("");
                    SignFrame.this.priKeyTextArea.setText("");
                }
            });
            this.check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String pubKeyStr = SignFrame.this.pubKeyTextArea.getText();
                    String priKeyStr = SignFrame.this.priKeyTextArea.getText();
                    if (StringUtils.isBlank(pubKeyStr) || StringUtils.isBlank(priKeyStr)) {
                        JOptionPane.showMessageDialog(centerPanel, "value can not be empty.", "error", 2);
                        return;
                    }
                    boolean res = false;
                    if (SignFrame.getKeyFormat(priKeyStr).getFormat().equals("PKCS8")) {
                        res = SignFrame.this.checkBtnActionPerformed(event, pubKeyStr, priKeyStr);
                        if (res) {
                            JOptionPane.showMessageDialog(centerPanel, "succeed to verify PKCS8 public key and PKCS8 private key.", "success", 1);
                        } else {
                            JOptionPane.showMessageDialog(centerPanel, "failed to verify PKCS8 public key and PKCS8 private key.", "fail", 2);
                        }
                    } else if (SignFrame.getKeyFormat(priKeyStr).getFormat().equals("PKCS1")) {
                        String targetData = SignFrame.privatePKCS1ToPKCS8(priKeyStr);
                        res = SignFrame.this.checkBtnActionPerformed(event, pubKeyStr, targetData);
                        if (res) {
                            JOptionPane.showMessageDialog(centerPanel, "succeed to verify PKCS8 public key and PKCS1 private key.", "success", 1);
                        } else {
                            JOptionPane.showMessageDialog(centerPanel, "failed to verify PKCS8 public key and PKCS1 private key.", "fail", 2);
                        }
                    }
                }
            });
        }
    }
}

